SUPPORTED_LANGUAGE={"EN":"English","FR":"Francais","ES":"Spanish","DE":"German"};

streettype=    {
        "FR": ["rue", "boulevard","bd",  "blvd", "avenue", "chemin", "rte", "route","impasse","pont","pt","parvis","passage", "place","plage","quai", "sentier", "voie", "cote"],
        "EN": ["allee", "alley", "anex", "arcade", "avenue", "bay", "bayou", "beach", "bend", "bluff", "bottom", "blvd", "boulevard", "branch", "bridge", "creek", "crossroad", "esplanade", "express", "expressway", "fort",  "garden", "gateway", "highway",  "hill", "hiway", "hollow", "inlet", "island", "isle",  "lake",  "lane", "light", "motorway", "mountain", "passage", "path", "place", "plain", "plaines", "plaza", "point", "port", , "quay", "road", "rue", "route", "square", "station", "street",  "tunnel",  "valley", "viaduct"] ,
	"ES":["transversal","rua","puerto","plaza","puente","glorieta","carrera","camino","passatge","autovia","autopista"],
        "DE":[],//no prefix for street in germany due to compound(always suffix?)
};
    

placetype={
"AdmBuilding":
        {
        "FR": ["bâtiment administratif", "bâtiment public"],
        "EN":["public building","administrative building"],
	"ES":["administartivo edificion"],
        "DE":[],
        },
"Airport":{"FR": ["aéroport","aérodrome"],
        "EN":["airport"],
        "ES":["aeropuerto"],
        "DE":[],},
"Ambulance":{"FR": ["ambulance"],
        "EN":["ambulance"],
        "ES":["ambulancia"],
        "DE":[],},
"AmusePark":{"FR": ["parc d'attraction", "aire de jeux" ],
        "EN":["amuse park"],
        "ES":[],
        "DE":[],},
"Aqueduc":{"FR": ["aqueduc"],
        "EN":["aqueduc"],
        "ES":["Acueducto"],
        "DE":[],},
"ATM":{"FR": ["distributeur automatique de billets","DAB"],
        "EN":["ATM","automated teller machines"],
        "ES":["Cajero Automático"],
        "DE":[],},
"Bank":{"FR": ["banque"],
        "EN":["bank"],
        "ES":["Banco"],
        "DE":[],},
"Bar":{"FR": ["bar","café","bistro"],
        "EN":["bar","cafe","pub"],
        "ES":["Bar"],
        "DE":[],},
"Bay":{"FR": ["baie"],
        "EN":["bay"],
        "ES":["Bahía"],
        "DE":[],},
"Beach":{"FR": ["plage"],
        "EN":["beach"],
        "ES":["Playa"],
        "DE":[],},
"Bridge":{"FR": ["pont"],
        "EN":["bridge"],
        "ES":["Puente"],
        "DE":[],},
"Building":{"FR": ["bâtiment"],
        "EN":["building"],
        "ES":["Edificion"],
        "DE":[],},
"BusStation":{"FR": ["bus","arrêt de bus"],
        "EN":["bus","bus station"],
        "ES":["Parada de Bus"],
        "DE":[],},
"Camp":{"FR": ["camp"],
        "EN":["camp"],
        "ES":["Campamento"],
        "DE":[],},
"Camping":{"FR": ["camping"],
        "EN":["camping", "campsite", "campground"],
        "ES":["Camping"],
        "DE":[],},
"Canyon":{"FR": ["canyon"],
        "EN":["canyon"],
        "ES":["Cañón"],
        "DE":[],},
"Casino":{"FR": ["casino"],
        "EN":["casino"],
        "ES":["Casino"],
        "DE":[],},
"Castle":{"FR": ["château","manoir"],
        "EN":["castle","manor-house","manor"],
        "ES":["castillo"],
        "DE":[],},
"Cave":{"FR": ["cave"],
        "EN":["cave"],
        "ES":["cueva"],
        "DE":[],},
"Cemetery":{"FR": ["cimetière"],
        "EN":["Cemetery","graveyard"],
        "ES":["Cementerio"],
        "DE":[],},
"Cirque":{"FR": ["Cirque"],
        "EN":["cirque"],
        "ES":["Circo"],
        "DE":[],},
"CityHall":{"FR": ["mairie", "hôtel de ville", "palais de la mairie"],
        "EN":["city Hall","town hall"],
        "ES":["Ayuntamiento"],
        "DE":[],},
"CitySubdivision":{"FR": ["arrondissement","quartier"],
        "EN":["city Subdivision", "quater","neighborhood"],
        "ES":["Municipios"],
        "DE":[],},
"Cliff":{"FR": ["falaise"],
        "EN":["cliff"],
        "ES":["Acantilado"],
        "DE":[],},
"Coast":{"FR": ["cote"],
        "EN":["coast"],
        "ES":["costa"],
        "DE":[],},
"CourtHouse":{"FR": ["palais de justice","tribunal"],
        "EN":["court House", "court"],
        "ES":["Cortes"],
        "DE":[],},
"Craft":{"FR": ["artisan"],
        "EN":["Craft","handworker"],
        "ES":["artesaníá", "artesano"],
        "DE":[],},
"CustomsPost":{"FR": ["poste de douane","douane"],
        "EN":["Customs post"],
        "ES":["aduana"],
        "DE":[],},
"Dam":{"FR": ["barrage"],
        "EN":["dam"],
        "ES":["Presa"],
        "DE":[],},
"Desert":{"FR": ["desert"],
        "EN":["desert"],
        "ES":["desierto"],
        "DE":[],},
"Doctor":{"FR": ["docteur", "médecin","toubib"],
        "EN":["Doctor","physician"],
        "ES":["doctor"],
        "DE":[],},
"Factory":{"FR": ["usine"],
        "EN":["factory","industrial"],
        "ES":["Fábrica"],
        "DE":[],},
"Falls":{"FR": ["chûte d'eau","cascade"],
        "EN":["falls","waterfall"],
        "ES":["Catarátas"],
        "DE":[],},
"Farm":{"FR": ["ferme","exploitation fermière","exploitation agricole"],
        "EN":["farm"],
        "ES":["Granja"],
        "DE":[],},
"Field":{"FR": ["domaine","terrain"],
        "EN":["field"],
        "ES":["Campo"],
        "DE":[],},
"FishingArea":{"FR": ["étang de pêche","lieu pour pêcher","pêche","zone de pêche"],
        "EN":["fishing area","fishing pond","fishing"],
        "ES":["area de pesca","Estanque de pesca"],
        "DE":[],},
"Fjord":{"FR": ["fjord"],
        "EN":["fjord"],
        "ES":["Fiordo"],
        "DE":[],},
"Forest":{"FR": ["forêt"],
        "EN":["forest"],
        "ES":["Bosque"],
        "DE":[],},
"Garden":{"FR": ["jardin","jardin public","jardins familiaux"],
        "EN":["public garden", "garden", "park"],
        "ES":["Jardín público", "Jardín","Parque"],
        "DE":[],},
"Golf":{"FR": ["golf","terrain de golf"],
        "EN":["Golf"],
        "ES":["Golf"],
        "DE":[],},
"Gorge":{"FR": ["gorge"],
        "EN":["Gorge"],
        "ES":["Garganta"],
        "DE":[],},
"GrassLand":{"FR": ["pré","prairie","pâture"],
        "EN":["grassLand","meadow", "prairie", "grassland","pasture"],
        "ES":["Pradera","prado", "pradera", "praderas", "pastos"],
        "DE":[],},
"Gulf":{"FR": ["golfe"],
        "EN":["gulf"],
        "ES":["golfo"],
        "DE":[],},
"Hill":{"FR": ["colline"],
        "EN":["hill"],
        "ES":["Colina"],
        "DE":[],},
"Hospital":{"FR": ["hôpital","clinique"],
        "EN":["hospital","infirmary","hospice","health_centre" ],
        "ES":["hospital", "hospicio"],
        "DE":[],},
"Hotel":{"FR": ["hôtel","motel"],
        "EN":["hotel","motel","inn"],
        "ES":["hotel","motel"],
        "DE":[],},
"Island":{"FR": ["île"],
        "EN":["island"],
        "ES":["Isla"],
        "DE":[],},
"Lake":{"FR": ["lac"],
        "EN":["Lake","lough","lac"],
        "ES":["Lago"],
        "DE":[],},
"Library":{"FR": ["librairie"],
        "EN":["Library","bookcase"],
        "ES":["Biblioteca"],
        "DE":[],},
"LightHouse":{"FR": ["phare"],
        "EN":["light house"],
        "ES":["faro"],
        "DE":[],},
"Mall":{"FR": ["centre commercial","galerie marchande","rue piètonne commerçante","zone commerciale"],
        "EN":["mall","shopping center", "shopping mall", "shops","retails"],
        "ES":["Centro Comercial", "Tiendas"],
        "DE":[],},
"Marsh":{"FR": ["marais","marécage"],
        "EN":["marsh"],
        "ES":["Pantano"],
        "DE":[],},
"MetroStation":{"FR": ["métro","station de métro"],
        "EN":["metro station","metro", "subway", "underground", "tube"],
        "ES":["Estación de metro","metro"],
        "DE":[],},
"Military":{"FR": ["caserne militaire","zone militaire"],
        "EN":["military"],
        "ES":["Militar"],
        "DE":[],},
"Mill":{"FR": ["moulin"],
        "EN":["mill","grinder"],
        "ES":["molino"],
        "DE":[],},
"Mine":{"FR": ["mine"],
        "EN":["mine"],
        "ES":["Mina"],
        "DE":[],},
"Mole":{"FR": ["digue"],
        "EN":["mole"],
        "ES":["Topo"],
        "DE":[],},
"Monument":{"FR": ["monument"],
        "EN":["monument"],
        "ES":["Monumento"],
        "DE":[],},
"Mound":{"FR": ["mont"],
        "EN":["mound"],
        "ES":["Montículo"],
        "DE":[],},
"Mountain":{"FR": ["montagne"],
        "EN":["mountain"],
        "ES":["Montaña"],
        "DE":[],},
"Museum":{"FR": ["musée"],
        "EN":["museum"],
        "ES":["Museo"],
        "DE":[],},
"NightClub":{"FR": ["night Club","club","discothèque","boite de nuit","club de nuit"],
        "EN":["night club", "night spot", "club"],
        "ES":["prostíbulo", "club nocturno"],
        "DE":[],},
"Oasis":{"FR": ["oasis"],
        "EN":["oasis"],
        "ES":["oasis"],
        "DE":[],},
"ObservatoryPoint":{"FR": ["point d'observation"],
        "EN":["observatory point"],
        "ES":["observatorio"],
        "DE":[],},
"OperaHouse":{"FR": ["opéra"],
        "EN":["opera house","opera"],
        "ES":["teatro", "opera"],
        "DE":[],},
"Park":{"FR": ["parc"],
        "EN":["park", "garden", "kinder garten", "kinder garden" ],
        "ES":["Parque", "Jardín"],
        "DE":[],},
"Parking":{"FR": ["parking","parking à vélos","place de parking"],
        "EN":["parking"],
        "ES":["Aparcamiento"],
        "DE":[],},
"Pharmacy":{"FR": ["pharmacie"],
        "EN":["pharmacy"],
        "ES":["farmacia"],
        "DE":[],},
"Picnic":{"FR": ["aire de pique-nique","pique nique"],
        "EN":["Picnic"],
        "ES":["Picnic","merienda"],
        "DE":[],},
"PolicePost":{"FR": ["police","gendarmerie","caserne de gendarmerie","poste de police"],
        "EN":["police station","police", "Police Post","constabulary"],
        "ES":["Policía","Policía Nacional"],
        "DE":[],},
"PoliticalEntity":{"FR": ["bâtiment politique"],
        "EN":["political building", "political entity"],
        "ES":["centro Político"],
        "DE":[],},
"Pond":{"FR": ["étang"],
        "EN":["pond"],
        "ES":["estanque"],
        "DE":[],},
"Port":{"FR": ["port"],
        "EN":["port"],
        "ES":["puerto"],
        "DE":[],},
"PostOffice":{"FR": ["Poste","La poste","bureau de poste","boite aux lettres"],
        "EN":["post office","post","post box",],
        "ES":["oficina de Correos"],
        "DE":[],},
"Prison":{"FR": ["prison","maison d'arrêt"],
        "EN":["prison","jail"],
        "ES":["Prisión", "carcel"],
        "DE":[],},
"Rail":{"FR": ["monorail","train-tram","voie ferrée","tramway","train"],
        "EN":["railway", "railroad", "rail"],
        "ES":["rail", "vías del Tren"],
        "DE":[],},
"RailRoadStation":{"FR": ["gare" ,"gare ferroviaire"],
        "EN":["station", "rail Road station", "rail station"],
        "ES":["estación de Tren"],
        "DE":[],},
"Ranch":{"FR": ["ranch"],
        "EN":["ranch"],
        "ES":["rancho"],
        "DE":[],},
"Religious":{"FR": ["lieu de prière","lieu religieux","chapelle"],
        "EN":["place of worship","religious", "bethel", "place of preayer" , "place of prayer" ,"chapelle","church"],
        "ES":["iglesia", "catedral"],
        "DE":[],},
"Rental":{"FR": ["location"],
        "EN":["rental","location"],
        "ES":["alquiler"],
        "DE":[],},
"RestArea":{"FR": ["aire de repos" ,"aire de services"],
        "EN":["rest area"],
        "ES":["area de descanso"],
        "DE":[],},
"Restaurant":{"FR": ["restaurant"],
        "EN":["restaurant"],
        "ES":["Restaurante"],
        "DE":[],},
"School":{"FR": ["école","lycée","collège","maternelle","faculté","université"],
        "EN":["school","college", "academy", "high school", "secondary school", "lyceum","preschool", "university"],
        "ES":["escuela","colegio", "academia", "universidad", "instituto de educación secundaria", "liceo"],
        "DE":[],},
"Shop":{"FR": ["magasin","commercant","boutique","supermarché","supérette","commerce","marchant","hypermarché"],
        "EN":["Shop,store", "boutique","market","market place", "supermarket"],
        "ES":["tienda", "boutique"],
        "DE":[],},
"Sport":{"FR": ["sport","lieu sportif","salle de sport","gymnase"],
        "EN":["sport","place to do sport","sports ground"],
        "ES":["sport","gimnasio"],
        "DE":[],},
"Stadium":{"FR": ["stade"],
        "EN":["stadium"],
        "ES":["estadio"],
        "DE":[],},
"SwimmingPool":{"FR": ["piscine","parc aquatique","lieu de baignade"],
        "EN":["swimming pool"],
        "ES":["piscina"],
        "DE":[],},
"Taxi":{"FR": ["taxi"],
        "EN":["taxi"],
        "ES":["taxi"],
        "DE":[],},
"Telephone":{"FR": ["téléphone"],
        "EN":["phone","telephone"],
        "ES":["teléfono"],
        "DE":[],},
"Theater":{"FR": ["théâtre"],
        "EN":["theater"],
        "ES":["teatro"],
        "DE":[],},
"Toilet":{"FR": ["toilette"],
        "EN":["toilet"],
        "ES":["aseo", "baño"],
        "DE":[],},
"Tourism":{"FR": ["tourisme","lieu touristique"],
        "EN":["tourism"],
        "ES":["turismo"],
        "DE":[],},
"TourismInfo":{"FR": ["office de tourisme"],
        "EN":["tourism info"],
        "ES":["oficina de Turismo"],
        "DE":[],},
"Tower":{"FR": ["tour"],
        "EN":["tower"],
        "ES":["torre"],
        "DE":[],},
"Tunnel":{"FR": ["tunnel"],
        "EN":["tunnel"],
        "ES":["tunel"],
        "DE":[],},
"VendingMachine":{"FR": ["distributeur de boissons"],
        "EN":["vending machine"],
        "ES":["maquina de vending"],
        "DE":[],},
"Veterinary":{"FR": ["véterinaire","clinique vétérinaire"],
        "EN":["veterinary"],
        "ES":["veterinario"],
        "DE":[],},
"Vineyard":{"FR": ["vignoble"],
        "EN":["vineyard"],
        "ES":["viñedo"],
        "DE":[],},
"Volcano":{"FR": ["volcan"],
        "EN":["volcano"],
        "ES":["volcán"],
        "DE":[],},
"Zoo":{"FR": ["zoo","parc zoologique"],
        "EN":["zoo"],
        "ES":["zoo"],
        "DE":[],},
"Cinema":{"FR": ["cinema","film"],
        "EN":["cinema","film"],
        "ES":["cine", "película", "teatro"],
        "DE":[],},
"Dentist":{"FR": ["dentiste","chirurgien dentiste"],
        "EN":["dentist"],
        "ES":["dentista"],
        "DE":[],},
"EmergencyPhone":{"FR": ["téléphone de secours","DAE","téléphone d'urgence","défibrilateur","poste de secours"],
        "EN":["emergency phone"],
        "ES":["télefono de emergencia"],
        "DE":[],},
"FerryTerminal":{"FR": ["terminal de ferry"],
        "EN":["ferry terminal"],
        "ES":["parada del ferry"],
        "DE":[],},
"FireStation":{"FR": ["pompier","caserne de pompiers"],
        "EN":["fire Station","fire hydrant"],
        "ES":["parque de bomberos"],
        "DE":[],},
"Fountain":{"FR": ["fontaine"],
        "EN":["fountain"],
        "ES":["Fuente"],
        "DE":[],},
"Fuel":{"FR": ["station essence","station service","essence"],
        "EN":["fuel","gas"],
        "ES":["estación de servicio", "gasolinera"],
        "DE":[],}
};

translation={
"near":{
"FR": "près de",
"EN": "near",
"ES": "cerca",
"DE": "nahe"
},
"choosepoitype":{
"FR": "Lieu ou addresse",
"EN": "Place or address",
"ES": "lugar o la dirección",
"DE": "Ort oder adresse"
},
"placeholder":{
"FR": "Entrez un lieu, une addresse, ou une coordonée GPS / DMS",
"EN": "Enter an address, GPS or DMS coordinates",
"ES": "Introduzca una dirección, GPS o DMS coordinan",
"DE": "Geben Sie eine Adresse, GPS-Koordinate oder DMS"
},
"nosuggestion":{
"FR": "Aucune suggestion, cliquer sur le bouton rechercher",
"EN": "no suggestions, please click the search button",
"ES": "ninguna sugerencia, por favor haga clic en el botón de búsqueda",
"DE": "keine Vorschläge, bitte klicken Sie auf die Suchtaste"
},
"searcharound":{
"FR": "chercher aux alentours",
"EN": "search around",
"ES": "buscar alrededor",
"DE": "herumsuchen"
},
"search":{
"FR": "chercher",
"EN": "find",
"ES": "encontrar",
"DE": "Suche"
},
"routeto":{
"FR": "Itinéraire",
"EN": "Route",
"ES": "Ruta",
"DE": "Route"
}


}



charMap = {
'ẚ':'a',
'Á':'a',
'á':'a',
'À':'a',
'à':'a',
'Ă':'a',
'ă':'a',
'Ắ':'a',
'ắ':'a',
'Ằ':'a',
'ằ':'a',
'Ẵ':'a',
'ẵ':'a',
'Ẳ':'a',
'ẳ':'a',
'Â':'a',
'â':'a',
'Ấ':'a',
'ấ':'a',
'Ầ':'a',
'ầ':'a',
'Ẫ':'a',
'ẫ':'a',
'Ẩ':'a',
'ẩ':'a',
'Ǎ':'a',
'ǎ':'a',
'Å':'a',
'å':'a',
'Ǻ':'a',
'ǻ':'a',
'Ä':'a',
'ä':'a',
'Ǟ':'a',
'ǟ':'a',
'Ã':'a',
'ã':'a',
'Ȧ':'a',
'ȧ':'a',
'Ǡ':'a',
'ǡ':'a',
'Ą':'a',
'ą':'a',
'Ā':'a',
'ā':'a',
'Ả':'a',
'ả':'a',
'Ȁ':'a',
'ȁ':'a',
'Ȃ':'a',
'ȃ':'a',
'Ạ':'a',
'ạ':'a',
'Ặ':'a',
'ặ':'a',
'Ậ':'a',
'ậ':'a',
'Ḁ':'a',
'ḁ':'a',
'Ⱥ':'a',
'ⱥ':'a',
'Ǽ':'a',
'ǽ':'a',
'Ǣ':'a',
'ǣ':'a',
'Ḃ':'b',
'ḃ':'b',
'Ḅ':'b',
'ḅ':'b',
'Ḇ':'b',
'ḇ':'b',
'Ƀ':'b',
'ƀ':'b',
'ᵬ':'b',
'Ɓ':'b',
'ɓ':'b',
'Ƃ':'b',
'ƃ':'b',
'Ć':'c',
'ć':'c',
'Ĉ':'c',
'ĉ':'c',
'Č':'c',
'č':'c',
'Ċ':'c',
'ċ':'c',
'Ç':'c',
'ç':'c',
'Ḉ':'c',
'ḉ':'c',
'Ȼ':'c',
'ȼ':'c',
'Ƈ':'c',
'ƈ':'c',
'ɕ':'c',
'Ď':'d',
'ď':'d',
'Ḋ':'d',
'ḋ':'d',
'Ḑ':'d',
'ḑ':'d',
'Ḍ':'d',
'ḍ':'d',
'Ḓ':'d',
'ḓ':'d',
'Ḏ':'d',
'ḏ':'d',
'Đ':'d',
'đ':'d',
'ᵭ':'d',
'Ɖ':'d',
'ɖ':'d',
'Ɗ':'d',
'ɗ':'d',
'Ƌ':'d',
'ƌ':'d',
'ȡ':'d',
'ð':'d',
'É':'e',
'Ə':'e',
'Ǝ':'e',
'ǝ':'e',
'é':'e',
'È':'e',
'è':'e',
'Ĕ':'e',
'ĕ':'e',
'Ê':'e',
'ê':'e',
'Ế':'e',
'ế':'e',
'Ề':'e',
'ề':'e',
'Ễ':'e',
'ễ':'e',
'Ể':'e',
'ể':'e',
'Ě':'e',
'ě':'e',
'Ë':'e',
'ë':'e',
'Ẽ':'e',
'ẽ':'e',
'Ė':'e',
'ė':'e',
'Ȩ':'e',
'ȩ':'e',
'Ḝ':'e',
'ḝ':'e',
'Ę':'e',
'ę':'e',
'Ē':'e',
'ē':'e',
'Ḗ':'e',
'ḗ':'e',
'Ḕ':'e',
'ḕ':'e',
'Ẻ':'e',
'ẻ':'e',
'Ȅ':'e',
'ȅ':'e',
'Ȇ':'e',
'ȇ':'e',
'Ẹ':'e',
'ẹ':'e',
'Ệ':'e',
'ệ':'e',
'Ḙ':'e',
'ḙ':'e',
'Ḛ':'e',
'ḛ':'e',
'Ɇ':'e',
'ɇ':'e',
'ɚ':'e',
'ɝ':'e',
'Ḟ':'f',
'ḟ':'f',
'ᵮ':'f',
'Ƒ':'f',
'ƒ':'f',
'Ǵ':'g',
'ǵ':'g',
'Ğ':'g',
'ğ':'g',
'Ĝ':'g',
'ĝ':'g',
'Ǧ':'g',
'ǧ':'g',
'Ġ':'g',
'ġ':'g',
'Ģ':'g',
'ģ':'g',
'Ḡ':'g',
'ḡ':'g',
'Ǥ':'g',
'ǥ':'g',
'Ɠ':'g',
'ɠ':'g',
'Ĥ':'h',
'ĥ':'h',
'Ȟ':'h',
'ȟ':'h',
'Ḧ':'h',
'ḧ':'h',
'Ḣ':'h',
'ḣ':'h',
'Ḩ':'h',
'ḩ':'h',
'Ḥ':'h',
'ḥ':'h',
'Ḫ':'h',
'ḫ':'h',
'H':'h',
'̱':'h',
'ẖ':'h',
'Ħ':'h',
'ħ':'h',
'Ⱨ':'h',
'ⱨ':'h',
'Í':'i',
'í':'i',
'Ì':'i',
'ì':'i',
'Ĭ':'i',
'ĭ':'i',
'Î':'i',
'î':'i',
'Ǐ':'i',
'ǐ':'i',
'Ï':'i',
'ï':'i',
'Ḯ':'i',
'ḯ':'i',
'Ĩ':'i',
'ĩ':'i',
'İ':'i',
'i':'i',
'Į':'i',
'į':'i',
'Ī':'i',
'ī':'i',
'Ỉ':'i',
'ỉ':'i',
'Ȉ':'i',
'ȉ':'i',
'Ȋ':'i',
'ȋ':'i',
'Ị':'i',
'ị':'i',
'Ḭ':'i',
'ḭ':'i',
'I':'i',
'ı':'i',
'Ɨ':'i',
'ɨ':'i',
'Ĵ':'j',
'ĵ':'j',
'J':'j',
'̌':'j',
'ǰ':'j',
'ȷ':'j',
'Ɉ':'j',
'ɉ':'j',
'ʝ':'j',
'ɟ':'j',
'ʄ':'j',
'Ḱ':'k',
'ḱ':'k',
'Ǩ':'k',
'ǩ':'k',
'Ķ':'k',
'ķ':'k',
'Ḳ':'k',
'ḳ':'k',
'Ḵ':'k',
'ḵ':'k',
'Ƙ':'k',
'ƙ':'k',
'Ⱪ':'k',
'ⱪ':'k',
'Ĺ':'a',
'ĺ':'l',
'Ľ':'l',
'ľ':'l',
'Ļ':'l',
'ļ':'l',
'Ḷ':'l',
'ḷ':'l',
'Ḹ':'l',
'ḹ':'l',
'Ḽ':'l',
'ḽ':'l',
'Ḻ':'l',
'ḻ':'l',
'Ł':'l',
'ł':'l',
'Ł':'l',
'̣':'l',
'ł':'l',
'̣':'l',
'Ŀ':'l',
'ŀ':'l',
'Ƚ':'l',
'ƚ':'l',
'Ⱡ':'l',
'ⱡ':'l',
'Ɫ':'l',
'ɫ':'l',
'ɬ':'l',
'ɭ':'l',
'ȴ':'l',
'Ḿ':'m',
'ḿ':'m',
'Ṁ':'m',
'ṁ':'m',
'Ṃ':'m',
'ṃ':'m',
'ɱ':'m',
'Ń':'n',
'ń':'n',
'Ǹ':'n',
'ǹ':'n',
'Ň':'n',
'ň':'n',
'Ñ':'n',
'ñ':'n',
'Ṅ':'n',
'ṅ':'n',
'Ņ':'n',
'ņ':'n',
'Ṇ':'n',
'ṇ':'n',
'Ṋ':'n',
'ṋ':'n',
'Ṉ':'n',
'ṉ':'n',
'Ɲ':'n',
'ɲ':'n',
'Ƞ':'n',
'ƞ':'n',
'ɳ':'n',
'ȵ':'n',
'N':'n',
'̈':'n',
'n':'n',
'̈':'n',
'Ó':'o',
'ó':'o',
'Ò':'o',
'ò':'o',
'Ŏ':'o',
'ŏ':'o',
'Ô':'o',
'ô':'o',
'Ố':'o',
'ố':'o',
'Ồ':'o',
'ồ':'o',
'Ỗ':'o',
'ỗ':'o',
'Ổ':'o',
'ổ':'o',
'Ǒ':'o',
'ǒ':'o',
'Ö':'o',
'ö':'o',
'Ȫ':'o',
'ȫ':'o',
'Ő':'o',
'ő':'o',
'Õ':'o',
'õ':'o',
'Ṍ':'o',
'ṍ':'o',
'Ṏ':'o',
'ṏ':'o',
'Ȭ':'o',
'ȭ':'o',
'Ȯ':'o',
'ȯ':'o',
'Ȱ':'o',
'ȱ':'o',
'Ø':'o',
'ø':'o',
'Ǿ':'o',
'ǿ':'o',
'Ǫ':'o',
'ǫ':'o',
'Ǭ':'o',
'ǭ':'o',
'Ō':'o',
'ō':'o',
'Ṓ':'o',
'ṓ':'o',
'Ṑ':'o',
'ṑ':'o',
'Ỏ':'o',
'ỏ':'o',
'Ȍ':'o',
'ȍ':'o',
'Ȏ':'o',
'ȏ':'o',
'Ơ':'o',
'ơ':'o',
'Ớ':'o',
'ớ':'o',
'Ờ':'o',
'ờ':'o',
'Ỡ':'o',
'ỡ':'o',
'Ở':'o',
'ở':'o',
'Ợ':'o',
'ợ':'o',
'Ọ':'o',
'ọ':'o',
'Ộ':'o',
'ộ':'o',
'Ɵ':'o',
'ɵ':'o',
'Ṕ':'p',
'ṕ':'p',
'Ṗ':'p',
'ṗ':'p',
'Ᵽ':'p',
'Ƥ':'p',
'ƥ':'p',
'P':'p',
'̃':'p',
'p':'p',
'̃':'p',
'ʠ':'q',
'Ɋ':'q',
'ɋ':'q',
'Ŕ':'r',
'ŕ':'r',
'Ř':'r',
'ř':'r',
'Ṙ':'r',
'ṙ':'r',
'Ŗ':'r',
'ŗ':'r',
'Ȑ':'r',
'ȑ':'r',
'Ȓ':'r',
'ȓ':'r',
'Ṛ':'r',
'ṛ':'r',
'Ṝ':'r',
'ṝ':'r',
'Ṟ':'r',
'ṟ':'r',
'Ɍ':'r',
'ɍ':'r',
'ᵲ':'r',
'ɼ':'r',
'Ɽ':'r',
'ɽ':'r',
'ɾ':'r',
'ᵳ':'r',
'ß':'s',
'Ś':'s',
'ś':'s',
'Ṥ':'s',
'ṥ':'s',
'Ŝ':'s',
'ŝ':'s',
'Š':'s',
'š':'s',
'Ṧ':'s',
'ṧ':'s',
'Ṡ':'s',
'ṡ':'s',
'ẛ':'s',
'Ş':'s',
'ş':'s',
'Ṣ':'s',
'ṣ':'s',
'Ṩ':'s',
'ṩ':'s',
'Ș':'s',
'ș':'s',
'ʂ':'s',
'S':'s',
'̩':'s',
's':'s',
'̩':'s',
'Þ':'t',
'þ':'t',
'Ť':'t',
'ť':'t',
'T':'t',
'̈':'t',
'ẗ':'t',
'Ṫ':'t',
'ṫ':'t',
'Ţ':'t',
'ţ':'t',
'Ṭ':'t',
'ṭ':'t',
'Ț':'t',
'ț':'t',
'Ṱ':'t',
'ṱ':'t',
'Ṯ':'t',
'ṯ':'t',
'Ŧ':'t',
'ŧ':'t',
'Ⱦ':'t',
'ⱦ':'t',
'ᵵ':'t',
'ƫ':'t',
'Ƭ':'t',
'ƭ':'t',
'Ʈ':'t',
'ʈ':'t',
'ȶ':'t',
'Ú':'u',
'ú':'u',
'Ù':'u',
'ù':'u',
'Ŭ':'u',
'ŭ':'u',
'Û':'u',
'û':'u',
'Ǔ':'u',
'ǔ':'u',
'Ů':'u',
'ů':'u',
'Ü':'u',
'ü':'u',
'Ǘ':'u',
'ǘ':'u',
'Ǜ':'u',
'ǜ':'u',
'Ǚ':'u',
'ǚ':'u',
'Ǖ':'u',
'ǖ':'u',
'Ű':'u',
'ű':'u',
'Ũ':'u',
'ũ':'u',
'Ṹ':'u',
'ṹ':'u',
'Ų':'u',
'ų':'u',
'Ū':'u',
'ū':'u',
'Ṻ':'u',
'ṻ':'u',
'Ủ':'u',
'ủ':'u',
'Ȕ':'u',
'ȕ':'u',
'Ȗ':'u',
'ȗ':'u',
'Ư':'u',
'ư':'u',
'Ứ':'u',
'ứ':'u',
'Ừ':'u',
'ừ':'u',
'Ữ':'u',
'ữ':'u',
'Ử':'u',
'ử':'u',
'Ự':'u',
'ự':'u',
'Ụ':'u',
'ụ':'u',
'Ṳ':'u',
'ṳ':'u',
'Ṷ':'u',
'ṷ':'u',
'Ṵ':'u',
'ṵ':'u',
'Ʉ':'u',
'ʉ':'u',
'Ṽ':'v',
'ṽ':'v',
'Ṿ':'v',
'ṿ':'v',
'Ʋ':'v',
'ʋ':'v',
'Ẃ':'w',
'ẃ':'w',
'Ẁ':'w',
'ẁ':'w',
'Ŵ':'w',
'ŵ':'w',
'W':'w',
'̊':'w',
'ẘ':'w',
'Ẅ':'w',
'ẅ':'w',
'Ẇ':'w',
'ẇ':'w',
'Ẉ':'w',
'ẉ':'w',
'Ẍ':'x',
'ẍ':'x',
'Ẋ':'x',
'ẋ':'x',
'Ý':'y',
'ý':'y',
'Ỳ':'y',
'ỳ':'y',
'Ŷ':'y',
'ŷ':'y',
'Y':'y',
'̊':'y',
'ẙ':'y',
'Ÿ':'y',
'ÿ':'y',
'Ỹ':'y',
'ỹ':'y',
'Ẏ':'y',
'ẏ':'y',
'Ȳ':'y',
'ȳ':'y',
'Ỷ':'y',
'ỷ':'y',
'Ỵ':'y',
'ỵ':'y',
'ʏ':'y',
'Ɏ':'y',
'ɏ':'y',
'Ƴ':'y',
'ƴ':'y',
'Ź':'z',
'ź':'z',
'Ẑ':'z',
'ẑ':'z',
'Ž':'z',
'ž':'z',
'Ż':'z',
'ż':'z',
'Ẓ':'z',
'ẓ':'z',
'Ẕ':'z',
'ẕ':'z',
'Ƶ':'z',
'ƶ':'z',
'Ȥ':'z',
'ȥ':'z',
'ʐ':'z',
'ʑ':'z',
'Ⱬ':'z',
'ⱬ':'z',
'Ǯ':'z',
'ǯ':'z',
'ƺ':'z',

// Roman fullwidth ascii equivalents: 0xff00 to 0xff5e
'２':'2',
'６':'6',
'Ｂ':'B',
'Ｆ':'F',
'Ｊ':'J',
'Ｎ':'N',
'Ｒ':'R',
'Ｖ':'V',
'Ｚ':'Z',
'ｂ':'b',
'ｆ':'f',
'ｊ':'j',
'ｎ':'n',
'ｒ':'r',
'ｖ':'v',
'ｚ':'z',
'１':'1',
'５':'5',
'９':'9',
'Ａ':'A',
'Ｅ':'E',
'Ｉ':'I',
'Ｍ':'M',
'Ｑ':'Q',
'Ｕ':'U',
'Ｙ':'Y',
'ａ':'a',
'ｅ':'e',
'ｉ':'i',
'ｍ':'m',
'ｑ':'q',
'ｕ':'u',
'ｙ':'y',
'０':'0',
'４':'4',
'８':'8',
'Ｄ':'D',
'Ｈ':'H',
'Ｌ':'L',
'Ｐ':'P',
'Ｔ':'T',
'Ｘ':'X',
'ｄ':'d',
'ｈ':'h',
'ｌ':'l',
'ｐ':'p',
'ｔ':'t',
'ｘ':'x',
'３':'3',
'７':'7',
'Ｃ':'C',
'Ｇ':'G',
'Ｋ':'K',
'Ｏ':'O',
'Ｓ':'S',
'Ｗ':'W',
'ｃ':'c',
'ｇ':'g',
'ｋ':'k',
'ｏ':'o',
'ｓ':'s',
'ｗ':'w'};
