/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class NumericConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (!Number.class.isAssignableFrom(source) && !String.class.isAssignableFrom(source)) {
            return null;
        }
        if (Long.class.equals((Object)target) || Integer.class.equals((Object)target) || Short.class.equals((Object)target) || Byte.class.equals((Object)target) || BigInteger.class.equals((Object)target) || BigDecimal.class.equals((Object)target) || Double.class.equals((Object)target) || Float.class.equals((Object)target) || Number.class.equals((Object)target)) {
            return new NumericConverter();
        }
        return null;
    }

    class NumericConverter
    implements Converter {
        NumericConverter() {
        }

        public Object convert(Object source, Class target) throws Exception {
            if (source instanceof Number) {
                Number s = (Number)source;
                if (Long.class.equals((Object)target)) {
                    return new Long(s.longValue());
                }
                if (Integer.class.equals((Object)target)) {
                    return new Integer(s.intValue());
                }
                if (Short.class.equals((Object)target)) {
                    return new Short(s.shortValue());
                }
                if (Byte.class.equals((Object)target)) {
                    return new Byte(s.byteValue());
                }
                if (BigInteger.class.equals((Object)target)) {
                    return BigInteger.valueOf(s.longValue());
                }
                if (Double.class.equals((Object)target)) {
                    return new Double(s.doubleValue());
                }
                if (Float.class.equals((Object)target)) {
                    return new Float(s.floatValue());
                }
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(s.doubleValue());
                }
                if (Number.class.equals((Object)target)) {
                    try {
                        return new Integer(s.toString());
                    }
                    catch (Exception e) {
                        try {
                            return new BigInteger(s.toString());
                        }
                        catch (Exception e2) {
                            try {
                                return new Double(s.toString());
                            }
                            catch (Exception e3) {
                                try {
                                    return new BigDecimal(s.toString());
                                }
                                catch (Exception e4) {}
                            }
                        }
                    }
                }
            } else if (source instanceof String) {
                String s = (String)source;
                if (Long.class.equals((Object)target)) {
                    return new Long(s);
                }
                if (Integer.class.equals((Object)target)) {
                    return new Integer(s);
                }
                if (Short.class.equals((Object)target)) {
                    return new Short(s);
                }
                if (Byte.class.equals((Object)target)) {
                    return new Byte(s);
                }
                if (BigInteger.class.equals((Object)target)) {
                    return new BigInteger(s);
                }
                if (Double.class.equals((Object)target)) {
                    return new Double(s);
                }
                if (Float.class.equals((Object)target)) {
                    return new Float(s);
                }
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(s);
                }
                if (Number.class.equals((Object)target)) {
                    try {
                        return new Integer(s);
                    }
                    catch (Exception e) {
                        try {
                            return new BigInteger(s);
                        }
                        catch (Exception e5) {
                            try {
                                return new Double(s);
                            }
                            catch (Exception e6) {
                                try {
                                    return new BigDecimal(s);
                                }
                                catch (Exception e7) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }
    }
}

