/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Stack;
import org.geotools.event.GTCloneUtil;
import org.geotools.event.GTComponent;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class DuplicatingStyleVisitor
extends DuplicatingFilterVisitor
implements StyleVisitor {
    private final StyleFactory sf;
    private Stack pages = new Stack();

    public DuplicatingStyleVisitor() {
        this(CommonFactoryFinder.getStyleFactory(GeoTools.getDefaultHints()));
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory) {
        this.sf = styleFactory;
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory, FilterFactory2 factory) {
        super(factory);
        this.sf = styleFactory;
    }

    public Object getCopy() {
        return this.pages.peek();
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayerDescriptor copy = null;
        StyledLayer[] layers = sld.getStyledLayers();
        StyledLayer[] layersCopy = new StyledLayer[layers.length];
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            if (layers[i] instanceof UserLayer) {
                ((UserLayer)layers[i]).accept((StyleVisitor)this);
                layersCopy[i] = (UserLayer)this.pages.pop();
                continue;
            }
            if (!(layers[i] instanceof NamedLayer)) continue;
            ((NamedLayer)layers[i]).accept((StyleVisitor)this);
            layersCopy[i] = (NamedLayer)this.pages.pop();
        }
        copy = this.sf.createStyledLayerDescriptor();
        copy.setAbstract(sld.getAbstract());
        copy.setName(sld.getName());
        copy.setTitle(sld.getTitle());
        copy.setStyledLayers(layersCopy);
        this.pages.push(copy);
    }

    public void visit(NamedLayer layer) {
        int i;
        NamedLayer copy = null;
        Style[] style = layer.getStyles();
        Style[] styleCopy = new Style[style.length];
        int length = style.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (style[i2] == null) continue;
            style[i2].accept((StyleVisitor)this);
            styleCopy[i2] = (Style)this.pages.pop();
        }
        FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
        FeatureTypeConstraint[] lfcCopy = new FeatureTypeConstraint[lfc.length];
        length = lfc.length;
        for (i = 0; i < length; ++i) {
            if (lfc[i] == null) continue;
            lfc[i].accept((StyleVisitor)this);
            lfcCopy[i] = (FeatureTypeConstraint)this.pages.pop();
        }
        copy = this.sf.createNamedLayer();
        copy.setName(layer.getName());
        length = styleCopy.length;
        for (i = 0; i < length; ++i) {
            copy.addStyle(styleCopy[i]);
        }
        copy.setLayerFeatureConstraints(lfcCopy);
        this.pages.push(copy);
    }

    public void visit(UserLayer layer) {
        UserLayer copy = null;
        Style[] style = layer.getUserStyles();
        int length = style.length;
        Style[] styleCopy = new Style[length];
        for (int i = 0; i < length; ++i) {
            if (style[i] == null) continue;
            style[i].accept((StyleVisitor)this);
            styleCopy[i] = (Style)this.pages.pop();
        }
        FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
        FeatureTypeConstraint[] lfcCopy = new FeatureTypeConstraint[lfc.length];
        length = lfc.length;
        for (int i = 0; i < length; ++i) {
            if (lfc[i] == null) continue;
            lfc[i].accept((StyleVisitor)this);
            lfcCopy[i] = (FeatureTypeConstraint)this.pages.pop();
        }
        copy = this.sf.createUserLayer();
        copy.setName(layer.getName());
        copy.setUserStyles(styleCopy);
        copy.setLayerFeatureConstraints(lfcCopy);
        this.pages.push(copy);
    }

    public void visit(Style style) {
        Style copy = null;
        FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
        int length = fts.length;
        FeatureTypeStyle[] ftsCopy = new FeatureTypeStyle[length];
        for (int i = 0; i < length; ++i) {
            if (fts[i] == null) continue;
            fts[i].accept((StyleVisitor)this);
            ftsCopy[i] = (FeatureTypeStyle)this.pages.pop();
        }
        copy = this.sf.createStyle();
        copy.setAbstract(style.getAbstract());
        copy.setName(style.getName());
        copy.setTitle(style.getTitle());
        copy.setFeatureTypeStyles(ftsCopy);
        this.pages.push(copy);
    }

    public void visit(Rule rule) {
        Rule copy = null;
        Filter filterCopy = null;
        if (rule.getFilter() != null) {
            Filter filter = rule.getFilter();
            filterCopy = (Filter)filter.accept((FilterVisitor)this, null);
        }
        Graphic[] legendGraphic = rule.getLegendGraphic();
        Graphic[] legendGraphicCopy = new Graphic[legendGraphic.length];
        int length = legendGraphic.length;
        for (int i = 0; i < length; ++i) {
            if (legendGraphic[i] == null) continue;
            legendGraphic[i].accept((StyleVisitor)this);
            legendGraphicCopy[i] = (Graphic)this.pages.pop();
        }
        Symbolizer[] symbolizer = rule.getSymbolizers();
        Symbolizer[] symbolizerCopy = new Symbolizer[symbolizer.length];
        length = symbolizer.length;
        for (int i = 0; i < length; ++i) {
            if (symbolizer[i] == null) continue;
            symbolizer[i].accept((StyleVisitor)this);
            symbolizerCopy[i] = (Symbolizer)this.pages.pop();
        }
        copy = this.sf.createRule();
        copy.setAbstract(rule.getAbstract());
        copy.setFilter(filterCopy);
        copy.setIsElseFilter(rule.hasElseFilter());
        copy.setLegendGraphic(legendGraphicCopy);
        copy.setMinScaleDenominator(rule.getMinScaleDenominator());
        copy.setMaxScaleDenominator(rule.getMaxScaleDenominator());
        copy.setName(rule.getName());
        copy.setTitle(rule.getTitle());
        copy.setSymbolizers(symbolizerCopy);
        this.pages.push(copy);
    }

    public void visit(FeatureTypeStyle fts) {
        FeatureTypeStyle copy = null;
        Rule[] rules = fts.getRules();
        int length = rules.length;
        Rule[] rulesCopy = new Rule[length];
        for (int i = 0; i < length; ++i) {
            if (rules[i] == null) continue;
            rules[i].accept((StyleVisitor)this);
            rulesCopy[i] = (Rule)this.pages.pop();
        }
        copy = this.sf.createFeatureTypeStyle();
        copy.setName(fts.getName());
        copy.setTitle(fts.getTitle());
        copy.setAbstract(fts.getAbstract());
        copy.setFeatureTypeName(fts.getFeatureTypeName());
        copy.setRules(rulesCopy);
        copy.setSemanticTypeIdentifiers((String[])fts.getSemanticTypeIdentifiers().clone());
        this.pages.push(copy);
    }

    public void visit(Fill fill) {
        Fill copy = null;
        try {
            copy = (Fill)GTCloneUtil.clone((GTComponent)fill);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(Stroke stroke) {
        Stroke copy = null;
        try {
            copy = (Stroke)GTCloneUtil.clone((GTComponent)stroke);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(Symbolizer sym) {
        throw new RuntimeException("visit(Symbolizer) unsupported");
    }

    public void visit(PointSymbolizer ps) {
        PointSymbolizer copy = null;
        try {
            copy = (PointSymbolizer)GTCloneUtil.clone((GTComponent)ps);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(LineSymbolizer line) {
        LineSymbolizer copy = null;
        try {
            copy = (LineSymbolizer)GTCloneUtil.clone((GTComponent)line);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(PolygonSymbolizer poly) {
        PolygonSymbolizer copy = null;
        try {
            copy = (PolygonSymbolizer)GTCloneUtil.clone((GTComponent)poly);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(TextSymbolizer text) {
        TextSymbolizer copy = null;
        try {
            copy = (TextSymbolizer)GTCloneUtil.clone((GTComponent)text);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(RasterSymbolizer raster) {
        RasterSymbolizer copy = null;
        try {
            copy = (RasterSymbolizer)GTCloneUtil.clone((GTComponent)raster);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(Graphic gr) {
        Graphic copy = null;
        Displacement displacementCopy = null;
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept((StyleVisitor)this);
            displacementCopy = (Displacement)this.pages.pop();
        }
        ExternalGraphic[] externalGraphics = gr.getExternalGraphics();
        ExternalGraphic[] externalGraphicsCopy = new ExternalGraphic[externalGraphics.length];
        int length = externalGraphics.length;
        for (int i = 0; i < length; ++i) {
            if (externalGraphics[i] == null) continue;
            externalGraphics[i].accept((StyleVisitor)this);
            externalGraphicsCopy[i] = (ExternalGraphic)this.pages.pop();
        }
        Mark[] marks = gr.getMarks();
        Mark[] marksCopy = new Mark[marks.length];
        length = marks.length;
        for (int i = 0; i < length; ++i) {
            if (marks[i] == null) continue;
            marks[i].accept((StyleVisitor)this);
            marksCopy[i] = (Mark)this.pages.pop();
        }
        Expression opacityCopy = null;
        if (gr.getOpacity() != null) {
            opacityCopy = (Expression)gr.getOpacity().accept((ExpressionVisitor)this, null);
        }
        Expression rotationCopy = null;
        if (gr.getRotation() != null) {
            rotationCopy = (Expression)gr.getRotation().accept((ExpressionVisitor)this, null);
        }
        Expression sizeCopy = null;
        if (gr.getSize() != null) {
            sizeCopy = (Expression)gr.getSize().accept((ExpressionVisitor)this, null);
        }
        Symbol[] symbols = gr.getSymbols();
        length = symbols.length;
        Symbol[] symbolCopys = new Symbol[length];
        for (int i = 0; i < length; ++i) {
            if (symbols[i] == null) continue;
            symbols[i].accept((StyleVisitor)this);
            symbolCopys[i] = (Symbol)this.pages.pop();
        }
        copy = this.sf.createDefaultGraphic();
        copy.setGeometryPropertyName(gr.getGeometryPropertyName());
        copy.setDisplacement(displacementCopy);
        copy.setExternalGraphics(externalGraphicsCopy);
        copy.setMarks(marksCopy);
        copy.setOpacity(opacityCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.setSymbols(symbolCopys);
        this.pages.push(copy);
    }

    public void visit(Mark mark) {
        Mark copy = null;
        Fill fillCopy = null;
        if (mark.getFill() != null) {
            mark.accept((StyleVisitor)this);
            fillCopy = (Fill)this.pages.pop();
        }
        Expression rotationCopy = null;
        if (mark.getRotation() != null) {
            rotationCopy = (Expression)mark.getRotation().accept((ExpressionVisitor)this, null);
        }
        Expression sizeCopy = null;
        if (mark.getSize() != null) {
            sizeCopy = (Expression)mark.getSize().accept((ExpressionVisitor)this, null);
        }
        Stroke strokeCopy = null;
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
            strokeCopy = (Stroke)this.pages.pop();
        }
        Expression wellKnownNameCopy = null;
        if (mark.getWellKnownName() != null) {
            wellKnownNameCopy = (Expression)mark.getWellKnownName().accept((ExpressionVisitor)this, null);
        }
        copy = this.sf.createMark();
        copy.setFill(fillCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.setStroke(strokeCopy);
        copy.setWellKnownName(wellKnownNameCopy);
        this.pages.push(copy);
    }

    public void visit(ExternalGraphic exgr) {
        ExternalGraphic copy = null;
        try {
            copy = (ExternalGraphic)GTCloneUtil.clone((GTComponent)exgr);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(PointPlacement pp) {
        PointPlacement copy = null;
        try {
            copy = (PointPlacement)GTCloneUtil.clone((GTComponent)pp);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(AnchorPoint ap) {
        AnchorPoint copy = null;
        try {
            copy = (AnchorPoint)GTCloneUtil.clone((GTComponent)ap);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(Displacement dis) {
        Displacement copy = null;
        try {
            copy = (Displacement)GTCloneUtil.clone((GTComponent)dis);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(LinePlacement lp) {
        LinePlacement copy = null;
        try {
            copy = (LinePlacement)GTCloneUtil.clone((GTComponent)lp);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(Halo halo) {
        Halo copy = null;
        try {
            copy = (Halo)GTCloneUtil.clone((GTComponent)halo);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(FeatureTypeConstraint ftc) {
        FeatureTypeConstraint copy = null;
        try {
            copy = (FeatureTypeConstraint)GTCloneUtil.clone((GTComponent)ftc);
        }
        catch (CloneNotSupportedException erp) {
            throw new RuntimeException(erp);
        }
        this.pages.push(copy);
    }

    public void visit(ColorMap arg0) {
    }

    public void visit(ColorMapEntry arg0) {
    }
}

