/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.Font;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextMark;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class TextMarkImpl
extends MarkImpl
implements TextMark {
    private FilterFactory filterFactory;
    private Expression wellKnownName = null;
    private List fonts = new ArrayList();
    private Expression symbol;

    public TextMarkImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public TextMarkImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public TextMarkImpl(Font font, String symbol) {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
        this.addFont(font);
        this.setSymbol(symbol);
        this.wellKnownName = this.filterFactory.literal((Object)"Symbol");
    }

    public TextMarkImpl(Font font, Expression symbol) {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
        this.addFont(font);
        this.setSymbol(symbol);
        this.wellKnownName = this.filterFactory.literal((Object)"Symbol");
    }

    public Expression getWellKnownName() {
        return this.wellKnownName;
    }

    public Font[] getFonts() {
        return this.fonts.toArray(new Font[0]);
    }

    public void addFont(Font font) {
        this.fonts.add(font);
    }

    public Expression getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.setSymbol((Expression)this.filterFactory.literal((Object)symbol));
    }

    public void setSymbol(Expression symbol) {
        Expression old = this.symbol;
        this.symbol = symbol;
        this.fireChildChanged("symbol", symbol, old);
    }

    public void setWellKnownName(Expression wellKnownName) {
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Mark)this);
    }
}

