/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;

public abstract class GeometryFilterImpl
extends BinaryComparisonAbstract
implements GeometryFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");

    protected GeometryFilterImpl(FilterFactory factory) {
        super((org.opengis.filter.FilterFactory)factory);
    }

    protected GeometryFilterImpl(FilterFactory factory, org.opengis.filter.expression.Expression e1, org.opengis.filter.expression.Expression e2) {
        super((org.opengis.filter.FilterFactory)factory, e1, e2);
    }

    protected GeometryFilterImpl(short filterType) throws IllegalFilterException {
        super((org.opengis.filter.FilterFactory)FilterFactoryFinder.createFilterFactory());
        if (!GeometryFilterImpl.isGeometryFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create geometry filter with non-geometry type.");
        }
        this.filterType = filterType;
    }

    public final void addLeftGeometry(Expression leftGeometry) throws IllegalFilterException {
        this.setExpression1((org.opengis.filter.expression.Expression)leftGeometry);
    }

    public void setExpression1(org.opengis.filter.expression.Expression expression) {
        Expression leftGeometry = (Expression)expression;
        if (!DefaultExpression.isGeometryExpression(leftGeometry.getType()) && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add (left) non-geometry expression to geometry filter.");
        }
        super.setExpression1((org.opengis.filter.expression.Expression)leftGeometry);
    }

    public final void addRightGeometry(Expression rightGeometry) throws IllegalFilterException {
        this.setExpression2((org.opengis.filter.expression.Expression)rightGeometry);
    }

    public void setExpression2(org.opengis.filter.expression.Expression expression) {
        Expression rightGeometry = (Expression)expression;
        if (!DefaultExpression.isGeometryExpression(rightGeometry.getType()) && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add (right) non-geometryexpression to geometry filter.");
        }
        super.setExpression2((org.opengis.filter.expression.Expression)rightGeometry);
    }

    public final Expression getLeftGeometry() {
        return (Expression)this.getExpression1();
    }

    public final Expression getRightGeometry() {
        return (Expression)this.getExpression2();
    }

    protected Geometry getLeftGeometry(Object feature) {
        org.opengis.filter.expression.Expression leftGeometry = this.getExpression1();
        if (leftGeometry != null) {
            Object obj = leftGeometry.evaluate(feature, Geometry.class);
            return (Geometry)obj;
        }
        if (feature instanceof Feature) {
            return ((Feature)feature).getPrimaryGeometry();
        }
        return null;
    }

    protected Geometry getRightGeometry(Object feature) {
        org.opengis.filter.expression.Expression rightGeometry = this.getExpression2();
        if (rightGeometry != null) {
            return (Geometry)rightGeometry.evaluate(feature, Geometry.class);
        }
        if (feature instanceof Feature) {
            return ((Feature)feature).getPrimaryGeometry();
        }
        return null;
    }

    protected boolean validate(Feature feature) {
        Geometry right = this.getRightGeometry(feature);
        Geometry left = this.getLeftGeometry(feature);
        return left != null;
    }

    public boolean evaluate(Feature feature) {
        return this.evaluate(feature);
    }

    public String toString() {
        String operator = null;
        if (this.filterType == 5) {
            operator = " equals ";
        } else if (this.filterType == 6) {
            operator = " disjoint ";
        } else if (this.filterType == 7) {
            operator = " intersects ";
        } else if (this.filterType == 9) {
            operator = " crosses ";
        } else if (this.filterType == 10) {
            operator = " within ";
        } else if (this.filterType == 11) {
            operator = " contains ";
        } else if (this.filterType == 12) {
            operator = " overlaps ";
        } else if (this.filterType == 13) {
            operator = " beyond ";
        } else if (this.filterType == 4) {
            operator = " bbox ";
        }
        org.opengis.filter.expression.Expression leftGeometry = this.getExpression1();
        org.opengis.filter.expression.Expression rightGeometry = this.getExpression2();
        if (this.expression1 == null && rightGeometry == null) {
            return "[ null" + operator + "null" + " ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator + rightGeometry.toString() + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator + "null" + " ]";
        }
        return "[ " + leftGeometry.toString() + operator + rightGeometry.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryFilterImpl) {
            GeometryFilterImpl geomFilter = (GeometryFilterImpl)obj;
            boolean isEqual = true;
            isEqual = geomFilter.getFilterType() == this.filterType;
            LOGGER.finest("filter type match:" + isEqual + "; in:" + geomFilter.getFilterType() + "; out:" + this.filterType);
            isEqual = geomFilter.expression1 != null ? isEqual && geomFilter.expression1.equals(this.expression1) : isEqual && this.expression1 == null;
            LOGGER.finest("left geom match:" + isEqual + "; in:" + geomFilter.expression1 + "; out:" + this.expression1);
            isEqual = geomFilter.expression2 != null ? isEqual && geomFilter.expression2.equals(this.expression2) : isEqual && this.expression2 == null;
            LOGGER.finest("right geom match:" + isEqual + "; in:" + geomFilter.expression2 + "; out:" + this.expression2);
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        org.opengis.filter.expression.Expression leftGeometry = this.getExpression1();
        org.opengis.filter.expression.Expression rightGeometry = this.getExpression2();
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + (leftGeometry == null ? 0 : leftGeometry.hashCode());
        result = 37 * result + (rightGeometry == null ? 0 : rightGeometry.hashCode());
        return result;
    }
}

