/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.resources.Utilities;
import org.opengis.feature.type.AssociationDescriptor;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.StructuralDescriptor;
import org.opengis.util.InternationalString;

public class ComplexTypeImpl
extends AttributeTypeImpl
implements ComplexType {
    protected Collection PROPERTIES = null;
    protected Collection ATTRIBUTES = null;
    protected Collection ASSOCIATIONS = null;

    public ComplexTypeImpl(Name name, Collection properties, boolean identified, boolean isAbstract, Set restrictions, AttributeType superType, InternationalString description) {
        super(name, Collection.class, identified, isAbstract, restrictions, superType, description);
        this.PROPERTIES = properties;
        this.ATTRIBUTES = null;
        this.ASSOCIATIONS = null;
        if (properties != null) {
            try {
                this.ATTRIBUTES = (Collection)this.PROPERTIES.getClass().newInstance();
                this.ASSOCIATIONS = (Collection)this.PROPERTIES.getClass().newInstance();
            }
            catch (Exception e) {
                this.ATTRIBUTES = new ArrayList();
                this.ASSOCIATIONS = new ArrayList();
            }
            for (StructuralDescriptor sd : this.PROPERTIES) {
                if (sd instanceof AttributeDescriptor) {
                    this.ATTRIBUTES.add(sd);
                    continue;
                }
                if (!(sd instanceof AssociationDescriptor)) continue;
                this.ASSOCIATIONS.add(sd);
            }
        } else {
            this.PROPERTIES = Collections.EMPTY_LIST;
            this.ATTRIBUTES = Collections.EMPTY_LIST;
            this.ASSOCIATIONS = Collections.EMPTY_LIST;
        }
    }

    public AttributeType getSuper() {
        return this.SUPER;
    }

    public Collection getProperties() {
        return this.PROPERTIES;
    }

    public Collection attributes() {
        return this.ATTRIBUTES;
    }

    public Collection associations() {
        return this.ASSOCIATIONS;
    }

    void setAttributes(Collection SCHEMA) {
        this.ATTRIBUTES = SCHEMA;
    }

    public boolean isInline() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComplexType other = (ComplexType)o;
        return Utilities.equals((Object)this.PROPERTIES, (Object)other.getProperties());
    }

    public int hashCode() {
        return super.hashCode() * ((Object)this.PROPERTIES).hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Utilities.getShortClassName((Object)this));
        sb.append("[name=").append(this.getName()).append(", binding=").append(this.BINDING).append(", abstrsct= ").append(this.isAbstract()).append(", identified=").append(this.IDENTIFIED).append(", restrictions=").append(this.getRestrictions()).append(", superType=").append(this.SUPER).append(", schema=").append(this.ATTRIBUTES).append("]");
        return sb.toString();
    }
}

