/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import org.geotools.feature.simple.SimpleFeatureFactoryImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureCollectionType;
import org.opengis.feature.simple.SimpleFeatureFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeatureBuilder {
    protected SimpleFeatureFactory factory;
    protected List attributes = new ArrayList();
    protected SimpleFeatureType featureType;
    protected GeometryAttribute defaultGeometry;
    protected CoordinateReferenceSystem crs;

    public SimpleFeatureBuilder() {
        this(new SimpleFeatureFactoryImpl());
    }

    public SimpleFeatureBuilder(SimpleFeatureFactory factory) {
        this.factory = factory;
    }

    public void setSimpleFeatureFactory(SimpleFeatureFactory factory) {
        this.factory = (SimpleFeatureFactoryImpl)factory;
    }

    public void setType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public void setType(SimpleFeatureCollectionType collectionType) {
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void init(SimpleFeature feature) {
        this.init();
        this.featureType = (SimpleFeatureType)feature.getType();
        for (int i = 0; i < feature.getNumberOfAttributes(); ++i) {
            this.add(feature.getValue(i));
        }
        this.defaultGeometry = feature.getDefaultGeometry();
        this.crs = feature.getCRS();
    }

    protected void init() {
        this.attributes = null;
    }

    public void add(Object value) {
        AttributeDescriptor descriptor = this.featureType.getAttribute(this.attributes().size());
        Attribute attribute = null;
        if (this.isGeometry(descriptor)) {
            attribute = this.factory.createGeometryAttribute(value, descriptor, null, this.featureType.getCRS());
            if (descriptor.equals(this.featureType.getDefaultGeometry())) {
                this.defaultGeometry = (GeometryAttribute)attribute;
            }
        } else {
            attribute = this.factory.createAttribute(value, descriptor, null);
        }
        this.attributes().add(this.attributes().size(), attribute);
    }

    public void add(Object[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
    }

    public void set(String name, Object value) {
        int index = this.featureType.indexOf(name);
        if (index < this.attributes().size()) {
            Attribute attribute = (Attribute)this.attributes().get(index);
            attribute.setValue(value);
        } else {
            while (this.attributes.size() < index) {
                this.add((Object)null);
            }
            this.add(value);
        }
    }

    public Object build(String id) {
        if (this.featureType != null) {
            if (id == null) {
                id = this.createDefaultFeatureId();
            }
            return this.feature(id);
        }
        return null;
    }

    protected boolean isGeometry(AttributeDescriptor value) {
        return value.getType() instanceof GeometryType;
    }

    protected String createDefaultFeatureId() {
        return "fid-" + new UID().toString().replace(':', '_');
    }

    public SimpleFeature feature(String id) {
        int n = this.featureType.getAttributeCount();
        while (this.attributes().size() < n) {
            this.add((Object)null);
        }
        SimpleFeature feature = this.factory.createSimpleFeature(this.attributes, this.featureType, id);
        feature.setDefaultGeometry(this.defaultGeometry);
        if (this.crs != null) {
            feature.setCRS(this.crs);
        } else if (this.defaultGeometry != null) {
            feature.setCRS(this.defaultGeometry.getCRS());
        }
        this.init();
        return feature;
    }

    protected List attributes() {
        if (this.attributes == null) {
            this.attributes = this.newList();
        }
        return this.attributes;
    }

    protected List newList() {
        return new ArrayList();
    }
}

