/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.Name;
import org.geotools.feature.type.AssociationDescriptorImpl;
import org.geotools.feature.type.AssociationTypeImpl;
import org.geotools.feature.type.TypeName;
import org.geotools.resources.Utilities;
import org.opengis.feature.simple.SimpleFeatureCollectionType;
import org.opengis.feature.simple.SimpleFeatureType;

public class BaseFeatureCollectionType
extends DefaultFeatureType
implements FeatureType,
SimpleFeatureCollectionType {
    final FeatureType memberType;

    public BaseFeatureCollectionType(FeatureType memberType) {
        super((org.opengis.feature.type.Name)new TypeName(FeatureTypes.DEFAULT_NAMESPACE.toString(), "AbstractFeatureColletionType"), null, null, null);
        this.memberType = memberType;
    }

    public SimpleFeatureType getMemberType() {
        return this.memberType;
    }

    public Set getMemberTypes() {
        return Collections.singleton(this.getMemberType());
    }

    public Set getMembers() {
        AssociationTypeImpl contains = new AssociationTypeImpl(new TypeName("contains"), (org.opengis.feature.type.AttributeType)this.memberType, false, false, Collections.EMPTY_SET, null, null);
        AssociationDescriptorImpl member = new AssociationDescriptorImpl(null, (org.opengis.feature.type.Name)new Name("member"), 0, Integer.MAX_VALUE);
        return Collections.singleton(member);
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        throw new UnsupportedOperationException("Types of feature collection do not support feature creation");
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        throw new UnsupportedOperationException("Types of feature collection do not support feature creation");
    }

    public Feature duplicate(Feature feature) throws IllegalAttributeException {
        throw new UnsupportedOperationException("Types of feature collection do not support feature creation");
    }

    public int find(AttributeType type) {
        return this.find(type.getLocalName());
    }

    public int find(String attName) {
        return this.indexOf(attName);
    }

    public FeatureType[] getAncestors() {
        return new FeatureType[0];
    }

    public AttributeType getAttributeType(String xPath) {
        return (AttributeType)this.getAttribute(this.name);
    }

    public AttributeType getAttributeType(int position) {
        return (AttributeType)this.getAttribute(position);
    }

    public AttributeType[] getAttributeTypes() {
        return new AttributeType[0];
    }

    public URI getNamespace() {
        try {
            return new URI(this.getName().getNamespaceURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public GeometryAttributeType getPrimaryGeometry() {
        return (GeometryAttributeType)this.getDefaultGeometry();
    }

    public String getTypeName() {
        return this.getName().getLocalPart();
    }

    public boolean hasAttributeType(String xPath) {
        return this.indexOf(xPath) != -1;
    }

    public boolean isDescendedFrom(URI nsURI, String typeName) {
        return false;
    }

    public boolean isDescendedFrom(FeatureType type) {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof BaseFeatureCollectionType && super.equals(other)) {
            return Utilities.equals((Object)this.memberType, (Object)((BaseFeatureCollectionType)other).memberType);
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.memberType != null) {
            hash ^= this.memberType.hashCode();
        }
        return hash;
    }
}

