/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.DefaultFeatureTypeBuilder;
import org.geotools.feature.type.TypeName;
import org.geotools.filter.LengthFunction;
import org.geotools.geometry.jts.JTS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Literal;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FeatureTypes {
    public static final URI DEFAULT_NAMESPACE;
    public static final FeatureType ABSTRACT_FEATURE_TYPE;
    public static final TypeName DEFAULT_TYPENAME;
    public static final int ANY_LENGTH = -1;

    public static int getFieldLength(AttributeType type) {
        Class colType = type.getBinding();
        String colName = type.getLocalName();
        int fieldLen = -1;
        Filter f = type.getRestriction();
        if (f != null && f != Filter.EXCLUDE && f != Filter.INCLUDE && (f instanceof PropertyIsLessThan || f instanceof PropertyIsLessThanOrEqualTo)) {
            try {
                BinaryComparisonOperator cf = (BinaryComparisonOperator)f;
                if (cf.getExpression1() instanceof LengthFunction) {
                    return Integer.parseInt(((Literal)cf.getExpression2()).getValue().toString());
                }
                if (cf.getExpression2() instanceof LengthFunction) {
                    return Integer.parseInt(((Literal)cf.getExpression1()).getValue().toString());
                }
                return -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static FeatureType transform(FeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        return FeatureTypes.transform(schema, crs, false);
    }

    public static FeatureType transform(FeatureType schema, CoordinateReferenceSystem crs, boolean forceOnlyMissing) throws SchemaException {
        DefaultFeatureTypeBuilder tb = new DefaultFeatureTypeBuilder();
        tb.setName(schema.getTypeName());
        tb.setNamespaceURI(schema.getNamespace());
        tb.setAbstract(schema.isAbstract());
        GeometryAttributeType defaultGeometryType = null;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeType attributeType = schema.getAttributeType(i);
            if (attributeType instanceof GeometryAttributeType) {
                GeometryAttributeType geometryType = (GeometryAttributeType)attributeType;
                GeometryAttributeType forced = forceOnlyMissing && geometryType.getCoordinateSystem() != null ? geometryType : (GeometryAttributeType)AttributeTypeFactory.newAttributeType(geometryType.getLocalName(), geometryType.getBinding(), geometryType.isNillable(), 0, geometryType.createDefaultValue(), (Object)crs);
                if (defaultGeometryType == null || geometryType == schema.getPrimaryGeometry()) {
                    defaultGeometryType = forced;
                }
                tb.add((AttributeType)forced);
                continue;
            }
            tb.add(attributeType);
        }
        if (schema.getPrimaryGeometry() != null) {
            tb.setDefaultGeometry(schema.getPrimaryGeometry().getLocalName());
        }
        tb.setSuperType((SimpleFeatureType)schema.getSuper());
        return tb.buildFeatureType();
    }

    public static Feature transform(Feature feature, FeatureType schema, MathTransform transform) throws MismatchedDimensionException, TransformException, IllegalAttributeException {
        feature = schema.create(feature.getAttributes(null), feature.getID());
        GeometryAttributeType geomType = schema.getPrimaryGeometry();
        Geometry geom = (Geometry)feature.getAttribute(geomType.getLocalName());
        geom = JTS.transform((Geometry)geom, (MathTransform)transform);
        try {
            feature.setAttribute(geomType.getLocalName(), (Object)geom);
        }
        catch (IllegalAttributeException shouldNotHappen) {
            // empty catch block
        }
        return feature;
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, AttributeType defaultGeometry) throws FactoryConfigurationError, SchemaException {
        DefaultFeatureTypeBuilder tb = new DefaultFeatureTypeBuilder();
        tb.setName(name);
        tb.setNamespaceURI(ns);
        tb.setAbstract(isAbstract);
        tb.add(types);
        if (defaultGeometry != null) {
            boolean add = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != defaultGeometry) continue;
                add = false;
                break;
            }
            if (add) {
                tb.add(defaultGeometry);
            }
            tb.setDefaultGeometry(defaultGeometry.getLocalName());
        }
        if (superTypes != null && superTypes.length > 0) {
            if (superTypes.length > 1) {
                throw new SchemaException("Can only specify a single super type");
            }
            tb.setSuperType((SimpleFeatureType)superTypes[0]);
        } else {
            tb.setSuperType((SimpleFeatureType)ABSTRACT_FEATURE_TYPE);
        }
        return tb.buildFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, GeometryAttributeType defaultGeometry) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, (AttributeType)defaultGeometry);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, false);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, DEFAULT_NAMESPACE, false);
    }

    public static boolean isDecendedFrom(FeatureType featureType, URI namespace, String typeName) {
        if (featureType == null) {
            return false;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null) {
            for (int i = 0; i < ancestors.length; ++i) {
                FeatureType ancestor = ancestors[i];
                if (namespace != null && !namespace.equals(ancestor.getNamespace()) || typeName != null && !namespace.equals(ancestor.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDecendedFrom(FeatureType featureType, FeatureType isParentType) {
        if (featureType == null || isParentType == null) {
            return false;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null) {
            for (int i = 0; i < ancestors.length; ++i) {
                FeatureType ancestor = ancestors[i];
                if (isParentType != ancestor) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(FeatureType typeA, FeatureType typeB) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        return FeatureTypes.equalsId(typeA, typeB) && FeatureTypes.equals(typeA.getAttributeTypes(), typeB.getAttributeTypes()) && FeatureTypes.equalsAncestors(typeA, typeB);
    }

    public static boolean equals(AttributeType[] attributesA, AttributeType[] attributesB) {
        if (attributesA.length != attributesB.length) {
            return false;
        }
        int length = attributesA.length;
        for (int i = 0; i < length; ++i) {
            if (FeatureTypes.equals(attributesA[i], attributesB[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAncestors(FeatureType typeA, FeatureType typeB) {
        return ((Object)FeatureTypes.ancestors(typeA)).equals(typeB);
    }

    public static Set ancestors(FeatureType featureType) {
        if (featureType == null || featureType.getAncestors() == null || featureType.getAncestors().length == 0) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<FeatureType>(Arrays.asList(featureType.getAncestors()));
    }

    public static boolean equals(AttributeType a, AttributeType b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equalsId(FeatureType typeA, FeatureType typeB) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        String typeNameA = typeA.getTypeName();
        String typeNameB = typeB.getTypeName();
        if (typeNameA == null && typeNameB != null) {
            return false;
        }
        if (!typeNameA.equals(typeNameB)) {
            return false;
        }
        URI namespaceA = typeA.getNamespace();
        URI namespaceB = typeB.getNamespace();
        if (namespaceA == null && namespaceB != null) {
            return false;
        }
        return namespaceA.equals(namespaceB);
    }

    static {
        URI uri;
        try {
            uri = new URI("http://www.opengis.net/gml");
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        DEFAULT_NAMESPACE = uri;
        FeatureType featureType = null;
        try {
            featureType = FeatureTypes.newFeatureType(null, "Feature", new URI("http://www.opengis.net/gml"), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABSTRACT_FEATURE_TYPE = featureType;
        DEFAULT_TYPENAME = new TypeName("AbstractFeatureCollectionType", DEFAULT_NAMESPACE.toString());
    }
}

