/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.event.GTComponent;
import org.geotools.event.GTDelta;
import org.geotools.event.GTDeltaImpl;
import org.geotools.event.GTNote;
import org.geotools.event.GTNoteImpl;
import org.geotools.event.GTRoot;

public class GTList
extends ArrayList
implements List {
    private static final long serialVersionUID = -4849245752797538846L;
    private GTComponent host;
    private String notificationName;

    GTList() {
        this((GTComponent)GTRoot.NO_PARENT, "");
    }

    public GTList(GTComponent host, String listName) {
        this.host = host;
        this.notificationName = listName;
    }

    private List deltaAdded(int fromIndex, int toIndex) {
        int position = fromIndex;
        List range = this.subList(fromIndex, toIndex);
        ArrayList<GTDelta> added = new ArrayList<GTDelta>(range.size());
        for (Object item : range) {
            added.add(this.deltaAdded(position, item));
            ++position;
        }
        return added;
    }

    private GTDelta deltaAdded(int position, Object item) {
        if (item instanceof GTComponent) {
            GTComponent myChild = (GTComponent)item;
            myChild.setNote(this.note(position));
        }
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, position), GTDelta.Kind.ADDED, item, null);
        return delta;
    }

    protected GTNote note(int position) {
        return new GTNoteImpl(this.host, this.notificationName, position);
    }

    private List deltaMove(int fromIndex, int toIndex) {
        int position = fromIndex;
        List rest = this.subList(fromIndex, toIndex);
        ArrayList<GTDelta> moved = new ArrayList<GTDelta>(rest.size());
        for (Object item : rest) {
            moved.add(this.deltaSync(position, item));
            ++position;
        }
        return moved;
    }

    private GTDelta deltaSync(int position, Object item) {
        if (item instanceof GTComponent) {
            GTComponent myChild = (GTComponent)item;
            myChild.setNote(GTNote.EMPTY);
            myChild.setNote(this.note(position));
        }
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, position), GTDelta.Kind.NO_CHANGE, item, null);
        return delta;
    }

    private List deltaRemoved(int fromIndex, int toIndex) {
        int position = fromIndex;
        List rest = this.subList(fromIndex, toIndex);
        ArrayList<GTDelta> removed = new ArrayList<GTDelta>(rest.size());
        for (Object item : rest) {
            removed.add(this.deltaRemoved(position, item));
            ++position;
        }
        return removed;
    }

    private List deltaRemoved(Collection collection) {
        ArrayList<GTDelta> removed = new ArrayList<GTDelta>(collection.size());
        for (Object item : collection) {
            int position = this.indexOf(item);
            removed.add(this.deltaRemoved(position, item));
        }
        return removed;
    }

    private GTDelta deltaRemoved(int position, Object item) {
        if (item instanceof GTComponent) {
            GTComponent myChild = (GTComponent)item;
            myChild.setNote(GTNote.EMPTY);
        }
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, position), GTDelta.Kind.REMOVED, null, item);
        return delta;
    }

    public boolean add(Object item) {
        boolean added = super.add(item);
        GTDelta delta = this.deltaAdded(this.size() - 1, item);
        delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, delta);
        this.host.getNote().getParent().changed(delta);
        return added;
    }

    public void add(int index, Object item) {
        super.add(index, item);
        GTDelta delta = this.deltaAdded(index, item);
        delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, delta);
        this.host.getNote().getParent().changed(delta);
    }

    public boolean addAll(Collection list) {
        int position = this.isEmpty() ? 0 : this.size() - 1;
        boolean added = super.addAll(list);
        List changed = this.deltaAdded(position, this.size());
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, changed);
        this.host.getNote().getParent().changed((GTDelta)delta);
        return added;
    }

    public boolean addAll(int index, Collection list) {
        int start = index;
        int end = start + list.size();
        boolean added = super.addAll(index, list);
        List changed = this.deltaAdded(start, end);
        changed.addAll(this.deltaMove(end, this.size()));
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, changed);
        this.host.getNote().getParent().changed((GTDelta)delta);
        return added;
    }

    public void clear() {
        super.clear();
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host);
        this.host.getNote().getParent().changed((GTDelta)delta);
    }

    public Object remove(int index) {
        List changed = this.deltaRemoved(index, index + 1);
        Object item = super.remove(index);
        changed.addAll(this.deltaMove(index, this.size()));
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, changed);
        this.host.getNote().getParent().changed((GTDelta)delta);
        return item;
    }

    public boolean remove(Object item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public boolean removeAll(Collection collection) {
        List changed = this.deltaRemoved(collection);
        boolean removed = super.removeAll(collection);
        changed.addAll(this.deltaMove(0, this.size()));
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, changed);
        this.host.getNote().getParent().changed((GTDelta)delta);
        return removed;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        List changed = this.deltaRemoved(fromIndex, toIndex);
        super.removeRange(fromIndex, toIndex);
        changed.addAll(this.deltaMove(0, this.size()));
        GTDeltaImpl delta = new GTDeltaImpl(new GTNoteImpl(this.notificationName, -1), GTDelta.Kind.CHANGED, this.host, changed);
        this.host.getNote().getParent().changed((GTDelta)delta);
    }
}

