/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;

public class FeatureListenerManager {
    Map listenerMap = new HashMap();

    public void addFeatureListener(FeatureSource featureSource, FeatureListener featureListener) {
        this.eventListenerList(featureSource).add(FeatureListener.class, featureListener);
    }

    public void removeFeatureListener(FeatureSource featureSource, FeatureListener featureListener) {
        EventListenerList list = this.eventListenerList(featureSource);
        list.remove(FeatureListener.class, featureListener);
        if (list.getListenerCount() == 0) {
            this.cleanListenerList(featureSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListenerList eventListenerList(FeatureSource featureSource) {
        Map map = this.listenerMap;
        synchronized (map) {
            if (this.listenerMap.containsKey(featureSource)) {
                return (EventListenerList)this.listenerMap.get(featureSource);
            }
            EventListenerList listenerList = new EventListenerList();
            this.listenerMap.put(featureSource, listenerList);
            return listenerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanListenerList(FeatureSource featureSource) {
        Map map = this.listenerMap;
        synchronized (map) {
            this.listenerMap.remove(featureSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getListeners(String typeName, Transaction transaction) {
        HashMap<FeatureSource, FeatureListener[]> map = new HashMap<FeatureSource, FeatureListener[]>();
        Map map2 = this.listenerMap;
        synchronized (map2) {
            for (Map.Entry entry : this.listenerMap.entrySet()) {
                EventListenerList listenerList;
                FeatureListener[] listeners;
                FeatureSource featureSource = (FeatureSource)entry.getKey();
                if (!featureSource.getSchema().getTypeName().equals(typeName) || transaction != Transaction.AUTO_COMMIT && FeatureListenerManager.hasTransaction(featureSource) && transaction != FeatureListenerManager.getTransaction(featureSource) || (listeners = (FeatureListener[])(listenerList = (EventListenerList)entry.getValue()).getListeners(FeatureListener.class)).length == 0) continue;
                map.put(featureSource, listeners);
            }
        }
        return map;
    }

    private static boolean hasTransaction(FeatureSource featureSource) {
        return featureSource instanceof FeatureStore && ((FeatureStore)featureSource).getTransaction() != null;
    }

    private static Transaction getTransaction(FeatureSource featureSource) {
        if (FeatureListenerManager.hasTransaction(featureSource)) {
            return ((FeatureStore)featureSource).getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    public void fireFeaturesAdded(String typeName, Transaction transaction, Envelope bounds, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, 1, bounds);
        } else {
            this.fireEvent(typeName, transaction, 1, bounds);
        }
    }

    public void fireFeaturesChanged(String typeName, Transaction transaction, Envelope bounds, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, 0, bounds);
        } else {
            this.fireEvent(typeName, transaction, 0, bounds);
        }
    }

    public void fireChanged(String typeName, Transaction transaction, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, 0, null);
        } else {
            this.fireEvent(typeName, transaction, 0, null);
        }
    }

    private void fireCommit(String typeName, Transaction transaction, int type, Envelope bounds) {
        Map map = this.getListeners(typeName, Transaction.AUTO_COMMIT);
        for (Map.Entry entry : map.entrySet()) {
            FeatureSource featureSource = (FeatureSource)entry.getKey();
            FeatureListener[] listeners = (FeatureListener[])entry.getValue();
            if (FeatureListenerManager.hasTransaction(featureSource) && FeatureListenerManager.getTransaction(featureSource) == transaction) continue;
            FeatureEvent event = new FeatureEvent(featureSource, type, bounds);
            for (int l = 0; l < listeners.length; ++l) {
                listeners[l].changed(event);
            }
        }
    }

    private void fireEvent(String typeName, Transaction transaction, int type, Envelope bounds) {
        Map map = this.getListeners(typeName, transaction);
        for (Map.Entry entry : map.entrySet()) {
            FeatureSource featureSource = (FeatureSource)entry.getKey();
            FeatureListener[] listeners = (FeatureListener[])entry.getValue();
            FeatureEvent event = new FeatureEvent(featureSource, type, bounds);
            for (int l = 0; l < listeners.length; ++l) {
                listeners[l].changed(event);
            }
        }
    }

    public void fireFeaturesRemoved(String typeName, Transaction transaction, Envelope bounds, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, -1, bounds);
        } else {
            this.fireEvent(typeName, transaction, -1, bounds);
        }
    }
}

