/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class DefaultFeatureResults
extends DataFeatureCollection {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    protected Query query;
    protected FeatureSource featureSource;
    protected MathTransform transform;

    public DefaultFeatureResults(FeatureSource source, Query query) throws IOException {
        super(null, DefaultFeatureResults.getSchemaInternal(source, query));
        this.featureSource = source;
        FeatureType origionalType = source.getSchema();
        String typeName = origionalType.getTypeName();
        if (typeName.equals(query.getTypeName())) {
            this.query = query;
        } else {
            this.query = new DefaultQuery(query);
            ((DefaultQuery)this.query).setTypeName(typeName);
        }
        if (origionalType.getPrimaryGeometry() == null) {
            return;
        }
        CoordinateReferenceSystem cs = null;
        if (query.getCoordinateSystemReproject() != null) {
            cs = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            cs = query.getCoordinateSystem();
        }
        CoordinateReferenceSystem origionalCRS = origionalType.getPrimaryGeometry().getCoordinateSystem();
        if (query.getCoordinateSystem() != null) {
            origionalCRS = query.getCoordinateSystem();
        }
        if (cs != null && cs != origionalCRS) {
            try {
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)origionalCRS, (CoordinateReferenceSystem)cs, (boolean)true);
            }
            catch (FactoryException noTransform) {
                throw (IOException)new IOException("Could not reproject data to " + cs).initCause(noTransform);
            }
        }
    }

    static FeatureType getSchemaInternal(FeatureSource featureSource, Query query) {
        FeatureType origionalType = featureSource.getSchema();
        FeatureType schema = null;
        CoordinateReferenceSystem cs = null;
        if (query.getCoordinateSystemReproject() != null) {
            cs = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            cs = query.getCoordinateSystem();
        }
        try {
            schema = cs == null ? (query.retrieveAllProperties() ? featureSource.getSchema() : DataUtilities.createSubType(featureSource.getSchema(), query.getPropertyNames())) : DataUtilities.createSubType(origionalType, query.getPropertyNames(), cs, query.getTypeName(), null);
        }
        catch (SchemaException e) {
            LOGGER.log(Level.WARNING, "Could not change projection to " + cs, e);
            schema = null;
        }
        return schema;
    }

    public FeatureType getSchema() {
        return super.getSchema();
    }

    protected Transaction getTransaction() {
        if (this.featureSource instanceof FeatureStore) {
            FeatureStore featureStore = (FeatureStore)this.featureSource;
            return featureStore.getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    public FeatureReader reader() throws IOException {
        FeatureReader reader = this.featureSource.getDataStore().getFeatureReader(this.query, this.getTransaction());
        int maxFeatures = this.query.getMaxFeatures();
        if (maxFeatures != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader(reader, maxFeatures);
        }
        if (this.transform != null) {
            reader = new ReprojectFeatureReader(reader, this.getSchema(), this.transform);
        }
        return reader;
    }

    protected FeatureReader boundsReader() throws IOException {
        ArrayList<String> attributes = new ArrayList<String>();
        FeatureType schema = this.featureSource.getSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeType at = schema.getAttributeType(i);
            if (!(at instanceof GeometricAttributeType)) continue;
            attributes.add(at.getLocalName());
        }
        DefaultQuery q = new DefaultQuery(this.query);
        q.setPropertyNames(attributes);
        FeatureReader reader = this.featureSource.getDataStore().getFeatureReader((Query)q, this.getTransaction());
        int maxFeatures = this.query.getMaxFeatures();
        if (maxFeatures == Integer.MAX_VALUE) {
            return reader;
        }
        return new MaxFeatureReader(reader, maxFeatures);
    }

    public ReferencedEnvelope getBounds() {
        Envelope bounds;
        try {
            bounds = this.featureSource.getBounds(this.query);
        }
        catch (IOException e1) {
            bounds = new Envelope();
        }
        if (bounds == null) {
            try {
                bounds = new Envelope();
                FeatureReader reader = this.boundsReader();
                while (reader.hasNext()) {
                    Feature feature = reader.next();
                    bounds.expandToInclude((Envelope)feature.getBounds());
                }
                reader.close();
            }
            catch (IllegalAttributeException e) {
                bounds = new Envelope();
            }
            catch (IOException e) {
                bounds = new Envelope();
            }
        }
        return ReferencedEnvelope.reference((Envelope)bounds);
    }

    public int getCount() throws IOException {
        int count = this.featureSource.getCount(this.query);
        if (count != -1) {
            return count;
        }
        try {
            count = 0;
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                reader.next();
                ++count;
            }
            reader.close();
            return count;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not read feature ", (Throwable)e);
        }
    }

    public FeatureCollection collection() throws IOException {
        try {
            FeatureCollection collection = FeatureCollections.newCollection();
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                collection.add((Object)reader.next());
            }
            reader.close();
            return collection;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not read feature ", (Throwable)e);
        }
    }
}

