/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;

public final class DataStoreFinder {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    private static FactoryRegistry registry;

    private DataStoreFinder() {
    }

    public static synchronized DataStore getDataStore(Map params) throws IOException {
        Iterator ps = DataStoreFinder.getServiceRegistry().getServiceProviders(DataStoreFactorySpi.class);
        IOException canProcessButNotAvailable = null;
        while (ps.hasNext()) {
            DataStoreFactorySpi fac = (DataStoreFactorySpi)ps.next();
            boolean canProcess = false;
            try {
                canProcess = fac.canProcess(params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem asking " + fac.getDisplayName() + " if it can process request:" + t, t);
                continue;
            }
            if (!canProcess) continue;
            boolean isAvailable = false;
            try {
                isAvailable = fac.isAvailable();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Difficulity checking if " + fac.getDisplayName() + " is available:" + t, t);
                continue;
            }
            if (isAvailable) {
                try {
                    return fac.createDataStore(params);
                }
                catch (IOException couldNotConnect) {
                    canProcessButNotAvailable = couldNotConnect;
                    LOGGER.log(Level.WARNING, fac.getDisplayName() + " should be used, but could not connect", couldNotConnect);
                    continue;
                }
            }
            canProcessButNotAvailable = new IOException(fac.getDisplayName() + " should be used, but is not availble. Have you installed the required drivers or jar files?");
            LOGGER.log(Level.WARNING, fac.getDisplayName() + " should be used, but is not availble", canProcessButNotAvailable);
        }
        if (canProcessButNotAvailable != null) {
            throw canProcessButNotAvailable;
        }
        return null;
    }

    public static synchronized Iterator getAllDataStores() {
        HashSet availableDS = new HashSet(5);
        return DataStoreFinder.getServiceRegistry().getServiceProviders(DataStoreFactorySpi.class);
    }

    public static synchronized Iterator getAvailableDataStores() {
        HashSet<DataStoreFactorySpi> availableDS = new HashSet<DataStoreFactorySpi>(5);
        Iterator it = DataStoreFinder.getServiceRegistry().getServiceProviders(DataStoreFactorySpi.class);
        while (it.hasNext()) {
            DataStoreFactorySpi dsFactory = (DataStoreFactorySpi)it.next();
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DataStoreFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataStoreFactorySpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DataStoreFinder.getServiceRegistry().scanForPlugins();
    }
}

