/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.defaults;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.geotools.catalog.defaults.AST;

public class ASTFactory {
    private ASTFactory() {
    }

    public static AST parse(String str) {
        List tokens = ASTFactory.tokenize(str);
        Stack<And> s = new Stack<And>();
        ListIterator li = tokens.listIterator();
        while (li.hasNext()) {
            ASTFactory.node(s, li);
        }
        if (s.size() == 1) {
            return (AST)s.pop();
        }
        if (s.size() > 1) {
            while (s.size() > 1) {
                AST p1 = (AST)s.pop();
                AST p2 = (AST)s.pop();
                s.push(new And(p1, p2));
            }
            return (AST)s.pop();
        }
        System.err.println("An internal error creating an AST may have occured");
        return null;
    }

    protected static List tokenize(String pattern) {
        LinkedList<String> l = new LinkedList<String>();
        block12: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '(': {
                    l.add("(");
                    continue block12;
                }
                case ')': {
                    l.add(")");
                    continue block12;
                }
                case '+': {
                    l.add("+");
                    continue block12;
                }
                case '-': {
                    l.add("-");
                    continue block12;
                }
                case '!': {
                    l.add("!");
                    continue block12;
                }
                case '\"': {
                    int j = pattern.indexOf(34, i + 1);
                    l.add(pattern.substring(i + 1, j));
                    i = j;
                    continue block12;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block12;
                }
                case 'A': {
                    if (pattern.charAt(i + 1) != 'N' || pattern.charAt(i + 2) != 'D') continue block12;
                    l.add("+");
                    i += 2;
                    continue block12;
                }
                case 'O': {
                    if (pattern.charAt(i + 1) != 'R') continue block12;
                    l.add("-");
                    ++i;
                    continue block12;
                }
                case 'N': {
                    if (pattern.charAt(i + 1) == 'O' && pattern.charAt(i + 2) == 'T') {
                        l.add("!");
                        i += 2;
                    }
                }
                default: {
                    int j;
                    for (j = i + 1; j < pattern.length() && pattern.charAt(j) != '\"' && pattern.charAt(j) != '+' && pattern.charAt(j) != '-' && pattern.charAt(j) != '!' && pattern.charAt(j) != '(' && pattern.charAt(j) != ')' && pattern.charAt(j) != ' ' && pattern.charAt(j) != '\t' && pattern.charAt(j) != '\n'; ++j) {
                    }
                    l.add(pattern.substring(i, j));
                    i = i == j ? j : j - 1;
                }
            }
        }
        return l;
    }

    private static void node(Stack s, ListIterator li) {
        if (li.hasNext()) {
            String token = (String)li.next();
            char c = token.charAt(0);
            switch (c) {
                case '(': {
                    ASTFactory.node(s, li);
                    break;
                }
                case ')': {
                    break;
                }
                case '+': {
                    AST prev = (AST)s.pop();
                    ASTFactory.node(s, li);
                    AST next = (AST)s.pop();
                    s.push(new And(prev, next));
                    break;
                }
                case '-': {
                    AST prev = (AST)s.pop();
                    ASTFactory.node(s, li);
                    AST next = (AST)s.pop();
                    s.push(new Or(prev, next));
                    break;
                }
                case '!': {
                    ASTFactory.node(s, li);
                    AST next = (AST)s.pop();
                    s.push(new Not(next));
                    break;
                }
                default: {
                    s.push(new Literal(token));
                }
            }
        }
    }

    private static class Literal
    implements AST {
        private String value;

        private Literal() {
        }

        public Literal(String value) {
            this.value = value;
        }

        public boolean accept(String datum) {
            return this.value != null && datum != null && datum.toUpperCase().indexOf(this.value.toUpperCase()) > -1;
        }

        public int type() {
            return 0;
        }

        public AST getLeft() {
            return null;
        }

        public AST getRight() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class Not
    implements AST {
        private AST child;

        private Not() {
        }

        public Not(AST child) {
            this.child = child;
        }

        public boolean accept(String datum) {
            return this.child == null || !this.child.accept(datum);
        }

        public int type() {
            return 4;
        }

        public AST getLeft() {
            return this.child;
        }

        public AST getRight() {
            return null;
        }
    }

    private static class Or
    implements AST {
        private AST left;
        private AST right;

        private Or() {
        }

        public Or(AST left, AST right) {
            this.left = left;
            this.right = right;
        }

        public boolean accept(String datum) {
            return this.right != null && this.right.accept(datum) || this.left != null && this.left.accept(datum);
        }

        public int type() {
            return 2;
        }

        public AST getLeft() {
            return this.left;
        }

        public AST getRight() {
            return this.right;
        }
    }

    private static class And
    implements AST {
        private AST left;
        private AST right;

        private And() {
        }

        public And(AST left, AST right) {
            this.left = left;
            this.right = right;
        }

        public boolean accept(String datum) {
            return this.left != null && this.right != null && this.left.accept(datum) && this.right.accept(datum);
        }

        public int type() {
            return 1;
        }

        public AST getLeft() {
            return this.left;
        }

        public AST getRight() {
            return this.right;
        }
    }
}

