/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.fulltext;

import com.gisgraphy.domain.valueobject.Output;
import com.gisgraphy.domain.valueobject.Pagination;
import com.gisgraphy.fulltext.spell.SpellCheckerConfig;
import com.gisgraphy.service.AbstractGisQuery;
import com.vividsolutions.jts.geom.Point;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FulltextQuery
extends AbstractGisQuery {
    private static final Pattern OR_PATTERN = Pattern.compile("\\b(OR)\\b");
    private static final Pattern AND_PATTERN = Pattern.compile("\\b(AND)\\b");
    public static final String COUNTRY_PARAMETER = "country";
    public static final String LANG_PARAMETER = "lang";
    public static final String STYLE_PARAMETER = "style";
    public static final String PLACETYPE_PARAMETER = "placetype";
    public static final String QUERY_PARAMETER = "q";
    public static final String ALLWORDSREQUIRED_PARAMETER = "allwordsrequired";
    public static final String SPELLCHECKING_PARAMETER = "spellchecking";
    public static final String LAT_PARAMETER = "lat";
    public static final String LONG_PARAMETER = "lng";
    public static final String RADIUS_PARAMETER = "radius";
    public static final String SUGGEST_PARAMETER = "suggest";
    public static final String FUZZY_PARAMETER = "fuzzy";
    public static final int REGEXP_CASESENSITIVE_FLAG = 64;
    private static final Pattern CLEAN_QUERY_PATTERN = Pattern.compile("([\\|\\?\\+\\*\\{\\}\\(\\)\\=\\!\"'\\\\]+)");
    private static final Pattern COMMA_PATTERN = Pattern.compile("([\\,]+)");
    public static final int DEFAULT_MAX_RESULTS = 50;
    public static final int QUERY_MAX_LENGTH = 200;
    public static final boolean ALL_WORDS_REQUIRED_DEFAULT_OPTION = false;
    public static final int DEFAULT_NB_RESULTS = 10;
    public static final double DEFAULT_RADIUS = 10000.0;
    protected Point point;
    private double radius = 10000.0;
    public static final Logger logger = LoggerFactory.getLogger(FulltextQuery.class);
    private Class<?>[] placeTypes = null;
    private String query = "";
    private String countryCode;
    private boolean allWordsRequired = false;
    private boolean suggest = false;
    private boolean spellchecking = SpellCheckerConfig.activeByDefault;
    private boolean fuzzy = false;

    private FulltextQuery() {
    }

    public FulltextQuery around(Point point) {
        this.point = point;
        return this;
    }

    public Point getPoint() {
        return this.point;
    }

    public FulltextQuery withRadius(double radius) {
        this.radius = radius < 0.0 ? 10000.0 : radius;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public Double getLatitude() {
        Double latitude = null;
        if (this.point != null) {
            latitude = this.point.getY();
        }
        return latitude;
    }

    public Double getLongitude() {
        Double longitude = null;
        if (this.point != null) {
            longitude = this.point.getX();
        }
        return longitude;
    }

    public FulltextQuery(String query, Pagination pagination, Output output, Class<?>[] placeType, String countryCode) {
        super(pagination, output);
        this.withQuery(query);
        this.withPlaceTypes(placeType);
        this.limitToCountryCode(countryCode);
    }

    public FulltextQuery withQuery(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("Query must not be empty");
        }
        if (queryString.length() > 200) {
            throw new IllegalArgumentException("query is limited to 200characters");
        }
        this.query = queryString.trim();
        this.cleanQueryString();
        if ("".equals(this.query.trim()) || "-".equals(this.query.trim())) {
            throw new IllegalArgumentException("Query must not be empty");
        }
        return this;
    }

    public FulltextQuery(String query) {
        this.withQuery(query);
    }

    public String getQuery() {
        return this.query;
    }

    public FulltextQuery limitToCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public boolean isOutputIndented() {
        return this.output.isIndented();
    }

    public Class<?>[] getPlaceTypes() {
        return this.placeTypes;
    }

    public FulltextQuery withPlaceTypes(Class<?>[] placeTypes) {
        this.placeTypes = placeTypes;
        return this;
    }

    @Override
    public String toString() {
        String allwordsRequiredString = this.allWordsRequired ? " with all words required " : " without all words required ";
        String autosuggestionString = this.isSuggest() ? " for auto suggestion " : " ";
        autosuggestionString = this.isFuzzy() ? " in fuzzy mode " : " ";
        String asString = "FullTextQuery '" + this.query + "' " + allwordsRequiredString + autosuggestionString;
        if (this.point != null) {
            asString = asString + "with apikey=" + this.getApikey() + " around (lat='" + this.point.getY() + "',long='" + this.point.getX() + "') and radius=" + this.radius + " for ";
        }
        if (this.placeTypes == null) {
            asString = asString + "all placeType";
        } else {
            for (int i = 0; i < this.placeTypes.length; ++i) {
                if (this.placeTypes[i] == null) continue;
                asString = asString + this.placeTypes[i].getSimpleName();
                if (i == this.placeTypes.length - 1) continue;
                asString = asString + " and ";
            }
        }
        asString = asString + " with " + this.getOutput() + " and " + this.pagination + " for countrycode " + this.countryCode;
        return asString;
    }

    public FulltextQuery withSpellChecking() {
        this.spellchecking = true;
        return this;
    }

    public FulltextQuery withoutSpellChecking() {
        this.spellchecking = false;
        return this;
    }

    public boolean hasSpellChecking() {
        return this.spellchecking;
    }

    @Override
    public int getMaxLimitResult() {
        return 50;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = 31 * result + (this.placeTypes == null ? 0 : this.placeTypes.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.spellchecking ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulltextQuery other = (FulltextQuery)obj;
        if (this.countryCode == null ? other.countryCode != null : !this.countryCode.equals(other.countryCode)) {
            return false;
        }
        if (this.placeTypes == null ? other.placeTypes != null : !this.placeTypes.equals(other.placeTypes)) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        return this.spellchecking == other.spellchecking;
    }

    public void cleanQueryString() {
        if (this.query != null) {
            this.query = CLEAN_QUERY_PATTERN.matcher(this.query).replaceAll(" ");
            this.query = COMMA_PATTERN.matcher(this.query).replaceAll(", ");
            this.query = AND_PATTERN.matcher(this.query).replaceAll("and");
            this.query = OR_PATTERN.matcher(this.query).replaceAll("or").trim();
        }
    }

    public boolean isAllwordsRequired() {
        return this.allWordsRequired;
    }

    public FulltextQuery withAllWordsRequired(boolean allWordsRequired) {
        this.allWordsRequired = allWordsRequired;
        return this;
    }

    public boolean isSpellcheckingEnabled() {
        return this.spellchecking;
    }

    public boolean isSuggest() {
        return this.suggest;
    }

    public FulltextQuery withSuggest(boolean suggest) {
        this.suggest = suggest;
        return this;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public FulltextQuery withFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        return this;
    }
}

