/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.fulltext;

import com.gisgraphy.domain.valueobject.Output;
import com.gisgraphy.fulltext.FullTextFields;
import com.gisgraphy.fulltext.FulltextQuery;
import com.gisgraphy.fulltext.FulltextResultsDto;
import com.gisgraphy.fulltext.IFullTextSearchEngine;
import com.gisgraphy.fulltext.SolrResponseDto;
import com.gisgraphy.rest.IRestClient;
import com.gisgraphy.rest.RestClient;
import com.gisgraphy.rest.RestClientException;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.service.ServiceException;
import com.gisgraphy.street.HouseNumberDeserializer;
import com.gisgraphy.street.HouseNumberDto;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FulltextClient
implements IFullTextSearchEngine {
    private String baseUrl;
    private ObjectMapper mapper = new ObjectMapper();
    private HouseNumberDeserializer houseNumberDeserializer = new HouseNumberDeserializer();
    private IRestClient restClient = new RestClient();

    public FulltextClient(String baseUrl) {
        if (baseUrl == null || "".equals(baseUrl.trim())) {
            throw new IllegalArgumentException("fulltext base URL is empty or null");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("fulltext base URL should be correct");
        }
        this.baseUrl = baseUrl;
    }

    @Override
    public FulltextResultsDto executeQuery(FulltextQuery query) throws ServiceException {
        LinkedHashMap response;
        Map userData;
        String jsonFeed;
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        query.withOutput(Output.withFormat((OutputFormat)OutputFormat.JSON).withStyle(query.getOutputStyle()));
        String queryString = this.fulltextQueryToQueryString(query);
        try {
            jsonFeed = this.restClient.get(this.baseUrl + queryString, String.class, OutputFormat.JSON);
        }
        catch (RestClientException e1) {
            throw new ServiceException("Exception during execution of " + query + " : " + e1.getMessage(), (Throwable)e1);
        }
        try {
            userData = (Map)this.mapper.readValue(jsonFeed, Map.class);
        }
        catch (JsonParseException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        FulltextResultsDto dto = new FulltextResultsDto();
        LinkedHashMap responseHeaders = (LinkedHashMap)userData.get("responseHeader");
        if (responseHeaders.size() > 0 && (Integer)responseHeaders.get("status") != 0) {
            String errorMessage = "unknow Error";
            if (responseHeaders.get("error") != null) {
                errorMessage = (String)responseHeaders.get("error");
            }
            throw new ServiceException("An error has occured during execution of " + query + " : " + errorMessage);
        }
        if (responseHeaders.size() > 0 && responseHeaders.get("QTime") != null) {
            dto.QTime = (Integer)responseHeaders.get("QTime");
        }
        if ((response = (LinkedHashMap)userData.get("response")).size() > 0) {
            if (response.get("numFound") != null) {
                dto.numFound = ((Integer)response.get("numFound")).intValue();
            }
            if (response.get(" maxScore") != null) {
                dto.maxScore = (Float)response.get("maxScore");
            }
        }
        ArrayList docs = (ArrayList)response.get("docs");
        dto.resultsSize = docs.size();
        ArrayList<SolrResponseDto> results = new ArrayList<SolrResponseDto>();
        ArrayList<String> alternateNames = new ArrayList<String>();
        ArrayList<String> adm1AlternateNames = new ArrayList<String>();
        ArrayList<String> adm2AlternateNames = new ArrayList<String>();
        ArrayList<String> countryAlternateNames = new ArrayList<String>();
        HashMap<String, List<String>> alternateNamesMultiLang = new HashMap<String, List<String>>();
        HashMap<String, List<String>> adm1AlternateNamesMultiLang = new HashMap<String, List<String>>();
        HashMap<String, List<String>> adm2AlternateNamesMultiLang = new HashMap<String, List<String>>();
        HashMap<String, List<String>> countryAlternateNamesMultiLang = new HashMap<String, List<String>>();
        for (LinkedHashMap doc : docs) {
            List isinzip;
            SolrResponseDto solrResponseDto = new SolrResponseDto();
            if (query.getOutputStyle() == Output.OutputStyle.FULL) {
                for (Map.Entry key : doc.entrySet()) {
                    Map.Entry entry = key;
                    String key2 = (String)entry.getKey();
                    if (key2 == null) continue;
                    System.out.println(key2 + ":" + entry.getValue());
                    String alternatenamesPrefix = FullTextFields.NAME.getValue() + FullTextFields.ALTERNATE_NAME_SUFFIX.getValue();
                    String adm1AlternatenamesPrefix = FullTextFields.ADM1NAME.getValue() + FullTextFields.ALTERNATE_NAME_SUFFIX.getValue();
                    String adm2alternatenamesPrefix = FullTextFields.ADM2NAME.getValue() + FullTextFields.ALTERNATE_NAME_SUFFIX.getValue();
                    String countryAlternatenamesPrefix = FullTextFields.COUNTRYNAME.getValue() + FullTextFields.ALTERNATE_NAME_SUFFIX.getValue();
                    String alternatenamesMultiLangPrefix = FullTextFields.NAME.getValue() + FullTextFields.ALTERNATE_NAME_DYNA_SUFFIX.getValue();
                    String adm1AlternatenamesMultiLangPrefix = FullTextFields.ADM1NAME.getValue() + FullTextFields.ALTERNATE_NAME_DYNA_SUFFIX.getValue();
                    String adm2alternatenamesMultiLangPrefix = FullTextFields.ADM2NAME.getValue() + FullTextFields.ALTERNATE_NAME_DYNA_SUFFIX.getValue();
                    String countryAlternatenamesMultiLangPrefix = FullTextFields.COUNTRYNAME.getValue() + FullTextFields.ALTERNATE_NAME_DYNA_SUFFIX.getValue();
                    if (key2.equals(alternatenamesPrefix)) {
                        if (entry.getValue().getClass() == ArrayList.class) {
                            alternateNames.addAll((ArrayList)entry.getValue());
                            continue;
                        }
                        if (entry.getValue().getClass() != String.class) continue;
                        alternateNames.add((String)entry.getValue());
                        continue;
                    }
                    if (key2.equals(adm1AlternatenamesPrefix)) {
                        if (entry.getValue().getClass() == ArrayList.class) {
                            adm1AlternateNames.addAll((ArrayList)entry.getValue());
                            continue;
                        }
                        if (entry.getValue().getClass() != String.class) continue;
                        adm1AlternateNames.add((String)entry.getValue());
                        continue;
                    }
                    if (key2.equals(adm2alternatenamesPrefix)) {
                        if (entry.getValue().getClass() == ArrayList.class) {
                            adm2AlternateNames.addAll((ArrayList)entry.getValue());
                            continue;
                        }
                        if (entry.getValue().getClass() != String.class) continue;
                        adm2AlternateNames.add((String)entry.getValue());
                        continue;
                    }
                    if (key2.equals(countryAlternatenamesPrefix)) {
                        if (entry.getValue().getClass() == ArrayList.class) {
                            countryAlternateNames.addAll((ArrayList)entry.getValue());
                            continue;
                        }
                        if (entry.getValue().getClass() != String.class) continue;
                        countryAlternateNames.add((String)entry.getValue());
                        continue;
                    }
                    if (key2.startsWith(alternatenamesMultiLangPrefix)) {
                        this.getAlternateNamesMap(entry, alternateNamesMultiLang);
                        continue;
                    }
                    if (key2.startsWith(adm1AlternatenamesMultiLangPrefix)) {
                        this.getAlternateNamesMap(entry, adm1AlternateNamesMultiLang);
                        continue;
                    }
                    if (key2.startsWith(adm2alternatenamesMultiLangPrefix)) {
                        this.getAlternateNamesMap(entry, adm2AlternateNamesMultiLang);
                        continue;
                    }
                    if (!key2.startsWith(countryAlternatenamesMultiLangPrefix)) continue;
                    this.getAlternateNamesMap(entry, countryAlternateNamesMultiLang);
                }
            }
            solrResponseDto.name_alternates = alternateNames;
            solrResponseDto.adm1_names_alternate = adm1AlternateNames;
            solrResponseDto.adm2_names_alternate = adm2AlternateNames;
            solrResponseDto.country_names_alternate = countryAlternateNames;
            solrResponseDto.name_alternates_localized = alternateNamesMultiLang;
            solrResponseDto.adm1_names_alternate_localized = adm1AlternateNamesMultiLang;
            solrResponseDto.adm2_names_alternate_localized = adm2AlternateNamesMultiLang;
            solrResponseDto.country_names_alternate_localized = countryAlternateNamesMultiLang;
            if (doc.get(FullTextFields.FEATUREID.getValue()) != null) {
                solrResponseDto.feature_id = Long.valueOf(doc.get(FullTextFields.FEATUREID.getValue()).toString());
            }
            if (doc.get(FullTextFields.FEATURECLASS.getValue()) != null) {
                solrResponseDto.feature_class = doc.get(FullTextFields.FEATURECLASS.getValue()).toString();
            }
            if (doc.get(FullTextFields.FEATURECODE.getValue()) != null) {
                solrResponseDto.feature_code = doc.get(FullTextFields.FEATURECODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.NAME.getValue()) != null) {
                solrResponseDto.name = doc.get(FullTextFields.NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.NAMEASCII.getValue()) != null) {
                solrResponseDto.name_ascii = doc.get(FullTextFields.NAMEASCII.getValue()).toString();
            }
            if (doc.get(FullTextFields.ELEVATION.getValue()) != null) {
                solrResponseDto.elevation = (Integer)doc.get(FullTextFields.ELEVATION.getValue());
            }
            if (doc.get(FullTextFields.GTOPO30.getValue()) != null) {
                solrResponseDto.gtopo30 = (Integer)doc.get(FullTextFields.GTOPO30.getValue());
            }
            if (doc.get(FullTextFields.TIMEZONE.getValue()) != null) {
                solrResponseDto.timezone = doc.get(FullTextFields.TIMEZONE.getValue()).toString();
            }
            if (doc.get(FullTextFields.FULLY_QUALIFIED_NAME.getValue()) != null) {
                solrResponseDto.fully_qualified_name = doc.get(FullTextFields.FULLY_QUALIFIED_NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.PLACETYPE.getValue()) != null) {
                solrResponseDto.placetype = doc.get(FullTextFields.PLACETYPE.getValue()).toString();
            }
            if (doc.get(FullTextFields.POPULATION.getValue()) != null) {
                solrResponseDto.population = (Integer)doc.get(FullTextFields.POPULATION.getValue());
            }
            if (doc.get(FullTextFields.LAT.getValue()) != null) {
                solrResponseDto.lat = (Double)doc.get(FullTextFields.LAT.getValue());
            }
            if (doc.get(FullTextFields.LONG.getValue()) != null) {
                solrResponseDto.lng = (Double)doc.get(FullTextFields.LONG.getValue());
            }
            if (doc.get(FullTextFields.ADM1CODE.getValue()) != null) {
                solrResponseDto.adm1_code = doc.get(FullTextFields.ADM1CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM2CODE.getValue()) != null) {
                solrResponseDto.adm2_code = doc.get(FullTextFields.ADM2CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM3CODE.getValue()) != null) {
                solrResponseDto.adm3_code = doc.get(FullTextFields.ADM3CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM4CODE.getValue()) != null) {
                solrResponseDto.adm4_code = doc.get(FullTextFields.ADM4CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM1NAME.getValue()) != null) {
                solrResponseDto.adm1_name = doc.get(FullTextFields.ADM1NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM2NAME.getValue()) != null) {
                solrResponseDto.adm2_name = doc.get(FullTextFields.ADM2NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM3NAME.getValue()) != null) {
                solrResponseDto.adm3_name = doc.get(FullTextFields.ADM3NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.ADM4NAME.getValue()) != null) {
                solrResponseDto.adm4_name = doc.get(FullTextFields.ADM4NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.COUNTRYCODE.getValue()) != null) {
                solrResponseDto.country_code = doc.get(FullTextFields.COUNTRYCODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.COUNTRYNAME.getValue()) != null) {
                solrResponseDto.country_name = doc.get(FullTextFields.COUNTRYNAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.COUNTRY_FLAG_URL.getValue()) != null) {
                solrResponseDto.country_flag_url = doc.get(FullTextFields.COUNTRY_FLAG_URL.getValue()).toString();
            }
            if (doc.get(FullTextFields.GOOGLE_MAP_URL.getValue()) != null) {
                solrResponseDto.google_map_url = doc.get(FullTextFields.GOOGLE_MAP_URL.getValue()).toString();
            }
            if (doc.get(FullTextFields.YAHOO_MAP_URL.getValue()) != null) {
                solrResponseDto.yahoo_map_url = doc.get(FullTextFields.YAHOO_MAP_URL.getValue()).toString();
            }
            if (doc.get(FullTextFields.OPENSTREETMAP_MAP_URL.getValue()) != null) {
                solrResponseDto.openstreetmap_map_url = doc.get(FullTextFields.OPENSTREETMAP_MAP_URL.getValue()).toString();
            }
            if (doc.get(FullTextFields.CONTINENT.getValue()) != null) {
                solrResponseDto.continent = doc.get(FullTextFields.CONTINENT.getValue()).toString();
            }
            if (doc.get(FullTextFields.CURRENCY_CODE.getValue()) != null) {
                solrResponseDto.currency_code = doc.get(FullTextFields.CURRENCY_CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.CURRENCY_NAME.getValue()) != null) {
                solrResponseDto.currency_name = doc.get(FullTextFields.CURRENCY_NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.FIPS_CODE.getValue()) != null) {
                solrResponseDto.fips_code = doc.get(FullTextFields.FIPS_CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.ISOALPHA2_COUNTRY_CODE.getValue()) != null) {
                solrResponseDto.isoalpha2_country_code = doc.get(FullTextFields.ISOALPHA2_COUNTRY_CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.ISOALPHA3_COUNTRY_CODE.getValue()) != null) {
                solrResponseDto.isoalpha3_country_code = doc.get(FullTextFields.ISOALPHA3_COUNTRY_CODE.getValue()).toString();
            }
            if (doc.get(FullTextFields.POSTAL_CODE_MASK.getValue()) != null) {
                solrResponseDto.postal_code_mask = doc.get(FullTextFields.POSTAL_CODE_MASK.getValue()).toString();
            }
            if (doc.get(FullTextFields.POSTAL_CODE_REGEX.getValue()) != null) {
                solrResponseDto.postal_code_regex = doc.get(FullTextFields.POSTAL_CODE_REGEX.getValue()).toString();
            }
            if (doc.get(FullTextFields.PHONE_PREFIX.getValue()) != null) {
                solrResponseDto.phone_prefix = doc.get(FullTextFields.PHONE_PREFIX.getValue()).toString();
            }
            if (doc.get(FullTextFields.TLD.getValue()) != null) {
                solrResponseDto.tld = doc.get(FullTextFields.TLD.getValue()).toString();
            }
            if (doc.get(FullTextFields.CAPITAL_NAME.getValue()) != null) {
                solrResponseDto.capital_name = doc.get(FullTextFields.CAPITAL_NAME.getValue()).toString();
            }
            if (doc.get(FullTextFields.LEVEL.getValue()) != null) {
                solrResponseDto.level = (Integer)doc.get(FullTextFields.LEVEL.getValue());
            }
            if (doc.get(FullTextFields.LENGTH.getValue()) != null) {
                solrResponseDto.length = (Double)doc.get(FullTextFields.LENGTH.getValue());
            }
            if (doc.get(FullTextFields.ONE_WAY.getValue()) != null) {
                solrResponseDto.one_way = Boolean.valueOf(doc.get(FullTextFields.ONE_WAY.getValue()).toString());
            }
            if (doc.get(FullTextFields.STREET_TYPE.getValue()) != null) {
                solrResponseDto.street_type = doc.get(FullTextFields.STREET_TYPE.getValue()).toString();
            }
            if (doc.get(FullTextFields.OPENSTREETMAP_ID.getValue()) != null) {
                solrResponseDto.openstreetmap_id = Long.valueOf(doc.get(FullTextFields.OPENSTREETMAP_ID.getValue()).toString());
            }
            if (doc.get(FullTextFields.IS_IN.getValue()) != null) {
                solrResponseDto.is_in = doc.get(FullTextFields.IS_IN.getValue()).toString();
            }
            if (doc.get(FullTextFields.IS_IN_PLACE.getValue()) != null) {
                solrResponseDto.is_in_place = doc.get(FullTextFields.IS_IN_PLACE.getValue()).toString();
            }
            if (doc.get(FullTextFields.IS_IN_ADM.getValue()) != null) {
                solrResponseDto.is_in_adm = doc.get(FullTextFields.IS_IN_ADM.getValue()).toString();
            }
            if (doc.get(FullTextFields.IS_IN_ZIP.getValue()) != null && (isinzip = (List)doc.get(FullTextFields.IS_IN_ZIP.getValue())) != null) {
                solrResponseDto.is_in_zip = new HashSet(isinzip);
            }
            if (doc.get(FullTextFields.HOUSE_NUMBERS.getValue()) != null) {
                solrResponseDto.house_numbers = this.getHouseNumber((List)doc.get(FullTextFields.HOUSE_NUMBERS.getValue()));
            }
            results.add(solrResponseDto);
        }
        dto.results = results;
        return dto;
    }

    private List<HouseNumberDto> getHouseNumber(List<String> houseNumberAsList) {
        ArrayList<HouseNumberDto> houseNumbers = new ArrayList<HouseNumberDto>();
        if (houseNumberAsList != null) {
            for (String hnAsString : houseNumberAsList) {
                HouseNumberDto dto = this.houseNumberDeserializer.deserialize(hnAsString);
                if (dto == null) continue;
                houseNumbers.add(dto);
            }
        }
        return houseNumbers;
    }

    private void getAlternateNamesMap(Map.Entry entry, Map<String, List<String>> map) {
        String key = (String)entry.getKey();
        String languageCode = key.substring(key.lastIndexOf("_") + 1);
        ArrayList newLanguages = (ArrayList)entry.getValue();
        List<String> languageList = map.get(languageCode);
        if (languageList == null) {
            languageList = new ArrayList<String>();
            map.put(languageCode, languageList);
        }
        languageList.addAll(newLanguages);
    }

    public void executeAndSerialize(FulltextQuery arg0, OutputStream arg1) throws ServiceException {
        throw new RuntimeException("executeAndSerialize is not implemented");
    }

    public String executeQueryToString(FulltextQuery arg0) throws ServiceException {
        throw new RuntimeException("executeQueryToString is not implemented");
    }

    @Override
    public List<?> executeQueryToDatabaseObjects(FulltextQuery query) throws ServiceException {
        throw new RuntimeException("executeQueryToDatabaseObjects is not implemented");
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public String getURL() {
        return this.baseUrl;
    }

    protected String fulltextQueryToQueryString(FulltextQuery query) {
        StringBuffer sb = new StringBuffer("?");
        this.addParameter(sb, "q", URLEncoder.encode(query.getQuery()));
        this.addParameter(sb, "lat", query.getLatitude());
        this.addParameter(sb, "lng", query.getLongitude());
        this.addParameter(sb, "radius", query.getRadius());
        this.addParameter(sb, "allwordsrequired", query.isAllwordsRequired());
        this.addParameter(sb, "from", query.getFirstPaginationIndex());
        this.addParameter(sb, "to", query.getLastPaginationIndex());
        this.addParameter(sb, "format", query.getOutputFormat());
        this.addParameter(sb, "lang", query.getOutputLanguage());
        this.addParameter(sb, "style", query.getOutputStyle());
        if (query.getPlaceTypes() != null) {
            for (Class clazz : query.getPlaceTypes()) {
                this.addParameter(sb, "placetype", clazz.getSimpleName());
            }
        }
        this.addParameter(sb, "apikey", query.getApikey());
        this.addParameter(sb, "indent", query.isOutputIndented());
        this.addParameter(sb, "country", query.getCountryCode());
        this.addParameter(sb, "spellchecking", query.isSpellcheckingEnabled());
        return sb.toString();
    }

    private void addParameter(StringBuffer sb, String httpParameterName, Object parameterValue) {
        if (parameterValue != null) {
            sb.append(httpParameterName).append("=").append(parameterValue.toString()).append("&");
        }
    }
}

