/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser.exception;

import com.gisgraphy.serializer.common.IoutputFormatVisitor;
import com.gisgraphy.serializer.common.OutputFormat;

public class AddressParserErrorVisitor
implements IoutputFormatVisitor {
    private String errorMessage = "Internal Error";

    public AddressParserErrorVisitor() {
    }

    public AddressParserErrorVisitor(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String visitXML(OutputFormat format) {
        return String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><results xmlns=\"http://gisgraphy.com\"><error>%s</error><numFound>0</numFound></results>", this.errorMessage);
    }

    public String visitJSON(OutputFormat format) {
        return String.format("{\"numFound\":0,\"error\":\"%s\",\"result\":[]}", this.errorMessage);
    }

    public String visitPYTHON(OutputFormat format) {
        return this.visitXML(format);
    }

    public String visitRUBY(OutputFormat format) {
        return this.visitXML(format);
    }

    public String visitPHP(OutputFormat format) {
        return this.visitXML(format);
    }

    public String visitATOM(OutputFormat outputFormat) {
        return this.visitXML(outputFormat);
    }

    public String visitGEORSS(OutputFormat outputFormat) {
        return this.visitXML(outputFormat);
    }

    public String visitUNSUPPORTED(OutputFormat format) {
        return "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String visitYAML(OutputFormat format) {
        return this.errorMessage;
    }
}

