/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import javax.units.Unit;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        return CRS.equalsIgnoreMetadata(object1, object2);
    }

    public static int dimensionColinearWith(CoordinateSystem cs, CoordinateSystemAxis axis) {
        int candidate = -1;
        int dimension = cs.getDimension();
        AxisDirection direction = axis.getDirection().absolute();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis xi = cs.getAxis(i);
            if (!direction.equals(xi.getDirection().absolute())) continue;
            candidate = i;
            if (axis.equals(xi)) break;
        }
        return candidate;
    }

    public static Unit getUnit(CoordinateSystem cs) {
        Unit unit = null;
        int i = cs.getDimension();
        while (--i >= 0) {
            Unit candidate = cs.getAxis(i).getUnit();
            if (candidate == null) continue;
            if (unit == null) {
                unit = candidate;
                continue;
            }
            if (unit.equals((Object)candidate)) continue;
            return null;
        }
        return unit;
    }

    public static int getDimensionOf(CoordinateReferenceSystem crs, Class type) throws IllegalArgumentException {
        if (!CoordinateReferenceSystem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName());
        }
        if (type.isAssignableFrom(crs.getClass())) {
            return 0;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            int offset = 0;
            for (CoordinateReferenceSystem ci : c) {
                int index = CRSUtilities.getDimensionOf(ci, type);
                if (index >= 0) {
                    return index + offset;
                }
                offset += ci.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem crs, int lower, int upper) {
        int dimension = crs.getCoordinateSystem().getDimension();
        if (lower < 0 || lower > upper || upper > dimension) {
            throw new IndexOutOfBoundsException(Errors.format(56, new Integer(lower < 0 ? lower : upper)));
        }
        while (lower != 0 || upper != dimension) {
            if (!(crs instanceof CompoundCRS)) {
                return null;
            }
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            if (c == null || c.isEmpty()) {
                return null;
            }
            Iterator it = c.iterator();
            while (it.hasNext() && lower >= (dimension = (crs = (CoordinateReferenceSystem)it.next()).getCoordinateSystem().getDimension())) {
                lower -= dimension;
                upper -= dimension;
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem crs) throws TransformException {
        if (crs != null) {
            while (crs.getCoordinateSystem().getDimension() != 2) {
                if (!(crs instanceof CompoundCRS)) {
                    throw new TransformException(Errors.format(24, crs.getName().toString()));
                }
                List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
                if (c == null || c.isEmpty()) {
                    return null;
                }
                crs = (CoordinateReferenceSystem)c.get(0);
            }
        }
        return crs;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem crs) {
        return CRS.getHorizontalCRS(crs);
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        return CRS.getProjectedCRS(crs);
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        return CRS.getVerticalCRS(crs);
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        return CRS.getTemporalCRS(crs);
    }

    public static Datum getDatum(CoordinateReferenceSystem crs) {
        return crs instanceof SingleCRS ? ((SingleCRS)crs).getDatum() : null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        return CRS.getEllipsoid(crs);
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeographicCRS)) {
            List c;
            if (crs instanceof CompoundCRS && (c = ((CompoundCRS)crs).getCoordinateReferenceSystems()) != null && !c.isEmpty()) {
                crs = (CoordinateReferenceSystem)c.get(0);
                continue;
            }
            return null;
        }
        return ((GeodeticDatum)((GeographicCRS)crs).getDatum()).getEllipsoid();
    }

    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        return CRS.transform(transform, envelope);
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D source, Rectangle2D dest) throws TransformException {
        return CRS.transform(transform, source, dest);
    }

    public static DirectPosition deltaTransform(MathTransform transform, DirectPosition origin, DirectPosition source) throws TransformException {
        int i;
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        GeneralDirectPosition P1 = new GeneralDirectPosition(sourceDim);
        GeneralDirectPosition P2 = new GeneralDirectPosition(sourceDim);
        for (i = 0; i < sourceDim; ++i) {
            double c = origin.getOrdinate(i);
            double d = source.getOrdinate(i) * 0.5;
            P1.setOrdinate(i, c - d);
            P2.setOrdinate(i, c + d);
        }
        P1 = transform.transform((DirectPosition)P1, (DirectPosition)(sourceDim == targetDim ? P1 : null));
        P2 = transform.transform((DirectPosition)P2, (DirectPosition)(sourceDim == targetDim ? P2 : null));
        for (i = 0; i < targetDim; ++i) {
            P2.setOrdinate(i, P2.getOrdinate(i) - P1.getOrdinate(i));
        }
        return P2;
    }

    public static Point2D deltaTransform(MathTransform2D transform, Point2D origin, Point2D source, Point2D dest) throws TransformException {
        if (transform instanceof AffineTransform) {
            return ((AffineTransform)transform).deltaTransform(source, dest);
        }
        double ox = origin.getX();
        double oy = origin.getY();
        double dx = source.getX() * 0.5;
        double dy = source.getY() * 0.5;
        Point2D P1 = new Point2D.Double(ox - dx, oy - dy);
        Point2D P2 = new Point2D.Double(ox + dx, oy + dy);
        P1 = transform.transform(P1, P1);
        P2 = transform.transform(P2, P2);
        if (dest == null) {
            dest = P2;
        }
        dest.setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
        return dest;
    }

    public static String toWGS84String(CoordinateReferenceSystem crs, Rectangle2D bounds) {
        Throwable exception;
        StringBuffer buffer = new StringBuffer();
        try {
            crs = CRSUtilities.getCRS2D(crs);
            if (!CRS.equalsIgnoreMetadata(DefaultGeographicCRS.WGS84, crs)) {
                CoordinateOperation op = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                bounds = CRS.transform(op, bounds, null);
            }
            AngleFormat fmt = new AngleFormat("DD\u00b0MM.m'");
            buffer = fmt.format(new Latitude(bounds.getMinY()), buffer, null);
            buffer.append('-');
            buffer = fmt.format(new Latitude(bounds.getMaxY()), buffer, null);
            buffer.append(' ');
            buffer = fmt.format(new Longitude(bounds.getMinX()), buffer, null);
            buffer.append('-');
            buffer = fmt.format(new Longitude(bounds.getMaxX()), buffer, null);
            return buffer.toString();
        }
        catch (TransformException e) {
            exception = e;
        }
        catch (FactoryException e) {
            exception = e;
        }
        buffer.append(Utilities.getShortClassName(exception));
        String message = exception.getLocalizedMessage();
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        return buffer.toString();
    }
}

