/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.referencing.operation.projection.ObliqueOrthographic;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class EquatorialOrthographic
extends ObliqueOrthographic {
    private static final double EPSILON = 1.0E-6;

    protected EquatorialOrthographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        EquatorialOrthographic.ensureLatitudeEquals(Orthographic.Provider.LATITUDE_OF_ORIGIN, this.latitudeOfOrigin, 0.0);
        this.latitudeOfOrigin = 0.0;
        this.ensureSpherical();
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double coslam;
        assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
        double cosphi = Math.cos(y);
        if (cosphi * (coslam = Math.cos(x)) < -1.0E-6) {
            throw new ProjectionException(Errors.format(117));
        }
        y = Math.sin(y);
        x = cosphi * Math.sin(x);
        assert (EquatorialOrthographic.checkTransform(x, y, ptDst));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
        double rho = Math.sqrt(x * x + y * y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-6) {
                throw new ProjectionException(Errors.format(117));
            }
            sinc = 1.0;
        }
        double cosc = Math.sqrt(1.0 - sinc * sinc);
        if (rho <= 1.0E-6) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi = y * sinc / rho;
            x *= sinc;
            y = cosc * rho;
            phi = Math.abs(phi) >= 1.0 ? (phi < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(phi);
            x = y == 0.0 ? (x == 0.0 ? 0.0 : (x < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(x, y);
            y = phi;
        }
        assert (EquatorialOrthographic.checkInverseTransform(x, y, ptDst));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }
}

