/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class GridToEnvelopeMapper {
    public static final int SWAP_XY = 1;
    public static final int REVERSE_AXIS = 2;
    private int defined;
    private GridRange gridRange;
    private Envelope envelope;
    private PixelInCell gridType = PixelInCell.CELL_CENTER;
    private Boolean swapXY;
    private boolean[] reverseAxis;
    private MathTransform transform;

    public GridToEnvelopeMapper() {
    }

    public GridToEnvelopeMapper(GridRange gridRange, Envelope userRange) throws MismatchedDimensionException {
        GridToEnvelopeMapper.ensureNonNull("gridRange", gridRange);
        GridToEnvelopeMapper.ensureNonNull("userRange", userRange);
        int gridDim = gridRange.getDimension();
        int userDim = userRange.getDimension();
        if (userDim != gridDim) {
            throw new MismatchedDimensionException(Errors.format(68, new Integer(gridDim), new Integer(userDim)));
        }
        this.gridRange = gridRange;
        this.envelope = userRange;
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(105, name));
        }
    }

    private static void ensureDimensionMatch(GridRange gridRange, Envelope envelope, boolean checkingRange) {
        if (gridRange != null && envelope != null) {
            int dim2;
            int dim1;
            String label;
            if (checkingRange) {
                label = "gridRange";
                dim1 = gridRange.getDimension();
                dim2 = envelope.getDimension();
            } else {
                label = "envelope";
                dim1 = envelope.getDimension();
                dim2 = gridRange.getDimension();
            }
            if (dim1 != dim2) {
                throw new MismatchedDimensionException(Errors.format(69, label, new Integer(dim1), new Integer(dim2)));
            }
        }
    }

    private void reset() {
        this.transform = null;
        if (this.isAutomatic(2)) {
            this.reverseAxis = null;
        }
        if (this.isAutomatic(1)) {
            this.swapXY = null;
        }
    }

    public PixelInCell getGridType() {
        return this.gridType;
    }

    public void setGridType(PixelInCell gridType) {
        GridToEnvelopeMapper.ensureNonNull("gridType", gridType);
        if (!Utilities.equals(this.gridType, gridType)) {
            this.gridType = gridType;
            this.reset();
        }
    }

    public GridRange getGridRange() throws IllegalStateException {
        if (this.gridRange == null) {
            throw new IllegalStateException(Errors.format(72, "gridRange"));
        }
        return this.gridRange;
    }

    public void setGridRange(GridRange gridRange) {
        GridToEnvelopeMapper.ensureNonNull("gridRange", gridRange);
        GridToEnvelopeMapper.ensureDimensionMatch(gridRange, this.envelope, true);
        if (!Utilities.equals(this.gridRange, gridRange)) {
            this.gridRange = gridRange;
            this.reset();
        }
    }

    public Envelope getEnvelope() throws IllegalStateException {
        if (this.envelope == null) {
            throw new IllegalStateException(Errors.format(72, "envelope"));
        }
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        GridToEnvelopeMapper.ensureNonNull("envelope", envelope);
        GridToEnvelopeMapper.ensureDimensionMatch(this.gridRange, envelope, false);
        if (!Utilities.equals(this.envelope, envelope)) {
            this.envelope = envelope;
            this.reset();
        }
    }

    public static boolean swapXY(CoordinateSystem cs) {
        if (cs != null && cs.getDimension() >= 2) {
            return AxisDirection.NORTH.equals(cs.getAxis(0).getDirection().absolute()) && AxisDirection.EAST.equals(cs.getAxis(1).getDirection().absolute());
        }
        return false;
    }

    public boolean getSwapXY() {
        if (this.swapXY == null) {
            boolean value = false;
            if (this.isAutomatic(1)) {
                value = GridToEnvelopeMapper.swapXY(this.getCoordinateSystem());
            }
            this.swapXY = value;
        }
        return this.swapXY;
    }

    public void setSwapXY(boolean swapXY) {
        Boolean newValue = swapXY;
        if (!newValue.equals(this.swapXY)) {
            this.reset();
        }
        this.swapXY = newValue;
        this.defined |= 1;
    }

    public boolean[] getReverseAxis() {
        CoordinateSystem cs;
        if (this.reverseAxis == null && (cs = this.getCoordinateSystem()) != null) {
            int dimension = cs.getDimension();
            this.reverseAxis = new boolean[dimension];
            if (this.isAutomatic(2)) {
                int i;
                for (i = 0; i < dimension; ++i) {
                    AxisDirection direction = cs.getAxis(i).getDirection();
                    AxisDirection absolute = direction.absolute();
                    this.reverseAxis[i] = direction.equals(absolute.opposite());
                }
                if (dimension >= 2) {
                    i = this.getSwapXY() ? 0 : 1;
                    this.reverseAxis[i] = !this.reverseAxis[i];
                }
            }
        }
        return this.reverseAxis;
    }

    public void setReverseAxis(boolean[] reverse) {
        if (!Arrays.equals(this.reverseAxis, reverse)) {
            this.reset();
        }
        this.reverseAxis = reverse;
        this.defined |= 2;
    }

    public void reverseAxis(int dimension) {
        if (this.reverseAxis == null) {
            int length;
            if (this.gridRange != null) {
                length = this.gridRange.getDimension();
            } else {
                GridToEnvelopeMapper.ensureNonNull("envelope", this.envelope);
                length = this.envelope.getDimension();
            }
            this.reverseAxis = new boolean[length];
        }
        if (!this.reverseAxis[dimension]) {
            this.reset();
        }
        this.reverseAxis[dimension] = true;
        this.defined |= 2;
    }

    public boolean isAutomatic(int mask) {
        return (this.defined & mask) == 0;
    }

    public void setAutomatic(int mask) {
        this.defined &= ~mask;
    }

    private CoordinateSystem getCoordinateSystem() {
        CoordinateReferenceSystem crs;
        if (this.envelope != null && (crs = this.envelope.getCoordinateReferenceSystem()) != null) {
            return crs.getCoordinateSystem();
        }
        return null;
    }

    public MathTransform createTransform() throws IllegalStateException {
        if (this.transform == null) {
            double translate;
            GridRange gridRange = this.getGridRange();
            Envelope userRange = this.getEnvelope();
            boolean swapXY = this.getSwapXY();
            boolean[] reverse = this.getReverseAxis();
            PixelInCell gridType = this.getGridType();
            int dimension = gridRange.getDimension();
            if (PixelInCell.CELL_CENTER.equals(gridType)) {
                translate = 0.5;
            } else if (PixelInCell.CELL_CORNER.equals(gridType)) {
                translate = 0.0;
            } else {
                throw new IllegalStateException(Errors.format(42, "gridType", gridType));
            }
            XMatrix matrix = MatrixFactory.create(dimension + 1);
            for (int i = 0; i < dimension; ++i) {
                double offset;
                int j = i;
                if (swapXY && j <= 1) {
                    j = 1 - j;
                }
                double scale = userRange.getLength(j) / (double)gridRange.getLength(i);
                if (reverse == null || j >= reverse.length || !reverse[j]) {
                    offset = userRange.getMinimum(j);
                } else {
                    scale = -scale;
                    offset = userRange.getMaximum(j);
                }
                matrix.setElement(j, j, 0.0);
                matrix.setElement(j, i, scale);
                matrix.setElement(j, dimension, offset -= scale * ((double)gridRange.getLower(i) - translate));
            }
            this.transform = ProjectiveTransform.create(matrix);
        }
        return this.transform;
    }

    public AffineTransform createAffineTransform() throws IllegalStateException {
        MathTransform transform = this.createTransform();
        if (transform instanceof AffineTransform) {
            return (AffineTransform)transform;
        }
        throw new IllegalStateException(Errors.format(85));
    }
}

