/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.referencing.operation.DefaultConicProjection;
import org.geotools.referencing.operation.DefaultCylindricalProjection;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultPlanarProjection;
import org.geotools.referencing.operation.DefaultProjection;
import org.geotools.referencing.operation.MathTransformProvider;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;

public class DefaultConversion
extends DefaultOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(definition, sourceCRS, targetCRS, transform);
    }

    public DefaultConversion(Map properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) {
        super(properties, sourceCRS, targetCRS, transform, method);
    }

    public static Conversion create(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        return DefaultConversion.create(definition, sourceCRS, targetCRS, transform, null);
    }

    public static Conversion create(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, Class typeHint) {
        Class candidate;
        Class type = DefaultConversion.getType((CoordinateOperation)definition);
        OperationMethod method = definition.getMethod();
        if (method instanceof MathTransformProvider && (candidate = ((MathTransformProvider)method).getOperationType()) != null && type.isAssignableFrom(candidate)) {
            type = candidate;
        }
        if (typeHint != null && type.isAssignableFrom(typeHint)) {
            type = typeHint;
        }
        if (ConicProjection.class.isAssignableFrom(type)) {
            return new DefaultConicProjection(definition, sourceCRS, targetCRS, transform);
        }
        if (CylindricalProjection.class.isAssignableFrom(type)) {
            return new DefaultCylindricalProjection(definition, sourceCRS, targetCRS, transform);
        }
        if (PlanarProjection.class.isAssignableFrom(type)) {
            return new DefaultPlanarProjection(definition, sourceCRS, targetCRS, transform);
        }
        if (Projection.class.isAssignableFrom(type)) {
            return new DefaultProjection(definition, sourceCRS, targetCRS, transform);
        }
        return new DefaultConversion(definition, sourceCRS, targetCRS, transform);
    }
}

