/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.spi.ServiceRegistry;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.epsg.DataSource;
import org.geotools.referencing.factory.epsg.DirectEpsgFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class ThreadedEpsgFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String DATASOURCE_NAME = "jdbc/EPSG";
    private static final boolean ALLOW_REGISTRATION = false;
    private static FactoryRegistry datasources;
    static final int PRIORITY = 90;
    private final FactoryGroup factories;
    private transient InitialContext registerInto;
    private String datasourceName;
    private javax.sql.DataSource datasource;
    private Thread shutdown;

    public ThreadedEpsgFactory() {
        this((Hints)null);
    }

    public ThreadedEpsgFactory(Hints userHints) {
        this(userHints, 90);
    }

    public ThreadedEpsgFactory(Hints userHints, int priority) {
        super(userHints, priority);
        Object hint;
        Object object = hint = userHints == null ? null : userHints.get(Hints.EPSG_DATA_SOURCE);
        if (hint == null) {
            this.datasourceName = DATASOURCE_NAME;
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.datasourceName);
        } else if (hint instanceof String) {
            this.datasourceName = (String)hint;
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.datasourceName);
        } else if (hint instanceof Attributes.Name) {
            Attributes.Name name = (Attributes.Name)hint;
            this.hints.put(Hints.EPSG_DATA_SOURCE, name);
            this.datasourceName = name.toString();
        } else if (hint instanceof javax.sql.DataSource) {
            this.datasource = (javax.sql.DataSource)hint;
            this.hints.put(Hints.EPSG_DATA_SOURCE, this.datasource);
            this.datasourceName = DATASOURCE_NAME;
        }
        this.factories = FactoryGroup.createInstance(userHints);
        this.setTimeout(1800000L);
    }

    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : Citations.EPSG;
    }

    public final synchronized javax.sql.DataSource getDataSource() throws SQLException {
        if (this.datasource == null && !super.isAvailable()) {
            this.datasource = null;
            throw new SQLException(Errors.format(156));
        }
        return this.datasource;
    }

    public synchronized void setDataSource(javax.sql.DataSource datasource) throws SQLException {
        if (datasource != this.datasource) {
            try {
                this.dispose();
            }
            catch (FactoryException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                SQLException e = new SQLException(exception.getLocalizedMessage());
                e.initCause(exception);
                throw e;
            }
            this.datasource = datasource;
        }
    }

    private static synchronized Iterator getDataSources() {
        Class<DataSource> category = DataSource.class;
        if (datasources == null) {
            datasources = new FactoryRegistry(Collections.singleton(category));
            datasources.scanForPlugins();
            datasources.setOrdering(category, new Comparator(){

                public int compare(Object f1, Object f2) {
                    return ((DataSource)f1).getPriority() - ((DataSource)f2).getPriority();
                }
            });
        }
        return datasources.getServiceProviders(category, true);
    }

    protected javax.sql.DataSource createDataSource() throws SQLException {
        InitialContext context = null;
        javax.sql.DataSource source = null;
        try {
            context = GeoTools.getInitialContext(new Hints(this.hints));
            source = (javax.sql.DataSource)context.lookup(this.datasourceName);
        }
        catch (NoInitialContextException exception) {
        }
        catch (NameNotFoundException exception) {
            this.registerInto = context;
        }
        catch (NamingException exception) {
            SQLException e = new SQLException(Errors.format(155, this.datasourceName));
            e.initCause(exception);
            throw e;
        }
        return source;
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        javax.sql.DataSource source = this.getDataSource();
        if (source instanceof DataSource) {
            return ((DataSource)source).createFactory(hints);
        }
        Connection connection = source.getConnection();
        String quote = connection.getMetaData().getIdentifierQuoteString();
        if (quote.equals("\"")) {
            return new FactoryUsingAnsiSQL(hints, connection);
        }
        return new FactoryUsingSQL(hints, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAuthorityFactory createBackingStore0() throws FactoryException, SQLException {
        javax.sql.DataSource source;
        assert (Thread.holdsLock(this));
        Hints sourceHints = new Hints(this.hints);
        sourceHints.putAll((Map<?, ?>)this.factories.getImplementationHints());
        if (this.datasource != null) {
            return this.createBackingStore(sourceHints);
        }
        try {
            source = this.createDataSource();
            InitialContext context = this.registerInto;
        }
        finally {
            this.registerInto = null;
        }
        Iterator sources = null;
        AbstractAuthorityFactory factory = null;
        SQLException failure = null;
        while (true) {
            block16: {
                if (source != null) {
                    try {
                        try {
                            this.datasource = source;
                            factory = this.createBackingStore(sourceHints);
                            break;
                        }
                        finally {
                            this.datasource = null;
                        }
                    }
                    catch (SQLException exception) {
                        if (failure != null) break block16;
                        failure = exception;
                    }
                }
            }
            if (sources == null) {
                sources = ThreadedEpsgFactory.getDataSources();
            }
            if (!sources.hasNext()) {
                if (failure != null) {
                    throw failure;
                }
                throw new FactoryNotFoundException(Errors.format(156));
            }
            source = (javax.sql.DataSource)sources.next();
        }
        this.datasource = source;
        return factory;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        String product;
        String url = product = '<' + Vocabulary.format(176) + '>';
        try {
            factory = this.createBackingStore0();
            if (factory instanceof DirectEpsgFactory) {
                DatabaseMetaData info = ((DirectEpsgFactory)factory).connection.getMetaData();
                product = info.getDatabaseProductName();
                url = info.getURL();
            }
        }
        catch (SQLException exception) {
            throw new FactoryException(Errors.format(154, "EPSG"), (Throwable)exception);
        }
        ThreadedEpsgFactory.log(Logging.format(Level.CONFIG, 37, url, product));
        if (factory instanceof DirectEpsgFactory) {
            ((DirectEpsgFactory)factory).buffered = this;
        }
        return factory;
    }

    private static void log(LogRecord record) {
        record.setSourceClassName(ThreadedEpsgFactory.class.getName());
        record.setSourceMethodName("createBackingStore");
        LOGGER.log(record);
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory backingStore) {
        if (backingStore instanceof DirectEpsgFactory) {
            return ((DirectEpsgFactory)backingStore).canDispose();
        }
        return super.canDisposeBackingStore(backingStore);
    }

    public synchronized void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.shutdown == null) {
            this.shutdown = new ShutdownHook();
            Runtime.getRuntime().addShutdownHook(this.shutdown);
        }
    }

    public synchronized void onDeregistration(ServiceRegistry registry, Class category) {
        if (this.shutdown != null && registry.getServiceProviderByClass(this.getClass()) == null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdown);
            this.shutdown = null;
        }
        super.onDeregistration(registry, category);
    }

    public static void main(String[] args) {
        args = (String[])XArray.insert(args, 0, 1);
        args[0] = "-authority=EPSG";
        CRS.main(args);
    }

    private final class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("EPSG factory shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadedEpsgFactory threadedEpsgFactory = ThreadedEpsgFactory.this;
            synchronized (threadedEpsgFactory) {
                try {
                    ThreadedEpsgFactory.this.dispose();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

