/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.epsg.AbstractEpsgFactory;
import org.opengis.referencing.FactoryException;

public class AnsiDialectEpsgFactory
extends AbstractEpsgFactory {
    private static final String[] ANSI = new String[]{"[Alias]", "epsg_alias", "[Area]", "epsg_area", "[Coordinate Axis]", "epsg_coordinateaxis", "[Coordinate Axis Name]", "epsg_coordinateaxisname", "[Coordinate_Operation]", "epsg_coordoperation", "[Coordinate_Operation Method]", "epsg_coordoperationmethod", "[Coordinate_Operation Parameter]", "epsg_coordoperationparam", "[Coordinate_Operation Parameter Usage]", "epsg_coordoperationparamusage", "[Coordinate_Operation Parameter Value]", "epsg_coordoperationparamvalue", "[Coordinate_Operation Path]", "epsg_coordoperationpath", "[Coordinate Reference System]", "epsg_coordinatereferencesystem", "[Coordinate System]", "epsg_coordinatesystem", "[Datum]", "epsg_datum", "[Ellipsoid]", "epsg_ellipsoid", "[Naming System]", "epsg_namingsystem", "[Prime Meridian]", "epsg_primemeridian", "[Supersession]", "epsg_supersession", "[Unit of Measure]", "epsg_unitofmeasure", "[Version History]", "epsg_versionhistory", "[ORDER]", "coord_axis_order"};
    protected final Map map = new LinkedHashMap();
    private String prefix = "epsg_";

    public AnsiDialectEpsgFactory(Hints userHints) throws FactoryException {
        super(userHints);
        for (int i = 0; i < ANSI.length; ++i) {
            this.map.put(ANSI[i], ANSI[++i]);
        }
    }

    public AnsiDialectEpsgFactory(Hints hints, Connection connection) {
        super(hints, connection);
        for (int i = 0; i < ANSI.length; ++i) {
            this.map.put(ANSI[i], ANSI[++i]);
        }
    }

    public AnsiDialectEpsgFactory(Hints hints, DataSource dataSource) {
        super(hints, dataSource);
        for (int i = 0; i < ANSI.length; ++i) {
            this.map.put(ANSI[i], ANSI[++i]);
        }
    }

    protected void setSchema(String schema) {
        int length = (schema = schema.trim()).length();
        if (length == 0) {
            throw new IllegalArgumentException(schema);
        }
        char separator = schema.charAt(length - 1);
        if (separator != '.' && separator != '_') {
            schema = schema + '.';
        } else if (length == 1) {
            throw new IllegalArgumentException(schema);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String tableName = (String)entry.getValue();
            if (!tableName.startsWith(this.prefix)) continue;
            entry.setValue(schema + tableName.substring(this.prefix.length()));
        }
        this.prefix = schema;
    }

    protected String adaptSQL(String statement) {
        StringBuffer modified = new StringBuffer(statement);
        for (Map.Entry entry : this.map.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = (String)entry.getValue();
            int start = 0;
            while ((start = modified.indexOf(oldName, start)) >= 0) {
                modified.replace(start, start + oldName.length(), newName);
                start += newName.length();
            }
        }
        return modified.toString();
    }
}

