/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.referencing.factory.URN_Parser;
import org.geotools.util.Version;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class URN_AuthorityFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private final AllAuthoritiesFactory factory;
    private final SortedMap byVersions = new TreeMap();
    private transient URN_Parser last;

    public URN_AuthorityFactory() {
        this(new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE));
    }

    public URN_AuthorityFactory(Hints userHints) {
        this(new AllAuthoritiesFactory(userHints));
    }

    public URN_AuthorityFactory(AllAuthoritiesFactory factory) {
        super(factory);
        this.factory = factory;
    }

    public Citation getAuthority() {
        return Citations.URN_OGC;
    }

    private URN_Parser getParser(String code) throws NoSuchAuthorityCodeException {
        URN_Parser parser = this.last;
        if (parser == null || !parser.urn.equals(code)) {
            this.last = parser = new URN_Parser(code);
        }
        return parser;
    }

    protected AuthorityFactory getAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            return this.getAuthorityFactory(this.getParser((String)code).type.type, code);
        }
        return super.getAuthorityFactory(code);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URN_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(DatumAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof DatumAuthorityFactory) {
                return (DatumAuthorityFactory)factory;
            }
        }
        return super.getDatumAuthorityFactory(code);
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URN_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(CSAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof CSAuthorityFactory) {
                return (CSAuthorityFactory)factory;
            }
        }
        return super.getCSAuthorityFactory(code);
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URN_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(CRSAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof CRSAuthorityFactory) {
                return (CRSAuthorityFactory)factory;
            }
        }
        return super.getCRSAuthorityFactory(code);
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URN_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(CoordinateOperationAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof CoordinateOperationAuthorityFactory) {
                return (CoordinateOperationAuthorityFactory)factory;
            }
        }
        return super.getCoordinateOperationAuthorityFactory(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorityFactory getVersionedFactory(URN_Parser parser) throws FactoryException {
        AuthorityFactory factory;
        Version version = parser.version;
        if (version == null) {
            return null;
        }
        SortedMap sortedMap = this.byVersions;
        synchronized (sortedMap) {
            factory = (AuthorityFactory)this.byVersions.get(version);
            if (factory == null && (factory = this.createVersionedFactory(version)) != null) {
                this.byVersions.put(version, factory);
            }
        }
        return factory;
    }

    protected AuthorityFactory createVersionedFactory(Version version) throws FactoryException {
        Hints hints = this.factory.getUserHints();
        hints.put(Hints.VERSION, version);
        List<AuthorityFactory> factories = Arrays.asList(new AllAuthoritiesFactory(hints), this.factory);
        return FallbackAuthorityFactory.create(factories);
    }

    protected String toBackingFactoryCode(String code) throws FactoryException {
        return this.getParser(code).getAuthorityCode();
    }
}

