/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class AllAuthoritiesFactory
extends ManyAuthoritiesFactory {
    public static AllAuthoritiesFactory DEFAULT = new AllAuthoritiesFactory(null);
    private final Hints userHints;

    public AllAuthoritiesFactory(Hints userHints) {
        this(userHints, null);
    }

    public AllAuthoritiesFactory(Hints userHints, Collection factories) {
        this(userHints, factories, '\u0000');
    }

    public AllAuthoritiesFactory(Hints userHints, Collection factories, char separator) {
        super(userHints, factories, separator);
        this.userHints = new Hints((Map)userHints);
    }

    public Set getAuthorityNames() {
        Set names = super.getAuthorityNames();
        names.addAll(ReferencingFactoryFinder.getAuthorityNames());
        return names;
    }

    final AuthorityFactory fromFactoryRegistry(String authority, Class type) throws FactoryRegistryException {
        if (CRSAuthorityFactory.class.equals((Object)type)) {
            return ReferencingFactoryFinder.getCRSAuthorityFactory(authority, this.userHints);
        }
        if (CSAuthorityFactory.class.equals((Object)type)) {
            return ReferencingFactoryFinder.getCSAuthorityFactory(authority, this.userHints);
        }
        if (DatumAuthorityFactory.class.equals((Object)type)) {
            return ReferencingFactoryFinder.getDatumAuthorityFactory(authority, this.userHints);
        }
        if (CoordinateOperationAuthorityFactory.class.equals((Object)type)) {
            return ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(authority, this.userHints);
        }
        return super.fromFactoryRegistry(authority, type);
    }

    final Hints getUserHints() {
        return new Hints((Map)this.userHints);
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(this, type);
    }

    private static final class Finder
    extends ManyAuthoritiesFactory.Finder {
        protected Finder(ManyAuthoritiesFactory factory, Class type) {
            super(factory, type);
        }

        private Set fromFactoryRegistry() {
            ManyAuthoritiesFactory factory = (ManyAuthoritiesFactory)this.getProxy().getAuthorityFactory();
            Class type = this.getProxy().getType();
            LinkedHashSet factories = new LinkedHashSet();
            for (String authority : ReferencingFactoryFinder.getAuthorityNames()) {
                factory.fromFactoryRegistry(authority, type, factories);
            }
            Collection done = this.getFactories();
            if (done != null) {
                factories.removeAll(done);
            }
            return factories;
        }

        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder finder;
            IdentifiedObject candidate = super.find(object);
            if (candidate != null) {
                return candidate;
            }
            Iterator it = this.fromFactoryRegistry().iterator();
            while ((finder = this.next(it)) != null && (candidate = finder.find(object)) == null) {
            }
            return candidate;
        }

        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder finder;
            String candidate = super.findIdentifier(object);
            if (candidate != null) {
                return candidate;
            }
            Iterator it = this.fromFactoryRegistry().iterator();
            while ((finder = this.next(it)) != null && (candidate = finder.findIdentifier(object)) == null) {
            }
            return candidate;
        }
    }
}

