/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.bzip2.CBZip2InputStream;
import org.apache.commons.compress.bzip2.CBZip2OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.compressed.CompressedFileFileObject;
import org.apache.commons.vfs.provider.compressed.CompressedFileFileSystem;

public class Bzip2FileObject
extends CompressedFileFileObject {
    protected Bzip2FileObject(FileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, container, fs);
    }

    protected InputStream doGetInputStream() throws Exception {
        InputStream is = this.getContainer().getContent().getInputStream();
        return Bzip2FileObject.wrapInputStream(this.getName().getURI(), is);
    }

    public static InputStream wrapInputStream(String name, InputStream is) throws IOException {
        int b1 = is.read();
        int b2 = is.read();
        if (b1 != 66 || b2 != 90) {
            throw new FileSystemException("vfs.provider.compressedFile/not-a-compressedFile-file.error", name);
        }
        return new CBZip2InputStream(is);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        OutputStream os = this.getContainer().getContent().getOutputStream(false);
        os.write(66);
        os.write(90);
        return new CBZip2OutputStream(os);
    }
}

