/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetCESU8;
import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF8
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{-17, -65, -67};
    private static final int[] BITMASK_FROM_UTF8 = new int[]{-1, 127, 31, 15, 7, 3, 1};
    private static final byte[] BYTES_FROM_UTF8 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
    private static final int[] UTF8_MIN_CHAR32 = new int[]{0, 0, 128, 2048, 65536, Integer.MAX_VALUE, Integer.MAX_VALUE};
    private final boolean isCESU8 = this instanceof CharsetCESU8;

    public CharsetUTF8(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    private static final byte encodeHeadOf1(int char32) {
        return (byte)char32;
    }

    private static final byte encodeHeadOf2(int char32) {
        return (byte)(0xC0 | char32 >>> 6);
    }

    private static final byte encodeHeadOf3(int char32) {
        return (byte)(0xE0 | char32 >>> 12);
    }

    private static final byte encodeHeadOf4(int char32) {
        return (byte)(0xF0 | char32 >>> 18);
    }

    private static final byte encodeThirdToLastTail(int char32) {
        return (byte)(0x80 | char32 >>> 12 & 0x3F);
    }

    private static final byte encodeSecondToLastTail(int char32) {
        return (byte)(0x80 | char32 >>> 6 & 0x3F);
    }

    private static final byte encodeLastTail(int char32) {
        return (byte)(0x80 | char32 & 0x3F);
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF8(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF8(this);
    }

    class CharsetEncoderUTF8
    extends CharsetEncoderICU {
        private int sourceIndex;
        private int targetIndex;

        public CharsetEncoderUTF8(CharsetICU cs) {
            super(cs, fromUSubstitution);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            int char32;
            if (!source.hasRemaining()) {
                this.fromUChar32 = 0;
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (source.hasArray() && target.hasArray()) {
                CoderResult cr2;
                int char322;
                char[] sourceArray = source.array();
                int sourceIndex = source.arrayOffset() + source.position();
                int sourceLimit = source.arrayOffset() + source.limit();
                byte[] targetArray = target.array();
                int targetIndex = target.arrayOffset() + target.position();
                int targetLimit = target.arrayOffset() + target.limit();
                if (this.fromUChar32 != 0) {
                    char322 = this.fromUChar32;
                    this.fromUChar32 = 0;
                    this.sourceIndex = sourceIndex;
                    this.targetIndex = targetIndex;
                    cr2 = this.encodeFourBytes(sourceArray, targetArray, sourceLimit, targetLimit, char322, flush);
                    sourceIndex = this.sourceIndex;
                    targetIndex = this.targetIndex;
                    if (cr2 != null) {
                        source.position(sourceIndex - source.arrayOffset());
                        target.position(targetIndex - target.arrayOffset());
                        return cr2;
                    }
                }
                while (true) {
                    if (sourceIndex >= sourceLimit) {
                        cr2 = CoderResult.UNDERFLOW;
                        break;
                    }
                    if (targetIndex >= targetLimit) {
                        cr2 = CoderResult.OVERFLOW;
                        break;
                    }
                    if ((char322 = sourceArray[sourceIndex++] & 0xFFFF) <= 127) {
                        targetArray[targetIndex++] = CharsetUTF8.encodeHeadOf1(char322);
                        continue;
                    }
                    if (char322 <= 2047) {
                        targetArray[targetIndex++] = CharsetUTF8.encodeHeadOf2(char322);
                        if (targetIndex >= targetLimit) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char322);
                            cr2 = CoderResult.OVERFLOW;
                            break;
                        }
                        targetArray[targetIndex++] = CharsetUTF8.encodeLastTail(char322);
                        continue;
                    }
                    if (!UTF16.isSurrogate((char)((char)char322)) || CharsetUTF8.this.isCESU8) {
                        targetArray[targetIndex++] = CharsetUTF8.encodeHeadOf3(char322);
                        if (targetIndex >= targetLimit) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char322);
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char322);
                            cr2 = CoderResult.OVERFLOW;
                            break;
                        }
                        targetArray[targetIndex++] = CharsetUTF8.encodeSecondToLastTail(char322);
                        if (targetIndex >= targetLimit) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char322);
                            cr2 = CoderResult.OVERFLOW;
                            break;
                        }
                        targetArray[targetIndex++] = CharsetUTF8.encodeLastTail(char322);
                        continue;
                    }
                    this.sourceIndex = sourceIndex;
                    this.targetIndex = targetIndex;
                    cr2 = this.encodeFourBytes(sourceArray, targetArray, sourceLimit, targetLimit, char322, flush);
                    sourceIndex = this.sourceIndex;
                    targetIndex = this.targetIndex;
                    if (cr2 != null) break;
                }
                source.position(sourceIndex - source.arrayOffset());
                target.position(targetIndex - target.arrayOffset());
                return cr2;
            }
            int sourceIndex = source.position();
            int sourceLimit = source.limit();
            int targetIndex = target.position();
            int targetLimit = target.limit();
            if (this.fromUChar32 != 0) {
                char32 = this.fromUChar32;
                this.fromUChar32 = 0;
                this.sourceIndex = sourceIndex;
                this.targetIndex = targetIndex;
                cr = this.encodeFourBytes(source, target, sourceLimit, targetLimit, char32, flush);
                sourceIndex = this.sourceIndex;
                targetIndex = this.targetIndex;
                if (cr != null) {
                    source.position(sourceIndex);
                    target.position(targetIndex);
                    return cr;
                }
            }
            while (true) {
                if (sourceIndex >= sourceLimit) {
                    cr = CoderResult.UNDERFLOW;
                    break;
                }
                if (targetIndex >= targetLimit) {
                    cr = CoderResult.OVERFLOW;
                    break;
                }
                if ((char32 = source.get(sourceIndex++) & 0xFFFF) <= 127) {
                    target.put(targetIndex++, CharsetUTF8.encodeHeadOf1(char32));
                    continue;
                }
                if (char32 <= 2047) {
                    target.put(targetIndex++, CharsetUTF8.encodeHeadOf2(char32));
                    if (targetIndex >= targetLimit) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                        cr = CoderResult.OVERFLOW;
                        break;
                    }
                    target.put(targetIndex++, CharsetUTF8.encodeLastTail(char32));
                    continue;
                }
                if (!UTF16.isSurrogate((char)((char)char32)) || CharsetUTF8.this.isCESU8) {
                    target.put(targetIndex++, CharsetUTF8.encodeHeadOf3(char32));
                    if (targetIndex >= targetLimit) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                        cr = CoderResult.OVERFLOW;
                        break;
                    }
                    target.put(targetIndex++, CharsetUTF8.encodeSecondToLastTail(char32));
                    if (targetIndex >= targetLimit) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                        cr = CoderResult.OVERFLOW;
                        break;
                    }
                    target.put(targetIndex++, CharsetUTF8.encodeLastTail(char32));
                    continue;
                }
                this.sourceIndex = sourceIndex;
                this.targetIndex = targetIndex;
                cr = this.encodeFourBytes(source, target, sourceLimit, targetLimit, char32, flush);
                sourceIndex = this.sourceIndex;
                targetIndex = this.targetIndex;
                if (cr != null) break;
            }
            source.position(sourceIndex);
            target.position(targetIndex);
            return cr;
        }

        private final CoderResult encodeFourBytes(char[] sourceArray, byte[] targetArray, int sourceLimit, int targetLimit, int char32, boolean flush) {
            if (this.sourceIndex >= sourceLimit) {
                this.fromUChar32 = char32;
                return flush ? CoderResult.malformedForLength(1) : CoderResult.UNDERFLOW;
            }
            try {
                char32 = UCharacter.getCodePoint((char)((char)char32), (char)sourceArray[this.sourceIndex++]);
            }
            catch (IllegalArgumentException ex) {
                this.fromUChar32 = char32;
                --this.sourceIndex;
                return CoderResult.malformedForLength(1);
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeHeadOf4(char32);
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeThirdToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeThirdToLastTail(char32);
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeSecondToLastTail(char32);
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeLastTail(char32);
            return null;
        }

        private final CoderResult encodeFourBytes(CharBuffer source, ByteBuffer target, int sourceLimit, int targetLimit, int char32, boolean flush) {
            if (this.sourceIndex >= sourceLimit) {
                this.fromUChar32 = char32;
                return flush ? CoderResult.malformedForLength(1) : CoderResult.UNDERFLOW;
            }
            try {
                char32 = UCharacter.getCodePoint((char)((char)char32), (char)source.get(this.sourceIndex++));
            }
            catch (IllegalArgumentException ex) {
                this.fromUChar32 = char32;
                --this.sourceIndex;
                return CoderResult.malformedForLength(1);
            }
            target.put(this.targetIndex++, CharsetUTF8.encodeHeadOf4(char32));
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeThirdToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            target.put(this.targetIndex++, CharsetUTF8.encodeThirdToLastTail(char32));
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            target.put(this.targetIndex++, CharsetUTF8.encodeSecondToLastTail(char32));
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            target.put(this.targetIndex++, CharsetUTF8.encodeLastTail(char32));
            return null;
        }
    }

    class CharsetDecoderUTF8
    extends CharsetDecoderICU {
        public CharsetDecoderUTF8(CharsetICU cs) {
            super(cs);
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            int targetIndex;
            int sourceIndex;
            block29: {
                int i;
                int bytes;
                int char32;
                if (!source.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                if (source.hasArray() && target.hasArray()) {
                    CoderResult cr2;
                    int targetIndex2;
                    int sourceIndex2;
                    block27: {
                        int i2;
                        int bytes2;
                        int char322;
                        byte[] sourceArray = source.array();
                        sourceIndex2 = source.arrayOffset() + source.position();
                        int sourceLimit = source.arrayOffset() + source.limit();
                        char[] targetArray = target.array();
                        targetIndex2 = target.arrayOffset() + target.position();
                        int targetLimit = target.arrayOffset() + target.limit();
                        if (this.mode == 0) {
                            char322 = sourceArray[sourceIndex2++] & 0xFF;
                            bytes2 = BYTES_FROM_UTF8[char322];
                            char322 &= BITMASK_FROM_UTF8[bytes2];
                            i2 = 1;
                        } else {
                            char322 = this.toUnicodeStatus;
                            bytes2 = this.mode;
                            i2 = this.toULength;
                            this.toUnicodeStatus = 0;
                            this.mode = 0;
                            this.toULength = 0;
                        }
                        while (true) {
                            block28: {
                                if (i2 < bytes2) {
                                    byte ch;
                                    if (sourceIndex2 >= sourceLimit) {
                                        this.toUnicodeStatus = char322;
                                        this.mode = bytes2;
                                        this.toULength = i2;
                                        cr2 = flush ? CoderResult.malformedForLength(i2) : CoderResult.UNDERFLOW;
                                        break block27;
                                    }
                                    if (((ch = sourceArray[sourceIndex2++]) & 0xC0) != 128) {
                                        --sourceIndex2;
                                        this.toULength = i2;
                                        cr2 = CoderResult.malformedForLength(this.toULength);
                                        break block27;
                                    }
                                    char322 = char322 << 6 | ch & 0x3F;
                                    ++i2;
                                    continue;
                                }
                                if (i2 != bytes2 || UTF8_MIN_CHAR32[bytes2] > char322 || char322 > 0x10FFFF || !(CharsetUTF8.this.isCESU8 ? bytes2 <= 3 : !UTF16.isSurrogate((char)((char)char322)))) break;
                                if (char322 <= 65535) {
                                    targetArray[targetIndex2++] = (char)char322;
                                } else {
                                    targetArray[targetIndex2++] = (char)(((char322 -= 65536) >>> 10) + 55296);
                                    if (targetIndex2 >= targetLimit) {
                                        this.charErrorBufferArray[this.charErrorBufferBegin++] = (char)char322;
                                        cr2 = CoderResult.OVERFLOW;
                                        break block27;
                                    }
                                    targetArray[targetIndex2++] = (char)((char322 & 0x3FF) + 56320);
                                }
                                if (sourceIndex2 >= sourceLimit) {
                                    cr2 = CoderResult.UNDERFLOW;
                                    break block27;
                                }
                                if (targetIndex2 >= targetLimit) {
                                    cr2 = CoderResult.OVERFLOW;
                                    break block27;
                                }
                                do {
                                    char322 = sourceArray[sourceIndex2++] & 0xFF;
                                    bytes2 = BYTES_FROM_UTF8[char322];
                                    if (bytes2 != 1) break block28;
                                    targetArray[targetIndex2++] = (char)char322;
                                    if (sourceIndex2 < sourceLimit) continue;
                                    cr2 = CoderResult.UNDERFLOW;
                                    break block27;
                                } while (targetIndex2 < targetLimit);
                                cr2 = CoderResult.OVERFLOW;
                                break block27;
                            }
                            char322 &= BITMASK_FROM_UTF8[bytes2];
                            i2 = 1;
                        }
                        this.toULength = i2;
                        cr2 = CoderResult.malformedForLength(this.toULength);
                    }
                    source.position(sourceIndex2 - source.arrayOffset());
                    target.position(targetIndex2 - target.arrayOffset());
                    return cr2;
                }
                sourceIndex = source.position();
                int sourceLimit = source.limit();
                targetIndex = target.position();
                int targetLimit = target.limit();
                if (this.mode == 0) {
                    char32 = source.get(sourceIndex++) & 0xFF;
                    bytes = BYTES_FROM_UTF8[char32];
                    char32 &= BITMASK_FROM_UTF8[bytes];
                    i = 1;
                } else {
                    char32 = this.toUnicodeStatus;
                    bytes = this.mode;
                    i = this.toULength;
                    this.toUnicodeStatus = 0;
                    this.mode = 0;
                    this.toULength = 0;
                }
                while (true) {
                    block30: {
                        if (i < bytes) {
                            byte ch;
                            if (sourceIndex >= sourceLimit) {
                                this.toUnicodeStatus = char32;
                                this.mode = bytes;
                                this.toULength = i;
                                cr = flush ? CoderResult.malformedForLength(i) : CoderResult.UNDERFLOW;
                                break block29;
                            }
                            if (((ch = source.get(sourceIndex++)) & 0xC0) != 128) {
                                --sourceIndex;
                                this.toULength = i;
                                cr = CoderResult.malformedForLength(this.toULength);
                                break block29;
                            }
                            char32 = char32 << 6 | ch & 0x3F;
                            ++i;
                            continue;
                        }
                        if (i != bytes || UTF8_MIN_CHAR32[bytes] > char32 || char32 > 0x10FFFF || !(CharsetUTF8.this.isCESU8 ? bytes <= 3 : !UTF16.isSurrogate((char)((char)char32)))) break;
                        if (char32 <= 65535) {
                            target.put(targetIndex++, (char)char32);
                        } else {
                            target.put(targetIndex++, (char)(((char32 -= 65536) >>> 10) + 55296));
                            if (targetIndex >= targetLimit) {
                                this.charErrorBufferArray[this.charErrorBufferBegin++] = (char)char32;
                                cr = CoderResult.OVERFLOW;
                                break block29;
                            }
                            target.put(targetIndex++, (char)((char32 & 0x3FF) + 56320));
                        }
                        if (sourceIndex >= sourceLimit) {
                            cr = CoderResult.UNDERFLOW;
                            break block29;
                        }
                        if (targetIndex >= targetLimit) {
                            cr = CoderResult.OVERFLOW;
                            break block29;
                        }
                        do {
                            char32 = source.get(sourceIndex++) & 0xFF;
                            bytes = BYTES_FROM_UTF8[char32];
                            if (bytes != 1) break block30;
                            target.put(targetIndex++, (char)char32);
                            if (sourceIndex < sourceLimit) continue;
                            cr = CoderResult.UNDERFLOW;
                            break block29;
                        } while (targetIndex < targetLimit);
                        cr = CoderResult.OVERFLOW;
                        break block29;
                    }
                    char32 &= BITMASK_FROM_UTF8[bytes];
                    i = 1;
                }
                this.toULength = i;
                cr = CoderResult.malformedForLength(this.toULength);
            }
            source.position(sourceIndex);
            target.position(targetIndex);
            return cr;
        }
    }
}

