/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetUTF32;
import com.ibm.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF32LE
extends CharsetUTF32 {
    protected byte[] fromUSubstitution = new byte[]{-3, -1, 0, 0};

    public CharsetUTF32LE(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 4;
        this.maxCharsPerByte = 1.0f;
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF32LE((CharsetICU)this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF32LE(this);
    }

    class CharsetEncoderUTF32LE
    extends CharsetEncoderICU {
        public CharsetEncoderUTF32LE(CharsetICU cs) {
            super(cs, CharsetUTF32LE.this.fromUSubstitution);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            int indexToWrite;
            char ch2;
            CoderResult cr = CoderResult.UNDERFLOW;
            if (!source.hasRemaining()) {
                return cr;
            }
            if (this.fromUnicodeStatus == 1 && this.writeBOM) {
                byte[] bom = new byte[]{-1, -2, 0, 0};
                cr = CharsetEncoderUTF32LE.fromUWriteBytes(this, bom, 0, bom.length, target, offsets, -1);
                if (cr.isError()) {
                    return cr;
                }
                this.fromUnicodeStatus = 0;
            }
            byte[] temp = new byte[4];
            temp[3] = 0;
            int sourceArrayIndex = source.position();
            boolean doloop = true;
            if (this.fromUChar32 != 0) {
                int ch = this.fromUChar32;
                this.fromUChar32 = 0;
                if (sourceArrayIndex < source.limit()) {
                    ch2 = source.get(sourceArrayIndex);
                    if (UTF16.isTrailSurrogate((char)ch2)) {
                        ch = (ch - 55296 << 10) + ch2 + 9216;
                        ++sourceArrayIndex;
                    } else {
                        this.fromUChar32 = ch;
                        cr = CoderResult.malformedForLength(sourceArrayIndex);
                        doloop = false;
                    }
                } else {
                    this.fromUChar32 = ch;
                    if (flush) {
                        cr = CoderResult.malformedForLength(sourceArrayIndex);
                    }
                    doloop = false;
                }
                temp[2] = (byte)(ch >>> 16 & 0x1F);
                temp[1] = (byte)(ch >>> 8);
                temp[0] = (byte)ch;
                for (indexToWrite = 0; indexToWrite <= 3; ++indexToWrite) {
                    if (target.hasRemaining()) {
                        target.put(temp[indexToWrite]);
                        continue;
                    }
                    this.errorBuffer[this.errorBufferLength++] = temp[indexToWrite];
                    cr = CoderResult.OVERFLOW;
                }
            }
            if (doloop) {
                while (sourceArrayIndex < source.limit() && target.hasRemaining()) {
                    int ch;
                    block22: {
                        if (UTF16.isSurrogate((char)((char)(ch = source.get(sourceArrayIndex++))))) {
                            if (UTF16.isLeadSurrogate((char)((char)ch))) {
                                if (sourceArrayIndex < source.limit()) {
                                    ch2 = source.get(sourceArrayIndex);
                                    if (UTF16.isTrailSurrogate((char)ch2)) {
                                        ch = (ch - 55296 << 10) + ch2 + 9216;
                                        ++sourceArrayIndex;
                                        break block22;
                                    } else {
                                        this.fromUChar32 = ch;
                                        cr = CoderResult.OVERFLOW;
                                        break;
                                    }
                                }
                                this.fromUChar32 = ch;
                                if (!flush) break;
                                cr = CoderResult.malformedForLength(sourceArrayIndex);
                                break;
                            }
                            this.fromUChar32 = ch;
                            cr = CoderResult.malformedForLength(sourceArrayIndex);
                            break;
                        }
                    }
                    temp[2] = (byte)(ch >>> 16 & 0x1F);
                    temp[1] = (byte)(ch >>> 8);
                    temp[0] = (byte)ch;
                    for (indexToWrite = 0; indexToWrite <= 3; ++indexToWrite) {
                        if (target.hasRemaining()) {
                            target.put(temp[indexToWrite]);
                            continue;
                        }
                        this.errorBuffer[this.errorBufferLength++] = temp[indexToWrite];
                        cr = CoderResult.OVERFLOW;
                    }
                }
            }
            if (sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr = CoderResult.OVERFLOW;
            }
            source.position(sourceArrayIndex);
            return cr;
        }
    }

    class CharsetDecoderUTF32LE
    extends CharsetUTF32.CharsetDecoderUTF32 {
        public CharsetDecoderUTF32LE(CharsetICU cs) {
            super(cs);
            this.mode = 2;
            CharsetUTF32LE.this.bom = 2;
        }

        protected CoderResult decodeLoopImpl(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            return this.decodeLoopUTF32LE(source, target, offsets, flush);
        }

        protected int getChar(byte[] bytes, int length) {
            int ch = 0;
            for (int i = 0; i < length; ++i) {
                ch |= (bytes[i] & 0xFF) << i * 8;
            }
            return ch;
        }
    }
}

