/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.UConverterAlias;
import com.ibm.icu.impl.InvalidFormatException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CharsetProviderICU
extends CharsetProvider {
    public final Charset charsetForName(String charsetName) {
        try {
            String icuCanonicalName = CharsetProviderICU.getICUCanonicalName(charsetName);
            if (icuCanonicalName == null || icuCanonicalName.length() == 0) {
                return null;
            }
            return CharsetProviderICU.getCharset(icuCanonicalName);
        }
        catch (UnsupportedCharsetException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final Charset charsetForName(String charsetName, String classPath) {
        return this.charsetForName(charsetName, classPath, null);
    }

    public Charset charsetForName(String charsetName, String classPath, ClassLoader loader) {
        CharsetMBCS cs = null;
        try {
            cs = new CharsetMBCS(charsetName, charsetName, new String[0], classPath, loader);
        }
        catch (InvalidFormatException e) {
            // empty catch block
        }
        return cs;
    }

    public static final String getICUCanonicalName(String enc) throws UnsupportedCharsetException {
        String canonicalName = null;
        String ret = null;
        try {
            if (enc != null) {
                canonicalName = UConverterAlias.getCanonicalName(enc, "MIME");
                ret = canonicalName != null ? canonicalName : ((canonicalName = UConverterAlias.getCanonicalName(enc, "IANA")) != null ? canonicalName : ((canonicalName = UConverterAlias.getCanonicalName(enc, "")) != null ? canonicalName : ((canonicalName = UConverterAlias.getAlias(enc, 0)) != null ? canonicalName : (enc.indexOf("x-") == 0 ? enc.substring(2) : ""))));
            }
            return ret;
        }
        catch (IOException ex) {
            throw new UnsupportedCharsetException(enc);
        }
    }

    private static final Charset getCharset(String icuCanonicalName) throws IOException {
        String[] aliases = CharsetProviderICU.getAliases(icuCanonicalName);
        String canonicalName = CharsetProviderICU.getJavaCanonicalName(icuCanonicalName);
        return CharsetICU.getCharset(icuCanonicalName, canonicalName, aliases);
    }

    private static String getJavaCanonicalName(String icuCanonicalName) {
        if (icuCanonicalName == null) {
            return null;
        }
        try {
            String cName = null;
            cName = UConverterAlias.getStandardName(icuCanonicalName, "MIME");
            if (cName == null && (cName = UConverterAlias.getStandardName(icuCanonicalName, "IANA")) == null) {
                String name;
                int aliasNum = UConverterAlias.countAliases(icuCanonicalName);
                for (int i = 0; i < aliasNum; ++i) {
                    name = UConverterAlias.getAlias(icuCanonicalName, i);
                    if (name == null || name.indexOf("x-") != 0) continue;
                    cName = name;
                    break;
                }
                if (cName == null || cName.length() == 0) {
                    name = UConverterAlias.getStandardName(icuCanonicalName, "UTR22");
                    if (name == null && icuCanonicalName.indexOf(",") != -1) {
                        name = UConverterAlias.getAlias(icuCanonicalName, 1);
                    }
                    if (name == null) {
                        name = icuCanonicalName;
                    }
                    cName = "x-" + name;
                }
            }
            return cName;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static final String[] getAliases(String encName) throws IOException {
        String[] ret = null;
        int aliasNum = 0;
        int i = 0;
        int j = 0;
        String[] aliasArray = new String[50];
        if (encName != null) {
            aliasNum = UConverterAlias.countAliases(encName);
            j = 0;
            for (i = 0; i < aliasNum; ++i) {
                String name = UConverterAlias.getAlias(encName, i);
                if (name.indexOf(43) != -1 || name.indexOf(44) != -1) continue;
                aliasArray[j++] = name;
            }
            ret = new String[j];
            while (--j >= 0) {
                ret[j] = aliasArray[j];
            }
        }
        return ret;
    }

    private static final void putCharsets(Map map) {
        int num = UConverterAlias.countAvailable();
        for (int i = 0; i < num; ++i) {
            String name = UConverterAlias.getAvailableName(i);
            try {
                Charset cs = CharsetProviderICU.getCharset(name);
                map.put(cs, CharsetProviderICU.getJavaCanonicalName(name));
                continue;
            }
            catch (UnsupportedCharsetException ex) {
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public final Iterator charsets() {
        HashMap map = new HashMap();
        CharsetProviderICU.putCharsets(map);
        return map.keySet().iterator();
    }

    public static final Object[] getAvailableNames() {
        HashMap map = new HashMap();
        CharsetProviderICU.putCharsets(map);
        return map.values().toArray();
    }

    public static final String[] getAllNames() {
        int num = UConverterAlias.countAvailable();
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            names[i] = UConverterAlias.getAvailableName(i);
        }
        return names;
    }
}

