/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.UConverterDataReader;
import com.ibm.icu.charset.UConverterSharedData;
import com.ibm.icu.charset.UConverterStaticData;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.InvalidFormatException;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetMBCS
extends CharsetICU {
    private byte[] fromUSubstitution = null;
    private UConverterSharedData sharedData = null;
    private static final int MAX_VERSION_LENGTH = 4;
    private static final int MBCS_OUTPUT_1 = 0;
    private static final int MBCS_OUTPUT_2 = 1;
    private static final int MBCS_OUTPUT_3 = 2;
    private static final int MBCS_OUTPUT_4 = 3;
    private static final int MBCS_OUTPUT_3_EUC = 8;
    private static final int MBCS_OUTPUT_4_EUC = 9;
    private static final int MBCS_OUTPUT_2_SISO = 12;
    private static final int MBCS_OUTPUT_2_HZ = 13;
    private static final int MBCS_OUTPUT_EXT_ONLY = 14;
    private static final int MBCS_OUTPUT_DBCS_ONLY = 219;
    private static long LINEAR_18030_BASE = CharsetMBCS.LINEAR_18030(129L, 48L, 129L, 48L);
    private static final long[][] gb18030Ranges = new long[][]{{65536L, 0x10FFFFL, CharsetMBCS.LINEAR(2419097904L), CharsetMBCS.LINEAR(3811744309L)}, {40870L, 55295L, CharsetMBCS.LINEAR(2184548147L), CharsetMBCS.LINEAR(2201405240L)}, {1106L, 8207L, CharsetMBCS.LINEAR(2167460656L), CharsetMBCS.LINEAR(2167842097L)}, {59493L, 63787L, CharsetMBCS.LINEAR(2201407536L), CharsetMBCS.LINEAR(2217772340L)}, {9795L, 11904L, CharsetMBCS.LINEAR(2167908409L), CharsetMBCS.LINEAR(2167995704L)}, {64042L, 65071L, CharsetMBCS.LINEAR(2217778232L), CharsetMBCS.LINEAR(2217837879L)}, {15585L, 16469L, CharsetMBCS.LINEAR(2184303672L), CharsetMBCS.LINEAR(2184359730L)}, {13851L, 14615L, CharsetMBCS.LINEAR(2184226355L), CharsetMBCS.LINEAR(2184245815L)}, {18872L, 19574L, CharsetMBCS.LINEAR(2184487217L), CharsetMBCS.LINEAR(2184505139L)}, {16736L, 17206L, CharsetMBCS.LINEAR(2184366391L), CharsetMBCS.LINEAR(2184378423L)}, {18318L, 18758L, CharsetMBCS.LINEAR(2184439864L), CharsetMBCS.LINEAR(2184484408L)}, {17623L, 17995L, CharsetMBCS.LINEAR(2184422201L), CharsetMBCS.LINEAR(2184431921L)}, {65510L, 65535L, CharsetMBCS.LINEAR(2217845300L), CharsetMBCS.LINEAR(2217845817L)}};
    private static final int MBCS_OPTION_GB18030 = 32768;
    private static final int MBCS_STATE_VALID_DIRECT_16 = 0;
    private static final int MBCS_STATE_VALID_DIRECT_20 = 1;
    private static final int MBCS_STATE_FALLBACK_DIRECT_16 = 2;
    private static final int MBCS_STATE_FALLBACK_DIRECT_20 = 3;
    private static final int MBCS_STATE_VALID_16 = 4;
    private static final int MBCS_STATE_VALID_16_PAIR = 5;
    private static final int MBCS_STATE_UNASSIGNED = 6;
    private static final int MBCS_STATE_ILLEGAL = 7;
    private static final int MBCS_STATE_CHANGE_ONLY = 8;
    private static final int EXT_INDEXES_LENGTH = 0;
    private static final int EXT_TO_U_INDEX = 1;
    private static final int EXT_TO_U_LENGTH = 2;
    private static final int EXT_TO_U_UCHARS_INDEX = 3;
    private static final int EXT_TO_U_UCHARS_LENGTH = 4;
    private static final int EXT_FROM_U_UCHARS_INDEX = 5;
    private static final int EXT_FROM_U_VALUES_INDEX = 6;
    private static final int EXT_FROM_U_LENGTH = 7;
    private static final int EXT_FROM_U_BYTES_INDEX = 8;
    private static final int EXT_FROM_U_BYTES_LENGTH = 9;
    private static final int EXT_FROM_U_STAGE_12_INDEX = 10;
    private static final int EXT_FROM_U_STAGE_1_LENGTH = 11;
    private static final int EXT_FROM_U_STAGE_12_LENGTH = 12;
    private static final int EXT_FROM_U_STAGE_3_INDEX = 13;
    private static final int EXT_FROM_U_STAGE_3_LENGTH = 14;
    private static final int EXT_FROM_U_STAGE_3B_INDEX = 15;
    private static final int EXT_FROM_U_STAGE_3B_LENGTH = 16;
    private static final int EXT_COUNT_BYTES = 17;
    private static final int TO_U_BYTE_SHIFT = 24;
    private static final int TO_U_VALUE_MASK = 0xFFFFFF;
    private static final int TO_U_MIN_CODE_POINT = 0x1F0000;
    private static final int TO_U_MAX_CODE_POINT = 0x2FFFFF;
    private static final int TO_U_ROUNDTRIP_FLAG = 0x800000;
    private static final int TO_U_INDEX_MASK = 262143;
    private static final int TO_U_LENGTH_SHIFT = 18;
    private static final int TO_U_LENGTH_OFFSET = 12;
    private static final int MAX_UCHARS = 19;
    private static final int STAGE_2_LEFT_SHIFT = 2;
    private static final int FROM_U_LENGTH_SHIFT = 24;
    private static final int FROM_U_ROUNDTRIP_FLAG = Integer.MIN_VALUE;
    private static final int FROM_U_RESERVED_MASK = 0x60000000;
    private static final int FROM_U_DATA_MASK = 0xFFFFFF;
    private static final int FROM_U_SUBCHAR1 = -2147483647;
    private static final int FROM_U_MAX_DIRECT_LENGTH = 3;
    private static final int MAX_BYTES = 31;

    public CharsetMBCS(String icuCanonicalName, String javaCanonicalName, String[] aliases, String classPath, ClassLoader loader) throws InvalidFormatException {
        super(icuCanonicalName, javaCanonicalName, aliases);
        LoadArguments args = new LoadArguments(1, icuCanonicalName, classPath, loader);
        this.sharedData = this.loadConverter(args);
        this.maxBytesPerChar = this.sharedData.staticData.maxBytesPerChar;
        this.minBytesPerChar = this.sharedData.staticData.minBytesPerChar;
        this.maxCharsPerByte = 1.0f;
        this.fromUSubstitution = this.sharedData.staticData.subChar;
        this.subChar = this.sharedData.staticData.subChar;
        this.subCharLen = this.sharedData.staticData.subCharLen;
        this.subChar1 = this.sharedData.staticData.subChar1;
        this.fromUSubstitution = new byte[this.sharedData.staticData.subCharLen];
        System.arraycopy(this.sharedData.staticData.subChar, 0, this.fromUSubstitution, 0, this.sharedData.staticData.subCharLen);
        this.initializeConverter(0);
    }

    public CharsetMBCS(String icuCanonicalName, String javaCanonicalName, String[] aliases) throws InvalidFormatException {
        this(icuCanonicalName, javaCanonicalName, aliases, "data/icudt38b", null);
    }

    private UConverterSharedData loadConverter(LoadArguments args) throws InvalidFormatException {
        UConverterStaticData staticData = new UConverterStaticData();
        UConverterDataReader reader = null;
        try {
            String resourceName = args.classPath + "/" + args.name + "." + "cnv";
            InputStream i = args.loader != null ? ICUData.getRequiredStream((ClassLoader)args.loader, (String)resourceName) : ICUData.getRequiredStream((String)resourceName);
            BufferedInputStream b = new BufferedInputStream(i, 25000);
            reader = new UConverterDataReader(b);
            reader.readStaticData(staticData);
        }
        catch (IOException e) {
            throw new InvalidFormatException();
        }
        catch (Exception e) {
            throw new InvalidFormatException();
        }
        UConverterSharedData data = null;
        byte type = staticData.conversionType;
        if (type != 2 || staticData.structSize != 100) {
            throw new InvalidFormatException();
        }
        data = new UConverterSharedData(1, null, false, 0L);
        data.dataReader = reader;
        data.staticData = staticData;
        data.sharedDataCached = false;
        UConverterMBCSTable mbcsTable = data.mbcs;
        MBCSHeader header = new MBCSHeader();
        try {
            reader.readMBCSHeader(header);
        }
        catch (IOException e) {
            throw new InvalidFormatException();
        }
        String baseNameString = null;
        int[][] stateTableArray = null;
        MBCSToUFallback[] toUFallbacksArray = null;
        char[] unicodeCodeUnitsArray = null;
        char[] fromUnicodeTableArray = null;
        byte[] fromUnicodeBytesArray = null;
        if (header.version[0] != 4) {
            throw new InvalidFormatException();
        }
        mbcsTable.outputType = (byte)header.flags;
        int offset = header.flags >>> 8;
        if (mbcsTable.outputType == 14) {
            try {
                baseNameString = reader.readBaseTableName();
                if (offset != 0) {
                    mbcsTable.extIndexes = reader.readExtIndexes(offset - (reader.bytesRead - reader.staticDataBytesRead));
                }
            }
            catch (IOException e) {
                throw new InvalidFormatException();
            }
        }
        if (mbcsTable.outputType == 14) {
            UConverterSharedData baseSharedData = null;
            ByteBuffer extIndexes = mbcsTable.extIndexes;
            if (extIndexes == null) {
                throw new InvalidFormatException();
            }
            if (args.nestedLoads != 1) {
                throw new InvalidFormatException();
            }
            String baseName = baseNameString;
            if (baseName.equals(staticData.name)) {
                throw new InvalidFormatException();
            }
            LoadArguments args2 = new LoadArguments(2, baseName, args.classPath, args.loader);
            baseSharedData = this.loadConverter(args2);
            if (baseSharedData.staticData.conversionType != 2 || baseSharedData.mbcs.baseSharedData != null) {
                throw new InvalidFormatException();
            }
            mbcsTable = data.mbcs = baseSharedData.mbcs;
            mbcsTable.baseSharedData = baseSharedData;
            mbcsTable.extIndexes = extIndexes;
            mbcsTable.swapLFNLStateTable = null;
            mbcsTable.swapLFNLFromUnicodeBytes = null;
            mbcsTable.swapLFNLName = null;
            if (staticData.conversionType == 1 || staticData.conversionType == 2 && staticData.minBytesPerChar >= 2) {
                if (baseSharedData.mbcs.outputType == 12) {
                    int entry = mbcsTable.stateTable[0][14];
                    if (CharsetMBCS.MBCS_ENTRY_IS_FINAL(entry) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 8 && CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry) != 0) {
                        mbcsTable.dbcsOnlyState = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                        mbcsTable.outputType = (short)219;
                    }
                } else if (baseSharedData.staticData.conversionType == 2 && baseSharedData.staticData.minBytesPerChar == 1 && baseSharedData.staticData.maxBytesPerChar == 2 && mbcsTable.countStates <= 127) {
                    int i;
                    short count = mbcsTable.countStates;
                    int[][] newStateTable = new int[(count + 1) * 1024][256];
                    for (i = 0; i < mbcsTable.stateTable.length; ++i) {
                        System.arraycopy(mbcsTable.stateTable[i], 0, newStateTable[i], 0, mbcsTable.stateTable[i].length);
                    }
                    int[] state = newStateTable[0];
                    for (i = 0; i < 256; ++i) {
                        if (!CharsetMBCS.MBCS_ENTRY_IS_FINAL(state[i])) continue;
                        state[i] = CharsetMBCS.MBCS_ENTRY_TRANSITION(count, 0);
                    }
                    state = newStateTable[count];
                    for (i = 0; i < 256; ++i) {
                        state[i] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 7, 0);
                    }
                    mbcsTable.stateTable = newStateTable;
                    mbcsTable.countStates = (byte)(count + 1);
                    mbcsTable.stateTableOwned = true;
                    mbcsTable.outputType = (short)219;
                }
            }
        } else {
            switch (mbcsTable.outputType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 12: {
                    break;
                }
                default: {
                    throw new InvalidFormatException();
                }
            }
            stateTableArray = new int[header.countStates][256];
            toUFallbacksArray = new MBCSToUFallback[header.countToUFallbacks];
            for (int i = 0; i < toUFallbacksArray.length; ++i) {
                toUFallbacksArray[i] = new MBCSToUFallback();
            }
            unicodeCodeUnitsArray = new char[(header.offsetFromUTable - header.offsetToUCodeUnits) / 2];
            fromUnicodeTableArray = new char[(header.offsetFromUBytes - header.offsetFromUTable) / 2];
            fromUnicodeBytesArray = new byte[header.fromUBytesLength];
            try {
                reader.readMBCSTable(stateTableArray, toUFallbacksArray, unicodeCodeUnitsArray, fromUnicodeTableArray, fromUnicodeBytesArray);
            }
            catch (IOException e) {
                throw new InvalidFormatException();
            }
            mbcsTable.countStates = (byte)header.countStates;
            mbcsTable.countToUFallbacks = header.countToUFallbacks;
            mbcsTable.stateTable = stateTableArray;
            mbcsTable.toUFallbacks = toUFallbacksArray;
            mbcsTable.unicodeCodeUnits = unicodeCodeUnitsArray;
            mbcsTable.fromUnicodeTable = fromUnicodeTableArray;
            mbcsTable.fromUnicodeBytes = fromUnicodeBytesArray;
            mbcsTable.fromUBytesLength = header.fromUBytesLength;
            mbcsTable.unicodeMask = (short)(staticData.unicodeMask & 3);
            if (offset != 0) {
                try {
                    mbcsTable.extIndexes = reader.readExtIndexes(offset - (reader.bytesRead - reader.staticDataBytesRead));
                }
                catch (IOException e) {
                    throw new InvalidFormatException();
                }
            }
        }
        return data;
    }

    protected void initializeConverter(int options) {
        ByteBuffer extIndexes;
        UConverterMBCSTable mbcsTable = this.sharedData.mbcs;
        short outputType = mbcsTable.outputType;
        if (outputType == 219) {
            this.options = options &= 0xFFFFFFEF;
        }
        if ((options & 0x10) != 0) {
            boolean isCached;
            boolean bl = isCached = mbcsTable.swapLFNLStateTable != null;
            if (!isCached) {
                // empty if block
            }
        }
        if (this.icuCanonicalName.toLowerCase().indexOf("gb18030") >= 0) {
            this.options |= 0x8000;
        }
        if (outputType == 12) {
            this.maxBytesPerChar = 3;
        }
        if ((extIndexes = mbcsTable.extIndexes) != null) {
            byte maxBytesPerUChar = (byte)CharsetMBCS.GET_MAX_BYTES_PER_UCHAR(extIndexes);
            if (outputType == 12) {
                maxBytesPerUChar = (byte)(maxBytesPerUChar + 1);
            }
            if (maxBytesPerUChar > this.maxBytesPerChar) {
                this.maxBytesPerChar = maxBytesPerUChar;
            }
        }
    }

    private static long LINEAR_18030(long a, long b, long c, long d) {
        return (((a & 0xFFL) * 10L + (b & 0xFFL)) * 126L + (c & 0xFFL)) * 10L + (d & 0xFFL);
    }

    private static long LINEAR(long x) {
        return CharsetMBCS.LINEAR_18030(x >>> 24, x >>> 16 & 0xFFL, x >>> 8 & 0xFFL, x & 0xFFL);
    }

    private static int MBCS_ENTRY_TRANSITION(int state, int offset) {
        return state << 24 | offset;
    }

    private static int MBCS_ENTRY_FINAL(int state, int action, int value) {
        return Integer.MIN_VALUE | state << 24 | action << 20 | value;
    }

    private static boolean MBCS_ENTRY_IS_TRANSITION(int entry) {
        return entry >= 0;
    }

    private static boolean MBCS_ENTRY_IS_FINAL(int entry) {
        return entry < 0;
    }

    private static int MBCS_ENTRY_TRANSITION_STATE(int entry) {
        return entry >>> 24;
    }

    private static int MBCS_ENTRY_TRANSITION_OFFSET(int entry) {
        return entry & 0xFFFFFF;
    }

    private static int MBCS_ENTRY_FINAL_STATE(int entry) {
        return entry >>> 24 & 0x7F;
    }

    private static boolean MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(int entry) {
        return entry < -2146435072;
    }

    private static int MBCS_ENTRY_FINAL_ACTION(int entry) {
        return entry >>> 20 & 0xF;
    }

    private static int MBCS_ENTRY_FINAL_VALUE(int entry) {
        return entry & 0xFFFFF;
    }

    private static char MBCS_ENTRY_FINAL_VALUE_16(int entry) {
        return (char)entry;
    }

    static char MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(UConverterMBCSTable mbcs, int b) {
        return CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(mbcs.stateTable[0][b & 0xFF]);
    }

    private static char MBCS_SINGLE_RESULT_FROM_U(char[] table, byte[] results, int c) {
        int i1 = table[c >>> 10] + (c >>> 4 & 0x3F);
        int i = 2 * (table[i1] + (c & 0xF));
        return (char)((results[i] & 0xFF) << 8 | results[i + 1] & 0xFF);
    }

    private static int MBCS_STAGE_2_FROM_U(char[] table, int c) {
        int i = 2 * (table[c >>> 10] + (c >>> 4 & 0x3F));
        return (table[i] & 0xFFFF) << 16 | table[i + 1] & 0xFFFF;
    }

    private static boolean MBCS_FROM_U_IS_ROUNDTRIP(int stage2Entry, int c) {
        return (stage2Entry & 1 << 16 + (c & 0xF)) != 0;
    }

    private static char MBCS_VALUE_2_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        int i = 2 * (16 * ((char)stage2Entry & 0xFFFF) + (c & 0xF));
        return (char)((bytes[i] & 0xFF) << 8 | bytes[i + 1] & 0xFF);
    }

    private static int MBCS_VALUE_4_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        int i = 4 * (16 * ((char)stage2Entry & 0xFFFF) + (c & 0xF));
        return (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16 | (bytes[i + 2] & 0xFF) << 8 | bytes[i + 3] & 0xFF;
    }

    private static int MBCS_POINTER_3_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        return (16 * ((char)stage2Entry & 0xFFFF) + (c & 0xF)) * 3;
    }

    private static int TO_U_GET_BYTE(int word) {
        return word >>> 24;
    }

    private static int TO_U_GET_VALUE(int word) {
        return word & 0xFFFFFF;
    }

    private static boolean TO_U_IS_ROUNDTRIP(int value) {
        return (value & 0x800000) != 0;
    }

    private static boolean TO_U_IS_PARTIAL(int value) {
        return ((long)value & 0xFFFFFFFFL) < 0x1F0000L;
    }

    private static int TO_U_GET_PARTIAL_INDEX(int value) {
        return value;
    }

    private static int TO_U_MASK_ROUNDTRIP(int value) {
        return value & 0xFF7FFFFF;
    }

    private static int TO_U_MAKE_WORD(byte b, int value) {
        return (b & 0xFF) << 24 | value;
    }

    private static boolean TO_U_IS_CODE_POINT(int value) {
        return ((long)value & 0xFFFFFFFFL) <= 0x2FFFFFL;
    }

    private static int TO_U_GET_CODE_POINT(int value) {
        return (int)(((long)value & 0xFFFFFFFFL) - 0x1F0000L);
    }

    private static int TO_U_GET_INDEX(int value) {
        return value & 0x3FFFF;
    }

    private static int TO_U_GET_LENGTH(int value) {
        return (value >>> 18) - 12;
    }

    private static int FROM_U(CharBuffer stage12, CharBuffer stage3, int s1Index, int c) {
        return stage3.get(stage3.position() + (stage12.get(stage12.position() + (stage12.get(stage12.position() + s1Index) + (c >>> 4 & 0x3F))) << 2) + (c & 0xF));
    }

    private static boolean FROM_U_IS_PARTIAL(int value) {
        return value >>> 24 == 0;
    }

    private static int FROM_U_GET_PARTIAL_INDEX(int value) {
        return value;
    }

    private static boolean FROM_U_IS_ROUNDTRIP(int value) {
        return (value & Integer.MIN_VALUE) != 0;
    }

    private static int FROM_U_MASK_ROUNDTRIP(int value) {
        return value & Integer.MAX_VALUE;
    }

    private static int FROM_U_GET_LENGTH(int value) {
        return value >>> 24 & 0x1F;
    }

    private static int FROM_U_GET_DATA(int value) {
        return value & 0xFFFFFF;
    }

    private static Buffer ARRAY(ByteBuffer indexes, int index, Class itemType) {
        int oldpos = indexes.position();
        indexes.position(indexes.getInt(index * 4));
        Buffer b = itemType == Integer.TYPE ? indexes.asIntBuffer() : (itemType == Character.TYPE ? indexes.asCharBuffer() : (itemType == Short.TYPE ? indexes.asShortBuffer() : indexes.slice()));
        indexes.position(oldpos);
        return b;
    }

    private static int GET_MAX_BYTES_PER_UCHAR(ByteBuffer indexes) {
        indexes.position(0);
        return indexes.getInt(17) & 0xFF;
    }

    private static int findFromU(CharBuffer fromUSection, int length, char u) {
        int i;
        int start = 0;
        int limit = length;
        while ((i = limit - start) > 1) {
            if (i <= 4) {
                if (u <= fromUSection.get(fromUSection.position() + start) || ++start < limit && u <= fromUSection.get(fromUSection.position() + start) || ++start < limit && u <= fromUSection.get(fromUSection.position() + start)) break;
                ++start;
                break;
            }
            i = (start + limit) / 2;
            if (u < fromUSection.get(fromUSection.position() + i)) {
                limit = i;
                continue;
            }
            start = i;
        }
        if (start < limit && u == fromUSection.get(fromUSection.position() + start)) {
            return start;
        }
        return -1;
    }

    private static int findToU(IntBuffer toUSection, int length, short byt) {
        int i;
        int start = CharsetMBCS.TO_U_GET_BYTE(toUSection.get(toUSection.position()));
        int limit = CharsetMBCS.TO_U_GET_BYTE(toUSection.get(toUSection.position() + length - 1));
        if (byt < start || limit < byt) {
            return 0;
        }
        if (length == limit - start + 1) {
            return CharsetMBCS.TO_U_GET_VALUE(toUSection.get(toUSection.position() + byt - start));
        }
        long word0 = (long)CharsetMBCS.TO_U_MAKE_WORD((byte)byt, 0) & 0xFFFFFFFFL;
        long word = word0 | 0xFFFFFFL;
        start = 0;
        limit = length;
        while ((i = limit - start) > 1) {
            if (i <= 4) {
                if (word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL) || ++start < limit && word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL) || ++start < limit && word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL)) break;
                ++start;
                break;
            }
            i = (start + limit) / 2;
            if (word < ((long)toUSection.get(toUSection.position() + i) & 0xFFFFFFFFL)) {
                limit = i;
                continue;
            }
            start = i;
        }
        if (start < limit && byt == CharsetMBCS.TO_U_GET_BYTE((int)(word = (long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL))) {
            return CharsetMBCS.TO_U_GET_VALUE((int)word);
        }
        return 0;
    }

    private static boolean TO_U_VERIFY_SISO_MATCH(byte sisoState, int match) {
        return sisoState < 0 || sisoState == 0 == (match == 1);
    }

    private static int SISO_STATE(UConverterSharedData sharedData, int mode) {
        return sharedData.mbcs.outputType == 12 ? (byte)mode : (sharedData.mbcs.outputType == 219 ? (byte)1 : (byte)-1);
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderMBCS(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderMBCS(this);
    }

    class CharsetEncoderMBCS
    extends CharsetEncoderICU {
        private boolean allowReplacementChanges = true;

        CharsetEncoderMBCS(CharsetICU cs) {
            super(cs, CharsetMBCS.this.fromUSubstitution);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.preFromUFirstCP = -1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            try {
                SideEffects x;
                int prevLength;
                if (this.preFromUFirstCP >= 0) {
                    cr[0] = this.continueMatchFromU(source, target, offsets, flush, -1);
                    if (cr[0].isError()) return cr[0];
                    if (this.preFromULength < 0) {
                        return cr[0];
                    }
                }
                short outputType = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.outputType;
                short unicodeMask = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.unicodeMask;
                if (outputType == 0 && (unicodeMask & 2) == 0) {
                    if ((unicodeMask & 1) == 0) {
                        cr[0] = this.cnvMBCSSingleFromBMPWithOffsets(source, target, offsets, flush);
                        return cr[0];
                    }
                    cr[0] = this.cnvMBCSSingleFromUnicodeWithOffsets(source, target, offsets, flush);
                    return cr[0];
                }
                if (outputType == 1) {
                    cr[0] = this.cnvMBCSDoubleFromUnicodeWithOffsets(source, target, offsets, flush);
                    return cr[0];
                }
                char[] table = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeTable;
                int sourceArrayIndex = source.position();
                byte[] bytes = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLFromUnicodeBytes : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeBytes;
                int c = this.fromUChar32;
                if (outputType == 12) {
                    prevLength = this.fromUnicodeStatus;
                    if (prevLength == 0) {
                        prevLength = 1;
                    }
                } else {
                    prevLength = 0;
                }
                int prevSourceIndex = -1;
                int sourceIndex = c == 0 ? 0 : -1;
                int nextSourceIndex = 0;
                boolean doloop = true;
                boolean doread = true;
                if (c != 0 && target.hasRemaining()) {
                    if (UTF16.isLeadSurrogate((char)((char)c)) && (unicodeMask & 2) == 0) {
                        x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, prevLength);
                        doloop = this.getTrail(source, target, unicodeMask, x, flush, cr);
                        doread = x.doread;
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        sourceIndex = x.sourceIndex;
                        nextSourceIndex = x.nextSourceIndex;
                        prevSourceIndex = x.prevSourceIndex;
                        prevLength = x.prevLength;
                    } else {
                        doread = false;
                    }
                }
                if (doloop) {
                    while (!doread || sourceArrayIndex < source.limit()) {
                        if (target.hasRemaining()) {
                            int length;
                            int value;
                            if (doread) {
                                c = source.get(sourceArrayIndex++);
                                ++nextSourceIndex;
                                if (UTF16.isSurrogate((char)((char)c)) && (unicodeMask & 2) == 0) {
                                    if (UTF16.isLeadSurrogate((char)((char)c))) {
                                        x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, prevLength);
                                        doloop = this.getTrail(source, target, unicodeMask, x, flush, cr);
                                        c = x.c;
                                        sourceArrayIndex = x.sourceArrayIndex;
                                        sourceIndex = x.sourceIndex;
                                        nextSourceIndex = x.nextSourceIndex;
                                        prevSourceIndex = x.prevSourceIndex;
                                        if (x.doread) {
                                            if (!doloop) break;
                                            continue;
                                        }
                                    } else {
                                        cr[0] = CoderResult.malformedForLength(1);
                                        break;
                                    }
                                }
                            } else {
                                doread = true;
                            }
                            int stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, c);
                            switch (outputType) {
                                case 1: {
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        length = 1;
                                        break;
                                    }
                                    length = 2;
                                    break;
                                }
                                case 12: {
                                    this.fromUnicodeStatus = prevLength;
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        if (value == 0 && !CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c)) {
                                            length = 0;
                                            break;
                                        }
                                        if (prevLength <= 1) {
                                            length = 1;
                                            break;
                                        }
                                        value |= 0xF00;
                                        length = 2;
                                        prevLength = 1;
                                        break;
                                    }
                                    if (prevLength == 2) {
                                        length = 2;
                                        break;
                                    }
                                    value |= 0xE0000;
                                    length = 3;
                                    prevLength = 2;
                                    break;
                                }
                                case 219: {
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        stage2Entry = 0;
                                        value = 0;
                                        length = 0;
                                        break;
                                    }
                                    length = 2;
                                    break;
                                }
                                case 2: {
                                    byte[] pArray = bytes;
                                    int pArrayIndex = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                                    value = (pArray[pArrayIndex] & 0xFF) << 16 | (pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF;
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        length = 1;
                                        break;
                                    }
                                    if (((long)value & 0xFFFFFFFFL) <= 65535L) {
                                        length = 2;
                                        break;
                                    }
                                    length = 3;
                                    break;
                                }
                                case 3: {
                                    value = CharsetMBCS.MBCS_VALUE_4_FROM_STAGE_2(bytes, stage2Entry, c);
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        length = 1;
                                        break;
                                    }
                                    if (((long)value & 0xFFFFFFFFL) <= 65535L) {
                                        length = 2;
                                        break;
                                    }
                                    if (((long)value & 0xFFFFFFFFL) <= 0xFFFFFFL) {
                                        length = 3;
                                        break;
                                    }
                                    length = 4;
                                    break;
                                }
                                case 8: {
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        length = 1;
                                        break;
                                    }
                                    if ((value & 0x8000) == 0) {
                                        value |= 0x8E8000;
                                        length = 3;
                                        break;
                                    }
                                    if ((value & 0x80) == 0) {
                                        value |= 0x8F0080;
                                        length = 3;
                                        break;
                                    }
                                    length = 2;
                                    break;
                                }
                                case 9: {
                                    byte[] pArray = bytes;
                                    int pArrayIndex = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                                    value = (pArray[pArrayIndex] & 0xFF) << 16 | (pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF;
                                    if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                        length = 1;
                                        break;
                                    }
                                    if (((long)value & 0xFFFFFFFFL) <= 65535L) {
                                        length = 2;
                                        break;
                                    }
                                    if ((value & 0x800000) == 0) {
                                        value |= 0x8E800000;
                                        length = 4;
                                        break;
                                    }
                                    if ((value & 0x8000) == 0) {
                                        value |= 0x8F008000;
                                        length = 4;
                                        break;
                                    }
                                    length = 3;
                                    break;
                                }
                                default: {
                                    stage2Entry = 0;
                                    value = 0;
                                    length = 0;
                                }
                            }
                            if (!(CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) || this.isFromUUseFallback(c) && value != 0)) {
                                x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, prevLength);
                                doloop = this.unassigned(source, target, offsets, x, flush, cr);
                                c = x.c;
                                sourceArrayIndex = x.sourceArrayIndex;
                                sourceIndex = x.sourceIndex;
                                nextSourceIndex = x.nextSourceIndex;
                                prevSourceIndex = x.prevSourceIndex;
                                prevLength = x.prevLength;
                                if (!doloop) break;
                                continue;
                            }
                            if (length > target.remaining()) {
                                int errorBufferArrayIndex = 0;
                                switch (length -= target.remaining()) {
                                    case 3: {
                                        this.errorBuffer[errorBufferArrayIndex++] = (byte)(value >>> 16);
                                    }
                                    case 2: {
                                        this.errorBuffer[errorBufferArrayIndex++] = (byte)(value >>> 8);
                                    }
                                    case 1: {
                                        this.errorBuffer[errorBufferArrayIndex] = (byte)value;
                                        break;
                                    }
                                }
                                this.errorBufferLength = (byte)length;
                                value >>>= 8 * length;
                                switch (target.remaining()) {
                                    case 3: {
                                        target.put((byte)(value >>> 16));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 2: {
                                        target.put((byte)(value >>> 8));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 1: {
                                        target.put((byte)value);
                                        if (offsets == null) break;
                                        offsets.put(sourceIndex);
                                        break;
                                    }
                                }
                                cr[0] = CoderResult.OVERFLOW;
                                c = 0;
                                break;
                            }
                            if (offsets == null) {
                                switch (length) {
                                    case 4: {
                                        target.put((byte)(value >>> 24));
                                    }
                                    case 3: {
                                        target.put((byte)(value >>> 16));
                                    }
                                    case 2: {
                                        target.put((byte)(value >>> 8));
                                    }
                                    case 1: {
                                        target.put((byte)value);
                                        break;
                                    }
                                }
                            } else {
                                switch (length) {
                                    case 4: {
                                        target.put((byte)(value >>> 24));
                                        offsets.put(sourceIndex);
                                    }
                                    case 3: {
                                        target.put((byte)(value >>> 16));
                                        offsets.put(sourceIndex);
                                    }
                                    case 2: {
                                        target.put((byte)(value >>> 8));
                                        offsets.put(sourceIndex);
                                    }
                                    case 1: {
                                        target.put((byte)value);
                                        offsets.put(sourceIndex);
                                        break;
                                    }
                                }
                            }
                            c = 0;
                            if (offsets == null) continue;
                            prevSourceIndex = sourceIndex;
                            sourceIndex = nextSourceIndex;
                            continue;
                        }
                        cr[0] = CoderResult.OVERFLOW;
                        break;
                    }
                }
                if (outputType == 12 && prevLength == 2 && flush && sourceArrayIndex >= source.limit() && c == 0) {
                    if (target.hasRemaining()) {
                        target.put((byte)15);
                        if (offsets != null) {
                            offsets.put(prevSourceIndex);
                        }
                    } else {
                        this.errorBuffer[0] = 15;
                        this.errorBufferLength = 1;
                        cr[0] = CoderResult.OVERFLOW;
                    }
                    prevLength = 1;
                }
                this.fromUChar32 = c;
                this.fromUnicodeStatus = prevLength;
                source.position(sourceArrayIndex);
                return cr[0];
            }
            catch (BufferOverflowException ex) {
                cr[0] = CoderResult.OVERFLOW;
            }
            return cr[0];
        }

        private CoderResult continueMatchFromU(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush, int srcIndex) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int[] value = new int[1];
            int match = this.matchFromU(this.preFromUFirstCP, this.preFromUArray, this.preFromUBegin, this.preFromULength, source, target, value, flush);
            if (match >= 2) {
                if ((match -= 2) >= this.preFromULength) {
                    source.position(source.position() + match - this.preFromULength);
                    this.preFromULength = 0;
                } else {
                    int length = this.preFromULength - match;
                    System.arraycopy(this.preFromUArray, this.preFromUBegin + match, this.preFromUArray, this.preFromUBegin, length);
                    this.preFromULength = (byte)(-length);
                }
                this.preFromUFirstCP = -1;
                this.writeFromU(value[0], target, offsets, srcIndex);
            } else if (match < 0) {
                int sArrayIndex = source.position();
                match = -match - 2;
                for (int j = this.preFromULength; j < match; ++j) {
                    this.preFromUArray[j] = source.get(sArrayIndex++);
                }
                source.position(sArrayIndex);
                this.preFromULength = (byte)match;
            } else {
                if (match == 1) {
                    this.useSubChar1 = true;
                }
                this.fromUChar32 = this.preFromUFirstCP;
                this.preFromUFirstCP = -1;
                this.preFromULength = (byte)(-this.preFromULength);
                cr = CoderResult.unmappableForLength(1);
            }
            return cr;
        }

        private int matchFromU(int firstCP, char[] preArray, int preArrayBegin, int preLength, CharBuffer source, ByteBuffer target, int[] pMatchValue, boolean flush) {
            int matchLength;
            int matchValue;
            ByteBuffer cx = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.extIndexes;
            if (cx == null) {
                return 0;
            }
            int index = firstCP >>> 10;
            if (index >= cx.asIntBuffer().get(11)) {
                return 0;
            }
            CharBuffer stage12 = (CharBuffer)CharsetMBCS.ARRAY(cx, 10, Character.TYPE);
            CharBuffer stage3 = (CharBuffer)CharsetMBCS.ARRAY(cx, 13, Character.TYPE);
            index = CharsetMBCS.FROM_U(stage12, stage3, index, firstCP);
            IntBuffer stage3b = (IntBuffer)CharsetMBCS.ARRAY(cx, 15, Integer.TYPE);
            int value = stage3b.get(stage3b.position() + index);
            if (value == 0) {
                return 0;
            }
            if (CharsetMBCS.TO_U_IS_PARTIAL(value)) {
                block17: {
                    index = CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(value);
                    CharBuffer fromUTableUChars = (CharBuffer)CharsetMBCS.ARRAY(cx, 5, Character.TYPE);
                    IntBuffer fromUTableValues = (IntBuffer)CharsetMBCS.ARRAY(cx, 6, Integer.TYPE);
                    matchValue = 0;
                    matchLength = 0;
                    int j = 0;
                    int i = 0;
                    while (true) {
                        char c;
                        int oldpos = fromUTableUChars.position();
                        CharBuffer fromUSectionUChars = ((CharBuffer)fromUTableUChars.position(index)).slice();
                        fromUTableUChars.position(oldpos);
                        oldpos = fromUTableValues.position();
                        IntBuffer fromUSectionValues = ((IntBuffer)fromUTableValues.position(index)).slice();
                        fromUTableValues.position(oldpos);
                        int length = fromUSectionUChars.get();
                        value = fromUSectionValues.get();
                        if (value != 0 && (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || this.isFromUUseFallback(firstCP))) {
                            matchValue = value;
                            matchLength = 2 + i + j;
                        }
                        if (i < preLength) {
                            c = preArray[preArrayBegin + i++];
                        } else {
                            if (j >= source.remaining()) {
                                if (!flush && (length = i + j) <= 19) {
                                    return -(2 + length);
                                }
                                break block17;
                            }
                            c = source.get(source.position() + j++);
                        }
                        index = CharsetMBCS.findFromU(fromUSectionUChars, length, c);
                        if (index < 0) break block17;
                        value = fromUSectionValues.get(fromUSectionValues.position() + index);
                        if (!CharsetMBCS.FROM_U_IS_PARTIAL(value)) break;
                        index = CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(value);
                    }
                    if (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || this.isFromUUseFallback(firstCP)) {
                        matchValue = value;
                        matchLength = 2 + i + j;
                    }
                }
                if (matchLength == 0) {
                    return 0;
                }
            } else if (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || this.isFromUUseFallback(firstCP)) {
                matchValue = value;
                matchLength = 2;
            } else {
                return 0;
            }
            if ((matchValue & 0x60000000) != 0) {
                return 0;
            }
            if (matchValue == -2147483647) {
                return 1;
            }
            pMatchValue[0] = CharsetMBCS.FROM_U_MASK_ROUNDTRIP(matchValue);
            return matchLength;
        }

        private CoderResult writeFromU(int value, ByteBuffer target, IntBuffer offsets, int srcIndex) {
            int resultArrayIndex;
            byte[] resultArray;
            ByteBuffer cx = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.extIndexes;
            byte[] bufferArray = new byte[32];
            int bufferArrayIndex = 0;
            int length = CharsetMBCS.FROM_U_GET_LENGTH(value);
            value = CharsetMBCS.FROM_U_GET_DATA(value);
            if (length <= 3) {
                int p = bufferArrayIndex + 1;
                switch (length) {
                    case 3: {
                        bufferArray[p++] = (byte)(value >>> 16);
                    }
                    case 2: {
                        bufferArray[p++] = (byte)(value >>> 8);
                    }
                    case 1: {
                        bufferArray[p++] = (byte)value;
                    }
                }
                resultArray = bufferArray;
                resultArrayIndex = bufferArrayIndex + 1;
            } else {
                byte[] slice = new byte[length];
                ByteBuffer bb = (ByteBuffer)CharsetMBCS.ARRAY(cx, 8, Byte.TYPE);
                bb.position(value);
                bb.get(slice, 0, slice.length);
                resultArray = slice;
                resultArrayIndex = 0;
            }
            int prevLength = this.fromUnicodeStatus;
            if (prevLength != 0) {
                int shiftByte;
                if (prevLength > 1 && length == 1) {
                    shiftByte = 15;
                    this.fromUnicodeStatus = 1;
                } else if (prevLength == 1 && length > 1) {
                    shiftByte = 14;
                    this.fromUnicodeStatus = 2;
                } else {
                    shiftByte = 0;
                }
                if (shiftByte != 0) {
                    bufferArray[0] = shiftByte;
                    if (resultArray != bufferArray || resultArrayIndex != bufferArrayIndex + 1) {
                        System.arraycopy(resultArray, resultArrayIndex, bufferArray, bufferArrayIndex + 1, length);
                    }
                    resultArray = bufferArray;
                    resultArrayIndex = bufferArrayIndex;
                    ++length;
                }
            }
            return CharsetEncoderMBCS.fromUWriteBytes(this, resultArray, resultArrayIndex, length, target, offsets, srcIndex);
        }

        private int fromU(int cp_, CharBuffer source, ByteBuffer target, IntBuffer offsets, int sourceIndex, boolean flush, CoderResult[] cr) {
            long cp = (long)cp_ & 0xFFFFFFFFL;
            this.useSubChar1 = false;
            if (((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.extIndexes != null && this.initialMatchFromU((int)cp, source, target, offsets, sourceIndex, flush, cr)) {
                return 0;
            }
            if ((CharsetMBCS.this.options & 0x8000) != 0) {
                for (int i = 0; i < gb18030Ranges.length; ++i) {
                    long[] range = gb18030Ranges[i];
                    if (range[0] > cp || cp > range[1]) continue;
                    byte[] bytes = new byte[4];
                    long linear = range[2] - LINEAR_18030_BASE;
                    bytes[3] = (byte)(48L + (linear += cp - range[0]) % 10L);
                    bytes[2] = (byte)(129L + (linear /= 10L) % 126L);
                    bytes[1] = (byte)(48L + (linear /= 126L) % 10L);
                    bytes[0] = (byte)(129L + (linear /= 10L));
                    cr[0] = CharsetEncoderMBCS.fromUWriteBytes(this, bytes, 0, 4, target, offsets, sourceIndex);
                    return 0;
                }
            }
            cr[0] = CoderResult.unmappableForLength(1);
            return (int)cp;
        }

        private boolean initialMatchFromU(int cp, CharBuffer source, ByteBuffer target, IntBuffer offsets, int srcIndex, boolean flush, CoderResult[] cr) {
            int[] value = new int[1];
            int match = this.matchFromU(cp, null, 0, 0, source, target, value, flush);
            if (match >= 2 && (CharsetMBCS.FROM_U_GET_LENGTH(value[0]) != 1 || ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.outputType != 219)) {
                source.position(source.position() + match - 2);
                cr[0] = this.writeFromU(value[0], target, offsets, srcIndex);
                return true;
            }
            if (match < 0) {
                this.preFromUFirstCP = cp;
                int sArrayIndex = source.position();
                match = -match - 2;
                for (int j = 0; j < match; ++j) {
                    this.preFromUArray[j] = source.get(sArrayIndex++);
                }
                source.position(sArrayIndex);
                this.preFromULength = (byte)match;
                return true;
            }
            if (match == 1) {
                this.useSubChar1 = true;
                return false;
            }
            return false;
        }

        private CoderResult cnvMBCSSingleFromBMPWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            SideEffectsSingleBMP x;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            int targetCapacity = target.remaining();
            char[] table = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeTable;
            byte[] results = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLFromUnicodeBytes : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeBytes;
            char minValue = this.useFallback ? (char)'\u0800' : '\u0c00';
            int c = this.fromUChar32;
            int sourceIndex = c == 0 ? 0 : -1;
            int lastSource = sourceArrayIndex;
            int length = source.limit() - sourceArrayIndex;
            if (length < targetCapacity) {
                targetCapacity = length;
            }
            boolean doloop = true;
            if (c != 0 && targetCapacity > 0) {
                x = new SideEffectsSingleBMP(c, sourceArrayIndex);
                doloop = this.getTrailSingleBMP(source, x, cr);
                c = x.c;
                sourceArrayIndex = x.sourceArrayIndex;
            }
            if (doloop) {
                while (targetCapacity > 0) {
                    char value;
                    if ((value = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, c = (int)source.get(sourceArrayIndex++))) >= minValue) {
                        target.put((byte)value);
                        --targetCapacity;
                        c = 0;
                        continue;
                    }
                    if (UTF16.isSurrogate((char)((char)c))) {
                        if (UTF16.isLeadSurrogate((char)((char)c))) {
                            x = new SideEffectsSingleBMP(c, sourceArrayIndex);
                            doloop = this.getTrailSingleBMP(source, x, cr);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            if (!doloop) {
                                break;
                            }
                        } else {
                            cr[0] = CoderResult.malformedForLength(1);
                            break;
                        }
                    }
                    length = UTF16.getCharCount((int)c);
                    if (offsets != null) {
                        int count = sourceArrayIndex - lastSource;
                        count -= length;
                        while (count > 0) {
                            offsets.put(sourceIndex++);
                            --count;
                        }
                    }
                    lastSource = sourceArrayIndex;
                    source.position(sourceArrayIndex);
                    c = this.fromU(c, source, target, offsets, sourceIndex, flush, cr);
                    sourceArrayIndex = source.position();
                    sourceIndex += length + (sourceArrayIndex - lastSource);
                    lastSource = sourceArrayIndex;
                    if (cr[0].isError()) break;
                    targetCapacity = target.remaining();
                    length = source.limit() - sourceArrayIndex;
                    if (length >= targetCapacity) continue;
                    targetCapacity = length;
                }
            }
            if (sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr[0] = CoderResult.OVERFLOW;
            }
            if (offsets != null) {
                for (int count = sourceArrayIndex - lastSource; count > 0; --count) {
                    offsets.put(sourceIndex++);
                }
            }
            this.fromUChar32 = c;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        private CoderResult cnvMBCSSingleFromUnicodeWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            SideEffectsDouble x;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            char[] table = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeTable;
            byte[] results = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLFromUnicodeBytes : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeBytes;
            char minValue = this.useFallback ? (char)'\u0800' : '\u0c00';
            short unicodeMask = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.unicodeMask;
            int c = this.fromUChar32;
            int sourceIndex = c == 0 ? 0 : -1;
            int nextSourceIndex = 0;
            boolean doloop = true;
            boolean doread = true;
            if (c != 0 && target.hasRemaining()) {
                if (UTF16.isLeadSurrogate((char)((char)c))) {
                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                    doloop = this.getTrailDouble(source, target, unicodeMask, x, flush, cr);
                    doread = x.doread;
                    c = x.c;
                    sourceArrayIndex = x.sourceArrayIndex;
                    sourceIndex = x.sourceIndex;
                    nextSourceIndex = x.nextSourceIndex;
                } else {
                    doread = false;
                }
            }
            if (doloop) {
                while (!doread || sourceArrayIndex < source.limit()) {
                    if (target.hasRemaining()) {
                        char value;
                        if (doread) {
                            c = source.get(sourceArrayIndex++);
                            ++nextSourceIndex;
                            if (UTF16.isSurrogate((char)((char)c))) {
                                if (UTF16.isLeadSurrogate((char)((char)c))) {
                                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                                    doloop = this.getTrailDouble(source, target, unicodeMask, x, flush, cr);
                                    c = x.c;
                                    sourceArrayIndex = x.sourceArrayIndex;
                                    sourceIndex = x.sourceIndex;
                                    nextSourceIndex = x.nextSourceIndex;
                                    if (x.doread) {
                                        if (!doloop) break;
                                        continue;
                                    }
                                } else {
                                    cr[0] = CoderResult.malformedForLength(1);
                                    break;
                                }
                            }
                        } else {
                            doread = true;
                        }
                        if ((value = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, c)) >= minValue) {
                            target.put((byte)value);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            c = 0;
                            sourceIndex = nextSourceIndex;
                            continue;
                        }
                        x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                        doloop = this.unassignedDouble(source, target, x, flush, cr);
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        sourceIndex = x.sourceIndex;
                        nextSourceIndex = x.nextSourceIndex;
                        if (doloop) continue;
                        break;
                    }
                    cr[0] = CoderResult.OVERFLOW;
                    break;
                }
            }
            this.fromUChar32 = c;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        private CoderResult cnvMBCSDoubleFromUnicodeWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            SideEffectsDouble x;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            short unicodeMask = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.unicodeMask;
            int sourceArrayIndex = source.position();
            char[] table = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeTable;
            byte[] bytes = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLFromUnicodeBytes : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.fromUnicodeBytes;
            int c = this.fromUChar32;
            int sourceIndex = c == 0 ? 0 : -1;
            int nextSourceIndex = 0;
            boolean doloop = true;
            boolean doread = true;
            if (c != 0 && target.hasRemaining()) {
                if (UTF16.isLeadSurrogate((char)((char)c))) {
                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                    doloop = this.getTrailDouble(source, target, unicodeMask, x, flush, cr);
                    doread = x.doread;
                    c = x.c;
                    sourceArrayIndex = x.sourceArrayIndex;
                    sourceIndex = x.sourceIndex;
                    nextSourceIndex = x.nextSourceIndex;
                } else {
                    doread = false;
                }
            }
            if (doloop) {
                while (!doread || sourceArrayIndex < source.limit()) {
                    if (target.hasRemaining()) {
                        int stage2Entry;
                        char value;
                        if (doread) {
                            c = source.get(sourceArrayIndex++);
                            ++nextSourceIndex;
                            if (UTF16.isSurrogate((char)((char)c)) && (unicodeMask & 2) == 0) {
                                if (UTF16.isLeadSurrogate((char)((char)c))) {
                                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                                    doloop = this.getTrailDouble(source, target, unicodeMask, x, flush, cr);
                                    c = x.c;
                                    sourceArrayIndex = x.sourceArrayIndex;
                                    sourceIndex = x.sourceIndex;
                                    nextSourceIndex = x.nextSourceIndex;
                                    if (x.doread) {
                                        if (!doloop) break;
                                        continue;
                                    }
                                } else {
                                    cr[0] = CoderResult.malformedForLength(1);
                                    break;
                                }
                            }
                        } else {
                            doread = true;
                        }
                        int length = ((long)(value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, c), c)) & 0xFFFFFFFFL) <= 255L ? 1 : 2;
                        if (!(CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) || this.isFromUUseFallback(c) && value != '\u0000')) {
                            x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                            doloop = this.unassignedDouble(source, target, x, flush, cr);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            sourceIndex = x.sourceIndex;
                            nextSourceIndex = x.nextSourceIndex;
                            if (!doloop) break;
                            continue;
                        }
                        if (length == 1) {
                            target.put((byte)value);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                        } else {
                            target.put((byte)(value >>> 8));
                            if (2 <= target.remaining()) {
                                target.put((byte)value);
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                    offsets.put(sourceIndex);
                                }
                            } else {
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                }
                                this.errorBuffer[0] = (byte)value;
                                this.errorBufferLength = 1;
                                cr[0] = CoderResult.OVERFLOW;
                                c = 0;
                                break;
                            }
                        }
                        c = 0;
                        sourceIndex = nextSourceIndex;
                        continue;
                    }
                    cr[0] = CoderResult.OVERFLOW;
                    break;
                }
            }
            this.fromUChar32 = c;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private final boolean getTrailSingleBMP(CharBuffer source, SideEffectsSingleBMP x, CoderResult[] cr) {
            if (x.sourceArrayIndex < source.limit()) {
                char trail = source.get(x.sourceArrayIndex);
                if (UTF16.isTrailSurrogate((char)trail)) {
                    ++x.sourceArrayIndex;
                    x.c = UCharacter.getCodePoint((char)((char)x.c), (char)trail);
                    cr[0] = CoderResult.unmappableForLength(2);
                    return false;
                }
                cr[0] = CoderResult.malformedForLength(2);
                return false;
            }
            return false;
        }

        private final boolean getTrail(CharBuffer source, ByteBuffer target, int unicodeMask, SideEffects x, boolean flush, CoderResult[] cr) {
            if (x.sourceArrayIndex < source.limit()) {
                char trail = source.get(x.sourceArrayIndex);
                if (UTF16.isTrailSurrogate((char)trail)) {
                    ++x.sourceArrayIndex;
                    ++x.nextSourceIndex;
                    x.c = UCharacter.getCodePoint((char)((char)x.c), (char)trail);
                    if ((unicodeMask & 1) == 0) {
                        this.fromUnicodeStatus = x.prevLength;
                        x.doread = true;
                        return this.unassigned(source, target, null, x, flush, cr);
                    }
                    x.doread = false;
                    return true;
                }
                cr[0] = CoderResult.malformedForLength(2);
                return false;
            }
            return false;
        }

        private final boolean unassigned(CharBuffer source, ByteBuffer target, IntBuffer offsets, SideEffects x, boolean flush, CoderResult[] cr) {
            int sourceBegin = x.sourceArrayIndex;
            source.position(x.sourceArrayIndex);
            x.c = this.fromU(x.c, source, target, null, x.sourceIndex, flush, cr);
            x.sourceArrayIndex = source.position();
            x.nextSourceIndex += x.sourceArrayIndex - sourceBegin;
            x.prevLength = this.fromUnicodeStatus;
            if (cr[0].isError()) {
                return false;
            }
            if (offsets != null) {
                x.prevSourceIndex = x.sourceIndex;
                x.sourceIndex = x.nextSourceIndex;
            }
            return true;
        }

        private final boolean getTrailDouble(CharBuffer source, ByteBuffer target, int unicodeMask, SideEffectsDouble x, boolean flush, CoderResult[] cr) {
            if (x.sourceArrayIndex < source.limit()) {
                char trail = source.get(x.sourceArrayIndex);
                if (UTF16.isTrailSurrogate((char)trail)) {
                    ++x.sourceArrayIndex;
                    ++x.nextSourceIndex;
                    x.c = UCharacter.getCodePoint((char)((char)x.c), (char)trail);
                    if ((unicodeMask & 1) == 0) {
                        x.doread = true;
                        return this.unassignedDouble(source, target, x, flush, cr);
                    }
                    x.doread = false;
                    return true;
                }
                cr[0] = CoderResult.malformedForLength(2);
                return false;
            }
            return false;
        }

        private final boolean unassignedDouble(CharBuffer source, ByteBuffer target, SideEffectsDouble x, boolean flush, CoderResult[] cr) {
            int sourceBegin = x.sourceArrayIndex;
            source.position(x.sourceArrayIndex);
            x.c = this.fromU(x.c, source, target, null, x.sourceIndex, flush, cr);
            x.sourceArrayIndex = source.position();
            x.nextSourceIndex += x.sourceArrayIndex - sourceBegin;
            if (cr[0].isError()) {
                return false;
            }
            x.sourceIndex = x.nextSourceIndex;
            return true;
        }

        protected CoderResult cbFromUWriteSub(CharsetEncoderICU encoder, CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            int length;
            byte[] subchar;
            CharsetMBCS cs = (CharsetMBCS)encoder.charset();
            if (cs.subChar1 != 0 && (((CharsetMBCS)cs).sharedData.mbcs.extIndexes != null ? encoder.useSubChar1 : encoder.invalidUCharBuffer[0] <= '\u00ff')) {
                subchar = new byte[]{cs.subChar1};
                length = 1;
            } else {
                subchar = cs.subChar;
                length = cs.subCharLen;
            }
            encoder.useSubChar1 = false;
            if (((CharsetMBCS)cs).sharedData.mbcs.outputType == 12) {
                byte[] buffer = new byte[4];
                int i = 0;
                switch (length) {
                    case 1: {
                        if (encoder.fromUnicodeStatus == 2) {
                            encoder.fromUnicodeStatus = 1;
                            buffer[i++] = 15;
                        }
                        buffer[i++] = subchar[0];
                        break;
                    }
                    case 2: {
                        if (encoder.fromUnicodeStatus <= 1) {
                            encoder.fromUnicodeStatus = 2;
                            buffer[i++] = 14;
                        }
                        buffer[i++] = subchar[0];
                        buffer[i++] = subchar[1];
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                subchar = buffer;
                length = i;
            }
            return CharsetEncoderICU.fromUWriteBytes(encoder, subchar, 0, length, target, offsets, source.position());
        }

        protected void implReplaceWith(byte[] replacement) {
            if (this.allowReplacementChanges) {
                CharsetMBCS cs = (CharsetMBCS)this.charset();
                System.arraycopy(replacement, 0, cs.subChar, 0, replacement.length);
                cs.subCharLen = (byte)replacement.length;
                cs.subChar1 = 0;
            }
        }

        private final class SideEffectsDouble {
            int c;
            int sourceArrayIndex;
            int sourceIndex;
            int nextSourceIndex;
            boolean doread = true;

            SideEffectsDouble(int c_, int sourceArrayIndex_, int sourceIndex_, int nextSourceIndex_) {
                this.c = c_;
                this.sourceArrayIndex = sourceArrayIndex_;
                this.sourceIndex = sourceIndex_;
                this.nextSourceIndex = nextSourceIndex_;
            }
        }

        private final class SideEffects {
            int c;
            int sourceArrayIndex;
            int sourceIndex;
            int nextSourceIndex;
            int prevSourceIndex;
            int prevLength;
            boolean doread = true;

            SideEffects(int c_, int sourceArrayIndex_, int sourceIndex_, int nextSourceIndex_, int prevSourceIndex_, int prevLength_) {
                this.c = c_;
                this.sourceArrayIndex = sourceArrayIndex_;
                this.sourceIndex = sourceIndex_;
                this.nextSourceIndex = nextSourceIndex_;
                this.prevSourceIndex = prevSourceIndex_;
                this.prevLength = prevLength_;
            }
        }

        private final class SideEffectsSingleBMP {
            int c;
            int sourceArrayIndex;

            SideEffectsSingleBMP(int c_, int sourceArrayIndex_) {
                this.c = c_;
                this.sourceArrayIndex = sourceArrayIndex_;
            }
        }
    }

    class CharsetDecoderMBCS
    extends CharsetDecoderICU {
        CharsetDecoderMBCS(CharsetICU cs) {
            super(cs);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int entry = 0;
            if (this.preToULength > 0) {
                cr[0] = this.continueMatchToU(source, target, offsets, -1, flush);
                if (cr[0].isError()) return cr[0];
                if (this.preToULength < 0) {
                    return cr[0];
                }
            }
            if (((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.countStates == 1) {
                if ((((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.unicodeMask & 1) == 0) {
                    cr[0] = this.cnvMBCSSingleToBMPWithOffsets(source, target, offsets, flush);
                    return cr[0];
                }
                cr[0] = this.cnvMBCSSingleToUnicodeWithOffsets(source, target, offsets, flush);
                return cr[0];
            }
            int sourceArrayIndex = source.position();
            int[][] stateTable = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLStateTable : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.stateTable;
            char[] unicodeCodeUnits = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.unicodeCodeUnits;
            int offset = this.toUnicodeStatus;
            int byteIndex = this.toULength;
            byte[] bytes = this.toUBytesArray;
            byte state = (byte)this.mode;
            if (state == 0) {
                state = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.dbcsOnlyState;
            }
            int sourceIndex = byteIndex == 0 ? 0 : -1;
            int nextSourceIndex = 0;
            while (sourceArrayIndex < source.limit()) {
                block50: {
                    byte action;
                    block61: {
                        char c;
                        block58: {
                            block60: {
                                block59: {
                                    block57: {
                                        block55: {
                                            block56: {
                                                block54: {
                                                    block49: {
                                                        block52: {
                                                            block53: {
                                                                block51: {
                                                                    if (!target.hasRemaining()) {
                                                                        cr[0] = CoderResult.OVERFLOW;
                                                                        break;
                                                                    }
                                                                    if (byteIndex != 0) break block51;
                                                                    if (offsets != null) break block52;
                                                                    break block53;
                                                                }
                                                                ++nextSourceIndex;
                                                                int n = byteIndex++;
                                                                byte by = source.get(sourceArrayIndex++);
                                                                bytes[n] = by;
                                                                entry = stateTable[state][by & 0xFF];
                                                                break block54;
                                                            }
                                                            do {
                                                                if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][source.get(sourceArrayIndex) & 0xFF])) {
                                                                    state = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                                    offset = CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                                    if (++sourceArrayIndex < source.limit() && CharsetMBCS.MBCS_ENTRY_IS_FINAL(entry = stateTable[state][source.get(sourceArrayIndex) & 0xFF]) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 4 && (c = unicodeCodeUnits[offset + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)]) < '\ufffe') {
                                                                        ++sourceArrayIndex;
                                                                        target.put(c);
                                                                        state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                                        offset = 0;
                                                                        continue;
                                                                    }
                                                                    bytes[0] = source.get(sourceArrayIndex - 1);
                                                                    byteIndex = 1;
                                                                    break block49;
                                                                }
                                                                if (!CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry)) break block49;
                                                                ++sourceArrayIndex;
                                                                target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                                                                state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                            } while (sourceArrayIndex < source.limit() && target.hasRemaining());
                                                            break block49;
                                                        }
                                                        do {
                                                            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][source.get(sourceArrayIndex)])) {
                                                                state = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                                offset = CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                                if (++sourceArrayIndex < source.limit() && CharsetMBCS.MBCS_ENTRY_IS_FINAL(entry = stateTable[state][source.get(sourceArrayIndex)]) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 4 && (c = unicodeCodeUnits[offset + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)]) < '\ufffe') {
                                                                    ++sourceArrayIndex;
                                                                    target.put(c);
                                                                    if (offsets != null) {
                                                                        offsets.put(sourceIndex);
                                                                        sourceIndex = nextSourceIndex += 2;
                                                                    }
                                                                    state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                                    offset = 0;
                                                                    continue;
                                                                }
                                                                ++nextSourceIndex;
                                                                bytes[0] = source.get(sourceArrayIndex - 1);
                                                                byteIndex = 1;
                                                                break;
                                                            }
                                                            if (!CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry)) break;
                                                            ++sourceArrayIndex;
                                                            target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                                                            if (offsets != null) {
                                                                offsets.put(sourceIndex);
                                                                sourceIndex = ++nextSourceIndex;
                                                            }
                                                            state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                        } while (sourceArrayIndex < source.limit() && target.hasRemaining());
                                                    }
                                                    if (sourceArrayIndex >= source.limit()) break;
                                                    if (!target.hasRemaining()) {
                                                        cr[0] = CoderResult.OVERFLOW;
                                                        break;
                                                    }
                                                    ++nextSourceIndex;
                                                    bytes[byteIndex++] = source.get(sourceArrayIndex++);
                                                }
                                                if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry)) {
                                                    state = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                    offset += CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                    continue;
                                                }
                                                this.mode = state;
                                                state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                action = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                                                if (action != 4) break block55;
                                                c = unicodeCodeUnits[offset += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)];
                                                if (c >= '\ufffe') break block56;
                                                target.put(c);
                                                if (offsets != null) {
                                                    offsets.put(sourceIndex);
                                                }
                                                byteIndex = 0;
                                                break block50;
                                            }
                                            if (c == '\ufffe') {
                                                if (this.isFallbackUsed() && (entry = this.getFallback(((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs, offset)) != 65534) {
                                                    target.put((char)entry);
                                                    if (offsets != null) {
                                                        offsets.put(sourceIndex);
                                                    }
                                                    byteIndex = 0;
                                                }
                                                break block50;
                                            } else {
                                                cr[0] = CoderResult.malformedForLength(byteIndex);
                                            }
                                            break block50;
                                        }
                                        if (action != 0) break block57;
                                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                        byteIndex = 0;
                                        break block50;
                                    }
                                    if (action != 5) break block58;
                                    offset += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                                    if ((c = unicodeCodeUnits[offset++]) >= '\ud800') break block59;
                                    target.put(c);
                                    if (offsets != null) {
                                        offsets.put(sourceIndex);
                                    }
                                    byteIndex = 0;
                                    break block50;
                                }
                                if (!(this.isFallbackUsed() ? c <= '\udfff' : c <= '\udbff')) break block60;
                                target.put((char)(c & 0xDBFF));
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                }
                                byteIndex = 0;
                                if (target.hasRemaining()) {
                                    target.put(unicodeCodeUnits[offset]);
                                    if (offsets != null) {
                                        offsets.put(sourceIndex);
                                    }
                                    break block50;
                                } else {
                                    this.charErrorBufferArray[0] = unicodeCodeUnits[offset];
                                    this.charErrorBufferLength = 1;
                                    cr[0] = CoderResult.OVERFLOW;
                                    offset = 0;
                                    break;
                                }
                            }
                            if (this.isFallbackUsed() ? (c & 0xFFFE) == 57344 : c == '\ue000') {
                                target.put(unicodeCodeUnits[offset]);
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                }
                                byteIndex = 0;
                                break block50;
                            } else if (c == '\uffff') {
                                cr[0] = CoderResult.malformedForLength(byteIndex);
                            }
                            break block50;
                        }
                        if (action != 1 && (action != 3 || !this.isFallbackUsed())) break block61;
                        entry = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry);
                        target.put((char)(0xD800 | (char)(entry >> 10)));
                        if (offsets != null) {
                            offsets.put(sourceIndex);
                        }
                        byteIndex = 0;
                        c = (char)(0xDC00 | (char)(entry & 0x3FF));
                        if (target.hasRemaining()) {
                            target.put(c);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            break block50;
                        } else {
                            this.charErrorBufferArray[0] = c;
                            this.charErrorBufferLength = 1;
                            cr[0] = CoderResult.OVERFLOW;
                            offset = 0;
                            break;
                        }
                    }
                    if (action == 8) {
                        if (((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.dbcsOnlyState == 0) {
                            byteIndex = 0;
                        } else {
                            state = (byte)this.mode;
                            cr[0] = CoderResult.malformedForLength(byteIndex);
                        }
                    } else if (action == 2) {
                        if (this.isFallbackUsed()) {
                            target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            byteIndex = 0;
                        }
                    } else if (action != 6) {
                        if (action == 7) {
                            cr[0] = CoderResult.malformedForLength(byteIndex);
                        } else {
                            byteIndex = 0;
                        }
                    }
                }
                offset = 0;
                if (byteIndex == 0) {
                    sourceIndex = nextSourceIndex;
                    continue;
                }
                if (cr[0].isError()) break;
                int sourceBeginIndex = sourceArrayIndex;
                source.position(sourceArrayIndex);
                byteIndex = this.toU(byteIndex, source, target, offsets, sourceIndex, flush, cr);
                sourceArrayIndex = source.position();
                sourceIndex = nextSourceIndex + (sourceArrayIndex - sourceBeginIndex);
                if (!cr[0].isError() && !cr[0].isOverflow()) continue;
            }
            this.toUnicodeStatus = offset;
            this.mode = state;
            this.toULength = byteIndex;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private CoderResult continueMatchToU(ByteBuffer source, CharBuffer target, IntBuffer offsets, int srcIndex, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int[] value = new int[1];
            int match = this.matchToU((byte)CharsetMBCS.SISO_STATE(CharsetMBCS.this.sharedData, this.mode), this.preToUArray, this.preToUBegin, this.preToULength, source, value, flush);
            if (match > 0) {
                if (match >= this.preToULength) {
                    source.position(source.position() + match - this.preToULength);
                    this.preToULength = 0;
                } else {
                    int length = this.preToULength - match;
                    System.arraycopy(this.preToUArray, this.preToUBegin + match, this.preToUArray, this.preToUBegin, length);
                    this.preToULength = (byte)(-length);
                }
                cr = this.writeToU(value[0], target, offsets, srcIndex);
            } else if (match < 0) {
                int sArrayIndex = source.position();
                match = -match;
                for (int j = this.preToULength; j < match; ++j) {
                    this.preToUArray[j] = source.get(sArrayIndex++);
                }
                source.position(sArrayIndex);
                this.preToULength = (byte)match;
            } else {
                System.arraycopy(this.preToUArray, this.preToUBegin, this.toUBytesArray, this.toUBytesBegin, this.preToUFirstLength);
                this.toULength = this.preToUFirstLength;
                int length = this.preToULength - this.preToUFirstLength;
                if (length > 0) {
                    System.arraycopy(this.preToUArray, this.preToUBegin + this.preToUFirstLength, this.preToUArray, this.preToUBegin, length);
                }
                this.preToULength = (byte)(-length);
                cr = CoderResult.unmappableForLength(this.preToUFirstLength);
            }
            return cr;
        }

        private int matchToU(byte sisoState, byte[] preArray, int preArrayBegin, int preLength, ByteBuffer source, int[] pMatchValue, boolean flush) {
            int matchLength;
            int matchValue;
            block14: {
                int value;
                ByteBuffer cx = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.extIndexes;
                if (cx == null || cx.asIntBuffer().get(2) <= 0) {
                    return 0;
                }
                IntBuffer toUTable = (IntBuffer)CharsetMBCS.ARRAY(cx, 1, Integer.TYPE);
                int index = 0;
                matchValue = 0;
                matchLength = 0;
                int j = 0;
                int i = 0;
                int srcLength = source.remaining();
                if (sisoState == 0) {
                    if (preLength > 1) {
                        return 0;
                    }
                    if (preLength == 1) {
                        srcLength = 0;
                    } else if (srcLength > 1) {
                        srcLength = 1;
                    }
                    flush = true;
                }
                while (true) {
                    short b;
                    int oldpos = toUTable.position();
                    IntBuffer toUSection = ((IntBuffer)toUTable.position(index)).slice();
                    toUTable.position(oldpos);
                    value = toUSection.get();
                    int length = CharsetMBCS.TO_U_GET_BYTE(value);
                    value = CharsetMBCS.TO_U_GET_VALUE(value);
                    if (value != 0 && (CharsetMBCS.TO_U_IS_ROUNDTRIP(value) || this.isFallbackUsed()) && CharsetMBCS.TO_U_VERIFY_SISO_MATCH(sisoState, i + j)) {
                        matchValue = value;
                        matchLength = i + j;
                    }
                    if (i < preLength) {
                        b = (short)(preArray[preArrayBegin + i++] & 0xFF);
                    } else {
                        if (j >= srcLength) {
                            if (!flush && (length = i + j) <= 31) {
                                return -length;
                            }
                            break block14;
                        }
                        b = (short)(source.get(source.position() + j++) & 0xFF);
                    }
                    value = CharsetMBCS.findToU(toUSection, length, b);
                    if (value == 0) break block14;
                    if (!CharsetMBCS.TO_U_IS_PARTIAL(value)) break;
                    index = CharsetMBCS.TO_U_GET_PARTIAL_INDEX(value);
                }
                if ((CharsetMBCS.TO_U_IS_ROUNDTRIP(value) || this.isFallbackUsed()) && CharsetMBCS.TO_U_VERIFY_SISO_MATCH(sisoState, i + j)) {
                    matchValue = value;
                    matchLength = i + j;
                }
            }
            if (matchLength == 0) {
                return 0;
            }
            pMatchValue[0] = CharsetMBCS.TO_U_MASK_ROUNDTRIP(matchValue);
            return matchLength;
        }

        private CoderResult writeToU(int value, CharBuffer target, IntBuffer offsets, int srcIndex) {
            ByteBuffer cx = ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.extIndexes;
            if (CharsetMBCS.TO_U_IS_CODE_POINT(value)) {
                return this.toUWriteCodePoint(CharsetMBCS.TO_U_GET_CODE_POINT(value), target, offsets, srcIndex);
            }
            char[] a = new char[CharsetMBCS.TO_U_GET_LENGTH(value)];
            CharBuffer cb = (CharBuffer)CharsetMBCS.ARRAY(cx, 3, Character.TYPE);
            cb.position(CharsetMBCS.TO_U_GET_INDEX(value));
            cb.get(a, 0, a.length);
            return CharsetDecoderMBCS.toUWriteUChars(this, a, 0, a.length, target, offsets, srcIndex);
        }

        private CoderResult toUWriteCodePoint(int c, CharBuffer target, IntBuffer offsets, int sourceIndex) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int tBeginIndex = target.position();
            if (target.hasRemaining()) {
                if (c <= 65535) {
                    target.put((char)c);
                    c = -1;
                } else {
                    target.put(UTF16.getLeadSurrogate((int)c));
                    c = UTF16.getTrailSurrogate((int)c);
                    if (target.hasRemaining()) {
                        target.put((char)c);
                        c = -1;
                    }
                }
                if (offsets != null) {
                    offsets.put(sourceIndex);
                    if (tBeginIndex + 1 < target.position()) {
                        offsets.put(sourceIndex);
                    }
                }
            }
            if (c >= 0) {
                this.charErrorBufferLength = UTF16.append((char[])this.charErrorBufferArray, (int)0, (int)c);
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }

        private int toU(int length, ByteBuffer source, CharBuffer target, IntBuffer offsets, int sourceIndex, boolean flush, CoderResult[] cr) {
            if (((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.extIndexes != null && this.initialMatchToU(length, source, target, offsets, sourceIndex, flush, cr)) {
                return 0;
            }
            if (length == 4 && (CharsetMBCS.this.options & 0x8000) != 0) {
                long linear = CharsetMBCS.LINEAR_18030(this.toUBytesArray[0], this.toUBytesArray[1], this.toUBytesArray[2], this.toUBytesArray[3]);
                for (int i = 0; i < gb18030Ranges.length; ++i) {
                    long[] range = gb18030Ranges[i];
                    if (range[2] > linear || linear > range[3]) continue;
                    cr[0] = CoderResult.UNDERFLOW;
                    linear = range[0] + (linear - range[2]);
                    cr[0] = this.toUWriteCodePoint((int)linear, target, offsets, sourceIndex);
                    return 0;
                }
            }
            cr[0] = CoderResult.unmappableForLength(length);
            return length;
        }

        private boolean initialMatchToU(int firstLength, ByteBuffer source, CharBuffer target, IntBuffer offsets, int srcIndex, boolean flush, CoderResult[] cr) {
            int[] value = new int[1];
            int match = 0;
            match = this.matchToU((byte)CharsetMBCS.SISO_STATE(CharsetMBCS.this.sharedData, this.mode), this.toUBytesArray, this.toUBytesBegin, firstLength, source, value, flush);
            if (match > 0) {
                source.position(source.position() + match - firstLength);
                cr[0] = this.writeToU(value[0], target, offsets, srcIndex);
                return true;
            }
            if (match < 0) {
                int j;
                byte[] sArray = this.toUBytesArray;
                int sArrayIndex = this.toUBytesBegin;
                this.preToUFirstLength = (byte)firstLength;
                for (j = 0; j < firstLength; ++j) {
                    this.preToUArray[j] = sArray[sArrayIndex++];
                }
                sArrayIndex = source.position();
                match = -match;
                while (j < match) {
                    this.preToUArray[j] = source.get(sArrayIndex++);
                    ++j;
                }
                source.position(sArrayIndex);
                this.preToULength = (byte)match;
                return true;
            }
            return false;
        }

        private CoderResult cnvMBCSSingleToBMPWithOffsets(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            int count;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            int targetCapacity = target.remaining();
            int[][] stateTable = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLStateTable : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.stateTable;
            int sourceIndex = 0;
            int lastSource = sourceArrayIndex;
            int length = source.remaining();
            if (length < targetCapacity) {
                targetCapacity = length;
            }
            while (targetCapacity > 0) {
                int entry;
                if (CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry = stateTable[0][source.get(sourceArrayIndex++) & 0xFF])) {
                    target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                    --targetCapacity;
                    continue;
                }
                byte action = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                if (action == 2) {
                    if (this.isFallbackUsed()) {
                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                        --targetCapacity;
                        continue;
                    }
                } else if (action != 6) {
                    if (action != 7) continue;
                    cr[0] = CoderResult.malformedForLength(sourceArrayIndex - lastSource);
                }
                if (offsets != null) {
                    count = sourceArrayIndex - lastSource;
                    while (--count > 0) {
                        offsets.put(sourceIndex++);
                    }
                }
                if (cr[0].isError()) break;
                lastSource = sourceArrayIndex;
                this.toUBytesArray[0] = source.get(sourceArrayIndex - 1);
                source.position(sourceArrayIndex);
                this.toULength = this.toU(1, source, target, offsets, sourceIndex, flush, cr);
                sourceArrayIndex = source.position();
                sourceIndex += 1 + (sourceArrayIndex - lastSource);
                if (cr[0].isError()) break;
                targetCapacity = target.remaining();
                length = source.remaining();
                if (length >= targetCapacity) continue;
                targetCapacity = length;
            }
            if (!cr[0].isError() && sourceArrayIndex < source.capacity() && !target.hasRemaining()) {
                cr[0] = CoderResult.OVERFLOW;
            }
            if (offsets != null) {
                for (count = sourceArrayIndex - lastSource; count > 0; --count) {
                    offsets.put(sourceIndex++);
                }
            }
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private CoderResult cnvMBCSSingleToUnicodeWithOffsets(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            int[][] stateTable = (CharsetMBCS.this.options & 0x10) != 0 ? ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.swapLFNLStateTable : ((CharsetMBCS)CharsetMBCS.this).sharedData.mbcs.stateTable;
            int sourceIndex = 0;
            while (sourceArrayIndex < source.limit()) {
                int entry;
                if (!target.hasRemaining()) {
                    cr[0] = CoderResult.OVERFLOW;
                    break;
                }
                if (CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry = stateTable[0][source.get(sourceArrayIndex++) & 0xFF])) {
                    target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                    if (offsets != null) {
                        offsets.put(sourceIndex);
                    }
                    ++sourceIndex;
                    continue;
                }
                byte action = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                if (action == 1 || action == 3 && this.isFallbackUsed()) {
                    entry = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry);
                    target.put((char)(0xD800 | (char)(entry >>> 10)));
                    if (offsets != null) {
                        offsets.put(sourceIndex);
                    }
                    char c = (char)(0xDC00 | (char)(entry & 0x3FF));
                    if (target.hasRemaining()) {
                        target.put(c);
                        if (offsets != null) {
                            offsets.put(sourceIndex);
                        }
                    } else {
                        this.charErrorBufferArray[0] = c;
                        this.charErrorBufferLength = 1;
                        cr[0] = CoderResult.OVERFLOW;
                        break;
                    }
                    ++sourceIndex;
                    continue;
                }
                if (action == 2) {
                    if (this.isFallbackUsed()) {
                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                        if (offsets != null) {
                            offsets.put(sourceIndex);
                        }
                        ++sourceIndex;
                        continue;
                    }
                } else if (action != 6) {
                    if (action == 7) {
                        cr[0] = CoderResult.malformedForLength(1);
                    } else {
                        ++sourceIndex;
                        continue;
                    }
                }
                if (cr[0].isError()) break;
                int sourceBeginIndex = sourceArrayIndex;
                this.toUBytesArray[0] = source.get(sourceArrayIndex - 1);
                source.position(sourceArrayIndex);
                this.toULength = this.toU(1, source, target, offsets, sourceIndex, flush, cr);
                sourceArrayIndex = source.position();
                sourceIndex += 1 + (sourceArrayIndex - sourceBeginIndex);
                if (!cr[0].isError()) continue;
                break;
            }
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private int getFallback(UConverterMBCSTable mbcsTable, int offset) {
            int limit = mbcsTable.countToUFallbacks;
            if (limit > 0) {
                MBCSToUFallback[] toUFallbacks = mbcsTable.toUFallbacks;
                int start = 0;
                while (start < limit - 1) {
                    int i = (start + limit) / 2;
                    if (offset < toUFallbacks[i].offset) {
                        limit = i;
                        continue;
                    }
                    start = i;
                }
                if (offset == toUFallbacks[start].offset) {
                    return toUFallbacks[start].codePoint;
                }
            }
            return 65534;
        }
    }

    class LoadArguments {
        int nestedLoads;
        String name;
        String classPath;
        ClassLoader loader;

        LoadArguments(int nestedLoads, String name, String classPath, ClassLoader loader) {
            this.nestedLoads = nestedLoads;
            this.name = name;
            this.loader = loader;
            this.classPath = classPath;
        }
    }

    final class MBCSHeader {
        byte[] version = new byte[4];
        int countStates;
        int countToUFallbacks;
        int offsetToUCodeUnits;
        int offsetFromUTable;
        int offsetFromUBytes;
        int flags;
        int fromUBytesLength;

        MBCSHeader() {
        }
    }

    static final class UConverterMBCSTable {
        short countStates;
        byte dbcsOnlyState;
        boolean stateTableOwned;
        int countToUFallbacks;
        int[][] stateTable;
        int[][] swapLFNLStateTable;
        char[] unicodeCodeUnits;
        MBCSToUFallback[] toUFallbacks;
        char[] fromUnicodeTable;
        byte[] fromUnicodeBytes;
        byte[] swapLFNLFromUnicodeBytes;
        int fromUBytesLength;
        short outputType;
        short unicodeMask;
        String swapLFNLName;
        UConverterSharedData baseSharedData;
        ByteBuffer extIndexes;

        UConverterMBCSTable() {
        }
    }

    final class MBCSToUFallback {
        int offset;
        int codePoint;

        MBCSToUFallback() {
        }
    }
}

