/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser.format;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AddressField {
    STATE('S', "state"),
    CITY('C', "city"),
    RECIPIENT('N', "name"),
    ORGANIZATION('O', "organization"),
    ADDRESS_LINE_1('1', "street1"),
    ADDRESS_LINE_2('2', "street2"),
    DEPENDENT_LOCALITY('D', "dependent locality"),
    ZIP('Z', "postcode"),
    SORTING_CODE('X', "sorting code"),
    STREET_ADDRESS('A', "street address"),
    COUNTRY('R', "country");

    private static final Map<Character, AddressField> FIELD_MAPPING;
    private final char mField;
    private final String mAttributeName;

    private AddressField(char field, String attributeName) {
        this.mField = field;
        this.mAttributeName = attributeName;
    }

    private AddressField(char field) {
        this(field, null);
    }

    public static AddressField of(char field) {
        return FIELD_MAPPING.get(Character.valueOf(field));
    }

    public String getAttributeName() {
        return this.mAttributeName;
    }

    public char getChar() {
        return this.mField;
    }

    static {
        FIELD_MAPPING = new HashMap<Character, AddressField>();
        for (AddressField value : AddressField.values()) {
            FIELD_MAPPING.put(Character.valueOf(value.getChar()), value);
        }
    }
}

