/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser;

import com.gisgraphy.addressparser.commons.GeocodingLevels;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="address")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Address
implements Serializable {
    private static final long serialVersionUID = 6185879035945582454L;
    private Long id;
    private Double lng;
    private Double lat;
    private String name;
    private String recipientName;
    private String houseNumber;
    private String houseNumberInfo;
    private String POBox;
    private String POBoxInfo;
    private String POBoxAgency;
    private String civicNumberSuffix;
    private String preDirection;
    private String streetName;
    private String streetType;
    private String postDirection;
    private String preDirectionIntersection;
    private String streetNameIntersection;
    private String StreetTypeIntersection;
    private String postDirectionIntersection;
    private String extraInfo;
    private String suiteType;
    private String suiteNumber;
    private String floor;
    private String quarter;
    private String zipCode;
    private String district;
    private String dependentLocality;
    private String city;
    private String citySubdivision;
    private String postTown;
    private String state;
    private String prefecture;
    private String country;
    private String countryCode;
    private String sector;
    private String quadrant;
    private String block;
    private String lote;
    private GeocodingLevels geocodingLevel = GeocodingLevels.NONE;
    private String confidence;
    private Double distance;
    private Double ward;
    private String adm1Name;
    private String adm2Name;
    private String adm3Name;
    private String adm4Name;
    private String adm5Name;
    private String formatedFull;
    private String formatedPostal;
    private Integer lanes;
    private Boolean toll;
    private String surface;
    private String streetRef;
    private String speedMode;
    private String maxSpeed;
    private String maxSpeedBackward;
    private Integer azimuthStart;
    private Integer azimuthEnd;
    private Double length;
    private Boolean oneWay;
    private Float score;
    private Long sourceId;
    private String county;
    private String PostOfficeBox;

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Double getLength() {
        return this.length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    public Boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(Boolean oneWay) {
        this.oneWay = oneWay;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLng() {
        return this.lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public String getStreetNameIntersection() {
        return this.streetNameIntersection;
    }

    public void setStreetNameIntersection(String streetNameIntersection) {
        this.streetNameIntersection = streetNameIntersection;
    }

    public String getStreetTypeIntersection() {
        return this.StreetTypeIntersection;
    }

    public void setStreetTypeIntersection(String streetTypeIntersection) {
        this.StreetTypeIntersection = streetTypeIntersection;
    }

    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String streetType) {
        this.streetType = streetType;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        if (extraInfo != null && !"".equals(extraInfo.trim())) {
            this.extraInfo = extraInfo;
        }
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCitySubdivision() {
        return this.citySubdivision;
    }

    public void setCitySubdivision(String citySubdivision) {
        this.citySubdivision = citySubdivision;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPrefecture() {
        return this.prefecture;
    }

    public void setPrefecture(String prefecture) {
        this.prefecture = prefecture;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getSector() {
        return this.sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(String quadrant) {
        this.quadrant = quadrant;
    }

    public String getBlock() {
        return this.block;
    }

    public void setBlock(String block) {
        this.block = block;
    }

    public String getHouseNumberInfo() {
        return this.houseNumberInfo;
    }

    public void setHouseNumberInfo(String houseNumberInfo) {
        this.houseNumberInfo = houseNumberInfo;
    }

    public String getPreDirection() {
        return this.preDirection;
    }

    public void setPredirection(String preDirection) {
        this.preDirection = preDirection;
    }

    public String getPostDirection() {
        return this.postDirection;
    }

    public void setPostDirection(String postDirection) {
        this.postDirection = postDirection;
    }

    public String getPreDirectionIntersection() {
        return this.preDirectionIntersection;
    }

    public void setPredirectionIntersection(String preDirectionIntersection) {
        this.preDirectionIntersection = preDirectionIntersection;
    }

    public String getPostDirectionIntersection() {
        return this.postDirectionIntersection;
    }

    public void setPostDirectionIntersection(String postDirectionIntersection) {
        this.postDirectionIntersection = postDirectionIntersection;
    }

    public String getPOBox() {
        return this.POBox;
    }

    public void setPOBox(String pOBox) {
        this.POBox = pOBox;
    }

    public String getCivicNumberSuffix() {
        return this.civicNumberSuffix;
    }

    public void setCivicNumberSuffix(String civicNumberSuffix) {
        this.civicNumberSuffix = civicNumberSuffix;
    }

    public String getPOBoxInfo() {
        return this.POBoxInfo;
    }

    public void setPOBoxInfo(String boxInfo) {
        if (!"".equals(boxInfo)) {
            this.POBoxInfo = boxInfo;
        }
    }

    public void setPreDirection(String preDirection) {
        this.preDirection = preDirection;
    }

    public void setPreDirectionIntersection(String preDirectionIntersection) {
        this.preDirectionIntersection = preDirectionIntersection;
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getPostTown() {
        return this.postTown;
    }

    public void setPostTown(String postTown) {
        this.postTown = postTown;
    }

    public String getDependentLocality() {
        return this.dependentLocality;
    }

    public void setDependentLocality(String dependentLocality) {
        this.dependentLocality = dependentLocality;
    }

    public void setPOBoxAgency(String POBoxAgency) {
        this.POBoxAgency = POBoxAgency;
    }

    public String getPOBoxAgency() {
        return this.POBoxAgency;
    }

    public String getQuarter() {
        return this.quarter;
    }

    public void setQuarter(String quarter) {
        this.quarter = quarter;
    }

    public String getPostOfficeBox() {
        return this.PostOfficeBox;
    }

    public void setPostOfficeBox(String postOfficeBox) {
        this.PostOfficeBox = postOfficeBox;
    }

    public String getAdm1Name() {
        return this.adm1Name;
    }

    public void setAdm1Name(String adm1Name) {
        this.adm1Name = adm1Name;
    }

    public String getAdm2Name() {
        return this.adm2Name;
    }

    public void setAdm2Name(String adm2Name) {
        this.adm2Name = adm2Name;
    }

    public String getAdm3Name() {
        return this.adm3Name;
    }

    public void setAdm3Name(String adm3Name) {
        this.adm3Name = adm3Name;
    }

    public String getAdm4Name() {
        return this.adm4Name;
    }

    public void setAdm4Name(String adm4Name) {
        this.adm4Name = adm4Name;
    }

    public String getAdm5Name() {
        return this.adm5Name;
    }

    public void setAdm5Name(String adm5Name) {
        this.adm5Name = adm5Name;
    }

    public Integer getLanes() {
        return this.lanes;
    }

    public void setLanes(Integer lanes) {
        this.lanes = lanes;
    }

    public Boolean isToll() {
        return this.toll;
    }

    public void setToll(Boolean toll) {
        this.toll = toll;
    }

    public String getSurface() {
        return this.surface;
    }

    public void setSurface(String surface) {
        this.surface = surface;
    }

    public String getSpeedMode() {
        return this.speedMode;
    }

    public void setSpeedMode(String speedMode) {
        this.speedMode = speedMode;
    }

    public String getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(String maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public String getMaxSpeedBackward() {
        return this.maxSpeedBackward;
    }

    public void setMaxSpeedBackward(String maxSpeedBackward) {
        this.maxSpeedBackward = maxSpeedBackward;
    }

    public Integer getAzimuthStart() {
        return this.azimuthStart;
    }

    public void setAzimuthStart(Integer azimuthStart) {
        this.azimuthStart = azimuthStart;
    }

    public Integer getAzimuthEnd() {
        return this.azimuthEnd;
    }

    public void setAzimuthEnd(Integer azimuthEnd) {
        this.azimuthEnd = azimuthEnd;
    }

    public GeocodingLevels getGeocodingLevel() {
        this.geocodingLevel = this.calculateGeocodingLevel();
        return this.geocodingLevel;
    }

    private GeocodingLevels calculateGeocodingLevel() {
        if (this.houseNumber != null) {
            return GeocodingLevels.HOUSE_NUMBER;
        }
        if (this.streetName != null || this.streetType != null) {
            return GeocodingLevels.STREET;
        }
        if (this.citySubdivision != null || this.quarter != null) {
            return GeocodingLevels.CITY_SUBDIVISION;
        }
        if (this.city != null || this.dependentLocality != null || this.zipCode != null) {
            return GeocodingLevels.CITY;
        }
        if (this.state != null || this.district != null) {
            return GeocodingLevels.STATE;
        }
        if (this.country != null) {
            return GeocodingLevels.COUNTRY;
        }
        return GeocodingLevels.NONE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.POBox == null ? 0 : this.POBox.hashCode());
        result = 31 * result + (this.POBoxAgency == null ? 0 : this.POBoxAgency.hashCode());
        result = 31 * result + (this.POBoxInfo == null ? 0 : this.POBoxInfo.hashCode());
        result = 31 * result + (this.PostOfficeBox == null ? 0 : this.PostOfficeBox.hashCode());
        result = 31 * result + (this.StreetTypeIntersection == null ? 0 : this.StreetTypeIntersection.hashCode());
        result = 31 * result + (this.adm1Name == null ? 0 : this.adm1Name.hashCode());
        result = 31 * result + (this.adm2Name == null ? 0 : this.adm2Name.hashCode());
        result = 31 * result + (this.adm3Name == null ? 0 : this.adm3Name.hashCode());
        result = 31 * result + (this.adm4Name == null ? 0 : this.adm4Name.hashCode());
        result = 31 * result + (this.adm5Name == null ? 0 : this.adm5Name.hashCode());
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.citySubdivision == null ? 0 : this.citySubdivision.hashCode());
        result = 31 * result + (this.civicNumberSuffix == null ? 0 : this.civicNumberSuffix.hashCode());
        result = 31 * result + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = 31 * result + (this.streetRef == null ? 0 : this.streetRef.hashCode());
        result = 31 * result + (this.dependentLocality == null ? 0 : this.dependentLocality.hashCode());
        result = 31 * result + (this.distance == null ? 0 : this.distance.hashCode());
        result = 31 * result + (this.district == null ? 0 : this.district.hashCode());
        result = 31 * result + (this.extraInfo == null ? 0 : this.extraInfo.hashCode());
        result = 31 * result + (this.floor == null ? 0 : this.floor.hashCode());
        result = 31 * result + (this.geocodingLevel == null ? 0 : this.geocodingLevel.hashCode());
        result = 31 * result + (this.houseNumber == null ? 0 : this.houseNumber.hashCode());
        result = 31 * result + (this.houseNumberInfo == null ? 0 : this.houseNumberInfo.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lat == null ? 0 : this.lat.hashCode());
        result = 31 * result + (this.lng == null ? 0 : this.lng.hashCode());
        result = 31 * result + (this.lote == null ? 0 : this.lote.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.postDirection == null ? 0 : this.postDirection.hashCode());
        result = 31 * result + (this.postDirectionIntersection == null ? 0 : this.postDirectionIntersection.hashCode());
        result = 31 * result + (this.postTown == null ? 0 : this.postTown.hashCode());
        result = 31 * result + (this.preDirection == null ? 0 : this.preDirection.hashCode());
        result = 31 * result + (this.preDirectionIntersection == null ? 0 : this.preDirectionIntersection.hashCode());
        result = 31 * result + (this.prefecture == null ? 0 : this.prefecture.hashCode());
        result = 31 * result + (this.quadrant == null ? 0 : this.quadrant.hashCode());
        result = 31 * result + (this.quarter == null ? 0 : this.quarter.hashCode());
        result = 31 * result + (this.recipientName == null ? 0 : this.recipientName.hashCode());
        result = 31 * result + (this.sector == null ? 0 : this.sector.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.streetName == null ? 0 : this.streetName.hashCode());
        result = 31 * result + (this.streetNameIntersection == null ? 0 : this.streetNameIntersection.hashCode());
        result = 31 * result + (this.streetType == null ? 0 : this.streetType.hashCode());
        result = 31 * result + (this.suiteNumber == null ? 0 : this.suiteNumber.hashCode());
        result = 31 * result + (this.suiteType == null ? 0 : this.suiteType.hashCode());
        result = 31 * result + (this.ward == null ? 0 : this.ward.hashCode());
        result = 31 * result + (this.zipCode == null ? 0 : this.zipCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (this.POBox == null ? other.POBox != null : !this.POBox.equals(other.POBox)) {
            return false;
        }
        if (this.POBoxAgency == null ? other.POBoxAgency != null : !this.POBoxAgency.equals(other.POBoxAgency)) {
            return false;
        }
        if (this.POBoxInfo == null ? other.POBoxInfo != null : !this.POBoxInfo.equals(other.POBoxInfo)) {
            return false;
        }
        if (this.PostOfficeBox == null ? other.PostOfficeBox != null : !this.PostOfficeBox.equals(other.PostOfficeBox)) {
            return false;
        }
        if (this.StreetTypeIntersection == null ? other.StreetTypeIntersection != null : !this.StreetTypeIntersection.equals(other.StreetTypeIntersection)) {
            return false;
        }
        if (this.adm1Name == null ? other.adm1Name != null : !this.adm1Name.equals(other.adm1Name)) {
            return false;
        }
        if (this.adm2Name == null ? other.adm2Name != null : !this.adm2Name.equals(other.adm2Name)) {
            return false;
        }
        if (this.adm3Name == null ? other.adm3Name != null : !this.adm3Name.equals(other.adm3Name)) {
            return false;
        }
        if (this.adm4Name == null ? other.adm4Name != null : !this.adm4Name.equals(other.adm4Name)) {
            return false;
        }
        if (this.adm5Name == null ? other.adm5Name != null : !this.adm5Name.equals(other.adm5Name)) {
            return false;
        }
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.city == null ? other.city != null : !this.city.equals(other.city)) {
            return false;
        }
        if (this.citySubdivision == null ? other.citySubdivision != null : !this.citySubdivision.equals(other.citySubdivision)) {
            return false;
        }
        if (this.civicNumberSuffix == null ? other.civicNumberSuffix != null : !this.civicNumberSuffix.equals(other.civicNumberSuffix)) {
            return false;
        }
        if (this.confidence == null ? other.confidence != null : !this.confidence.equals(other.confidence)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.countryCode == null ? other.countryCode != null : !this.countryCode.equals(other.countryCode)) {
            return false;
        }
        if (this.dependentLocality == null ? other.dependentLocality != null : !this.dependentLocality.equals(other.dependentLocality)) {
            return false;
        }
        if (this.district == null ? other.district != null : !this.district.equals(other.district)) {
            return false;
        }
        if (this.extraInfo == null ? other.extraInfo != null : !this.extraInfo.equals(other.extraInfo)) {
            return false;
        }
        if (this.floor == null ? other.floor != null : !this.floor.equals(other.floor)) {
            return false;
        }
        if (this.geocodingLevel != other.geocodingLevel) {
            return false;
        }
        if (this.houseNumber == null ? other.houseNumber != null : !this.houseNumber.equals(other.houseNumber)) {
            return false;
        }
        if (this.houseNumberInfo == null ? other.houseNumberInfo != null : !this.houseNumberInfo.equals(other.houseNumberInfo)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lat == null ? other.lat != null : !this.lat.equals(other.lat)) {
            return false;
        }
        if (this.lng == null ? other.lng != null : !this.lng.equals(other.lng)) {
            return false;
        }
        if (this.lote == null ? other.lote != null : !this.lote.equals(other.lote)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.postDirection == null ? other.postDirection != null : !this.postDirection.equals(other.postDirection)) {
            return false;
        }
        if (this.postDirectionIntersection == null ? other.postDirectionIntersection != null : !this.postDirectionIntersection.equals(other.postDirectionIntersection)) {
            return false;
        }
        if (this.postTown == null ? other.postTown != null : !this.postTown.equals(other.postTown)) {
            return false;
        }
        if (this.preDirection == null ? other.preDirection != null : !this.preDirection.equals(other.preDirection)) {
            return false;
        }
        if (this.preDirectionIntersection == null ? other.preDirectionIntersection != null : !this.preDirectionIntersection.equals(other.preDirectionIntersection)) {
            return false;
        }
        if (this.prefecture == null ? other.prefecture != null : !this.prefecture.equals(other.prefecture)) {
            return false;
        }
        if (this.quadrant == null ? other.quadrant != null : !this.quadrant.equals(other.quadrant)) {
            return false;
        }
        if (this.quarter == null ? other.quarter != null : !this.quarter.equals(other.quarter)) {
            return false;
        }
        if (this.recipientName == null ? other.recipientName != null : !this.recipientName.equals(other.recipientName)) {
            return false;
        }
        if (this.sector == null ? other.sector != null : !this.sector.equals(other.sector)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.streetName == null ? other.streetName != null : !this.streetName.equals(other.streetName)) {
            return false;
        }
        if (this.streetNameIntersection == null ? other.streetNameIntersection != null : !this.streetNameIntersection.equals(other.streetNameIntersection)) {
            return false;
        }
        if (this.streetType == null ? other.streetType != null : !this.streetType.equals(other.streetType)) {
            return false;
        }
        if (this.streetRef == null ? other.streetRef != null : !this.streetRef.equals(other.streetRef)) {
            return false;
        }
        if (this.suiteNumber == null ? other.suiteNumber != null : !this.suiteNumber.equals(other.suiteNumber)) {
            return false;
        }
        if (this.suiteType == null ? other.suiteType != null : !this.suiteType.equals(other.suiteType)) {
            return false;
        }
        if (this.ward == null ? other.ward != null : !this.ward.equals(other.ward)) {
            return false;
        }
        return !(this.zipCode == null ? other.zipCode != null : !this.zipCode.equals(other.zipCode));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Address [");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.lng != null) {
            builder.append("lng=");
            builder.append(this.lng);
            builder.append(", ");
        }
        if (this.lat != null) {
            builder.append("lat=");
            builder.append(this.lat);
            builder.append(", ");
        }
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.recipientName != null) {
            builder.append("recipientName=");
            builder.append(this.recipientName);
            builder.append(", ");
        }
        if (this.houseNumber != null) {
            builder.append("houseNumber=");
            builder.append(this.houseNumber);
            builder.append(", ");
        }
        if (this.houseNumberInfo != null) {
            builder.append("houseNumberInfo=");
            builder.append(this.houseNumberInfo);
            builder.append(", ");
        }
        if (this.POBox != null) {
            builder.append("POBox=");
            builder.append(this.POBox);
            builder.append(", ");
        }
        if (this.POBoxInfo != null) {
            builder.append("POBoxInfo=");
            builder.append(this.POBoxInfo);
            builder.append(", ");
        }
        if (this.POBoxAgency != null) {
            builder.append("POBoxAgency=");
            builder.append(this.POBoxAgency);
            builder.append(", ");
        }
        if (this.civicNumberSuffix != null) {
            builder.append("civicNumberSuffix=");
            builder.append(this.civicNumberSuffix);
            builder.append(", ");
        }
        if (this.preDirection != null) {
            builder.append("preDirection=");
            builder.append(this.preDirection);
            builder.append(", ");
        }
        if (this.streetName != null) {
            builder.append("streetName=");
            builder.append(this.streetName);
            builder.append(", ");
        }
        if (this.streetType != null) {
            builder.append("streetType=");
            builder.append(this.streetType);
            builder.append(", ");
        }
        if (this.postDirection != null) {
            builder.append("postDirection=");
            builder.append(this.postDirection);
            builder.append(", ");
        }
        if (this.preDirectionIntersection != null) {
            builder.append("preDirectionIntersection=");
            builder.append(this.preDirectionIntersection);
            builder.append(", ");
        }
        if (this.streetNameIntersection != null) {
            builder.append("streetNameIntersection=");
            builder.append(this.streetNameIntersection);
            builder.append(", ");
        }
        if (this.StreetTypeIntersection != null) {
            builder.append("StreetTypeIntersection=");
            builder.append(this.StreetTypeIntersection);
            builder.append(", ");
        }
        if (this.postDirectionIntersection != null) {
            builder.append("postDirectionIntersection=");
            builder.append(this.postDirectionIntersection);
            builder.append(", ");
        }
        if (this.extraInfo != null) {
            builder.append("extraInfo=");
            builder.append(this.extraInfo);
            builder.append(", ");
        }
        if (this.suiteType != null) {
            builder.append("suiteType=");
            builder.append(this.suiteType);
            builder.append(", ");
        }
        if (this.suiteNumber != null) {
            builder.append("suiteNumber=");
            builder.append(this.suiteNumber);
            builder.append(", ");
        }
        if (this.floor != null) {
            builder.append("floor=");
            builder.append(this.floor);
            builder.append(", ");
        }
        if (this.quarter != null) {
            builder.append("quarter=");
            builder.append(this.quarter);
            builder.append(", ");
        }
        if (this.zipCode != null) {
            builder.append("zipCode=");
            builder.append(this.zipCode);
            builder.append(", ");
        }
        if (this.district != null) {
            builder.append("district=");
            builder.append(this.district);
            builder.append(", ");
        }
        if (this.dependentLocality != null) {
            builder.append("dependentLocality=");
            builder.append(this.dependentLocality);
            builder.append(", ");
        }
        if (this.city != null) {
            builder.append("city=");
            builder.append(this.city);
            builder.append(", ");
        }
        if (this.citySubdivision != null) {
            builder.append("citySubdivision=");
            builder.append(this.citySubdivision);
            builder.append(", ");
        }
        if (this.postTown != null) {
            builder.append("postTown=");
            builder.append(this.postTown);
            builder.append(", ");
        }
        if (this.state != null) {
            builder.append("state=");
            builder.append(this.state);
            builder.append(", ");
        }
        if (this.prefecture != null) {
            builder.append("prefecture=");
            builder.append(this.prefecture);
            builder.append(", ");
        }
        if (this.country != null) {
            builder.append("country=");
            builder.append(this.country);
            builder.append(", ");
        }
        if (this.countryCode != null) {
            builder.append("countryCode=");
            builder.append(this.countryCode);
            builder.append(", ");
        }
        if (this.sector != null) {
            builder.append("sector=");
            builder.append(this.sector);
            builder.append(", ");
        }
        if (this.quadrant != null) {
            builder.append("quadrant=");
            builder.append(this.quadrant);
            builder.append(", ");
        }
        if (this.block != null) {
            builder.append("block=");
            builder.append(this.block);
            builder.append(", ");
        }
        if (this.lote != null) {
            builder.append("lote=");
            builder.append(this.lote);
            builder.append(", ");
        }
        if (this.geocodingLevel != null) {
            builder.append("geocodingLevel=");
            builder.append((Object)this.getGeocodingLevel());
            builder.append(", ");
        }
        if (this.confidence != null) {
            builder.append("confidence=");
            builder.append(this.confidence);
            builder.append(", ");
        }
        if (this.distance != null) {
            builder.append("distance=");
            builder.append(this.distance);
            builder.append(", ");
        }
        if (this.ward != null) {
            builder.append("ward=");
            builder.append(this.ward);
            builder.append(", ");
        }
        if (this.adm1Name != null) {
            builder.append("adm1Name=");
            builder.append(this.adm1Name);
            builder.append(", ");
        }
        if (this.adm2Name != null) {
            builder.append("adm2Name=");
            builder.append(this.adm2Name);
            builder.append(", ");
        }
        if (this.adm3Name != null) {
            builder.append("adm3Name=");
            builder.append(this.adm3Name);
            builder.append(", ");
        }
        if (this.adm4Name != null) {
            builder.append("adm4Name=");
            builder.append(this.adm4Name);
            builder.append(", ");
        }
        if (this.adm5Name != null) {
            builder.append("adm5Name=");
            builder.append(this.adm5Name);
            builder.append(", ");
        }
        if (this.PostOfficeBox != null) {
            builder.append("PostOfficeBox=");
            builder.append(this.PostOfficeBox);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSuiteNumber() {
        return this.suiteNumber;
    }

    public void setSuiteNumber(String suiteNumber) {
        this.suiteNumber = suiteNumber;
    }

    public String getSuiteType() {
        return this.suiteType;
    }

    public void setSuiteType(String suiteType) {
        this.suiteType = suiteType;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public void setConfidence(String confidence) {
        this.confidence = confidence;
    }

    public Double getDistance() {
        return this.distance;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public void setGeocodingLevel(GeocodingLevels geocodingLevel) {
        this.geocodingLevel = geocodingLevel;
    }

    public String getLote() {
        return this.lote;
    }

    public void setLote(String lote) {
        this.lote = lote;
    }

    public Double getWard() {
        return this.ward;
    }

    public void setWard(Double ward) {
        this.ward = ward;
    }

    public String getFormatedFull() {
        return this.formatedFull;
    }

    public void setFormatedFull(String formatedFull) {
        this.formatedFull = formatedFull;
    }

    public String getFormatedPostal() {
        return this.formatedPostal;
    }

    public void setFormatedPostal(String formatedPostal) {
        this.formatedPostal = formatedPostal;
    }

    public String getStreetRef() {
        return this.streetRef;
    }

    public void setStreetRef(String streetRef) {
        this.streetRef = streetRef;
    }
}

