/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.MissingIdentifierException;
import org.hibernatespatial.pojo.NamingStrategy;
import org.hibernatespatial.pojo.TableNotFoundException;
import org.hibernatespatial.pojo.TypeMapper;
import org.hibernatespatial.pojo.TypeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureMapper.class);
    private final NamingStrategy naming;
    private final TypeMapper typeMapper;

    public FeatureMapper(NamingStrategy naming, TypeMapper typeMapper) {
        this.naming = naming;
        this.typeMapper = typeMapper;
    }

    public ClassInfo createClassInfo(String catalog, String schema, String tableName, DatabaseMetaData dmd) throws TableNotFoundException, MissingIdentifierException {
        String className = this.naming.createClassName(tableName);
        ClassInfo cInfo = new ClassInfo(tableName, className);
        this.readColums(catalog, schema, tableName, dmd, cInfo);
        this.determineIdentifier(catalog, schema, tableName, dmd, cInfo);
        return cInfo;
    }

    private void determineIdentifier(String catalog, String schema, String tableName, DatabaseMetaData dmd, ClassInfo cInfo) throws MissingIdentifierException {
        String pkn = null;
        pkn = this.determinePrimaryKey(catalog, schema, tableName, dmd);
        if (pkn == null) {
            pkn = this.findUniqueIndex(catalog, schema, tableName, dmd);
        }
        if (pkn == null) {
            throw new MissingIdentifierException(tableName);
        }
        this.setAsIdentifier(cInfo, pkn);
    }

    private String findUniqueIndex(String catalog, String schema, String tableName, DatabaseMetaData dmd) {
        HashMap<String, String> indexes = new HashMap<String, String>();
        HashSet<String> rejectedIndexes = new HashSet<String>();
        this.readUniqueIndexes(catalog, schema, tableName, dmd, indexes, rejectedIndexes);
        for (String candidate : indexes.keySet()) {
            if (rejectedIndexes.contains(candidate)) continue;
            return (String)indexes.get(candidate);
        }
        return null;
    }

    private void readUniqueIndexes(String catalog, String schema, String tableName, DatabaseMetaData dmd, Map<String, String> indexes, Set<String> rejectedIndexes) {
        ResultSet rs = null;
        try {
            rs = dmd.getIndexInfo(catalog, schema, tableName, true, false);
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) {
                    indexName = colName;
                }
                if (indexes.get(indexName) != null) {
                    rejectedIndexes.add(indexName);
                    continue;
                }
                indexes.put(indexName, colName);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
        }
    }

    private String determinePrimaryKey(String catalog, String schema, String tableName, DatabaseMetaData dmd) {
        String pkn;
        block15: {
            String string;
            pkn = null;
            ResultSet rs = null;
            try {
                rs = dmd.getPrimaryKeys(catalog, schema, tableName);
                if (!rs.next()) {
                    String string2 = null;
                    return string2;
                }
                pkn = rs.getString("COLUMN_NAME");
                if (!rs.next()) break block15;
                string = null;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            return string;
        }
        return pkn;
    }

    private void readColums(String catalog, String schema, String tableName, DatabaseMetaData dmd, ClassInfo cInfo) throws TableNotFoundException {
        ResultSet rs = null;
        boolean empty = true;
        try {
            rs = dmd.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                empty = false;
                String colName = rs.getString("COLUMN_NAME");
                String dbType = rs.getString("TYPE_NAME");
                int javaType = rs.getInt("DATA_TYPE");
                this.addAttribute(cInfo, colName, dbType, javaType);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
        }
        if (empty) {
            throw new TableNotFoundException(tableName);
        }
    }

    private void setAsIdentifier(ClassInfo cInfo, String pkn) {
        for (AttributeInfo ai : cInfo.getAttributes()) {
            if (!ai.getColumnName().equals(pkn)) continue;
            ai.setIdentifier(true);
            break;
        }
    }

    private void addAttribute(ClassInfo cInfo, String colName, String dbType, int javaType) {
        String hibernateType = null;
        try {
            hibernateType = this.typeMapper.getHibernateType(dbType, javaType);
            AttributeInfo ai = new AttributeInfo();
            ai.setColumnName(colName);
            ai.setFieldName(this.naming.createPropertyName(colName));
            ai.setHibernateType(hibernateType);
            ai.setCtClass(this.typeMapper.getCtClass(dbType, javaType));
            cInfo.addAttribute(ai);
        }
        catch (TypeNotFoundException e) {
            LOGGER.warn("No property generated for attribute " + colName + ": " + e.getMessage());
        }
    }
}

