/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.util.ArrayList;
import java.util.List;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.GeometryNotFoundException;
import org.hibernatespatial.pojo.MissingIdentifierException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo {
    private final String className;
    private final String tableName;
    private final List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();

    public ClassInfo(String tableName, String className) {
        this.className = className;
        this.tableName = tableName;
    }

    public AttributeInfo getIdAttribute() throws MissingIdentifierException {
        for (AttributeInfo ai : this.getAttributes()) {
            if (!ai.isIdentifier()) continue;
            return ai;
        }
        throw new MissingIdentifierException();
    }

    public AttributeInfo getGeomAttribute() throws GeometryNotFoundException {
        for (AttributeInfo ai : this.getAttributes()) {
            if (!ai.isGeometry()) continue;
            return ai;
        }
        throw new GeometryNotFoundException();
    }

    public List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addAttribute(AttributeInfo ai) {
        this.attributes.add(ai);
    }

    public void removeAttribute(AttributeInfo ai) {
        this.attributes.remove(ai);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : ((Object)this.attributes).hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        if (this.attributes == null ? other.attributes != null : !((Object)this.attributes).equals(other.attributes)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }
}

