/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer;

import com.gisgraphy.serializer.UniversalSerializerStrategy;
import com.gisgraphy.serializer.common.AbstractSerializer;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.serializer.common.SerializerException;
import com.gisgraphy.serializer.exception.UnsupportedFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniversalSerializer {
    private static UniversalSerializer universalSerializer = new UniversalSerializer();
    UniversalSerializerStrategy strategy = new UniversalSerializerStrategy();

    private UniversalSerializer() {
    }

    public static UniversalSerializer getInstance() {
        return universalSerializer;
    }

    public void write(OutputStream outputStream, Object object, OutputFormat format) throws SerializerException {
        if (outputStream == null) {
            throw new SerializerException("Can not serialize in a null outputstream");
        }
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        serializer.write(outputStream, object, serializer.isDefault_indentation(), null);
    }

    public void write(OutputStream outputStream, Object object, boolean indent, OutputFormat format) throws SerializerException {
        if (outputStream == null) {
            throw new SerializerException("Can not serialize in a null outputstream");
        }
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        serializer.write(outputStream, object, indent, null);
    }

    public String writeToString(Object object, OutputFormat format) throws SerializerException {
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        serializer.write((OutputStream)outputStream, object);
        return new String(outputStream.toByteArray());
    }

    public String writeToString(Object object, boolean indent, OutputFormat format) throws SerializerException {
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        serializer.write((OutputStream)outputStream, object, indent, null);
        return new String(outputStream.toByteArray());
    }

    public <T> T read(InputStream inputStream, Class<T> classToBeBound, OutputFormat format) throws SerializerException, UnsupportedFormatException {
        if (!format.supportRead()) {
            throw new UnsupportedFormatException(format + " does not support de serialisation");
        }
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        return (T)serializer.read(inputStream, classToBeBound);
    }

    public <T> T read(String stream, Class<T> classToBeBound, OutputFormat format) throws SerializerException, UnsupportedFormatException {
        if (!format.supportRead()) {
            throw new UnsupportedFormatException(format + " does not support de serialisation");
        }
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        return (T)serializer.read((InputStream)new ByteArrayInputStream(stream.getBytes()), classToBeBound);
    }

    public void write(OutputStream outputStream, Object object, boolean indent, Map<String, Object> extraParameter, OutputFormat format) throws SerializerException {
        if (outputStream == null) {
            throw new SerializerException("Can not serialize in a null outputstream");
        }
        AbstractSerializer serializer = this.strategy.getSerializerFromFormat(format);
        serializer.write(outputStream, object, indent, extraParameter);
    }
}

