/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser;

import com.gisgraphy.addressparser.Address;
import com.gisgraphy.addressparser.AddressParser;
import com.gisgraphy.addressparser.AddressQuery;
import com.gisgraphy.addressparser.AddressResultsDto;
import com.gisgraphy.addressparser.AddressResultsDtoSerializer;
import com.gisgraphy.addressparser.IAddressParserService;
import com.gisgraphy.addressparser.exception.AddressParserException;
import com.gisgraphy.addressparser.exception.CountryNotImplementedException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LocalAddressParserService
implements IAddressParserService {
    private static IAddressParserService addressParserService = new LocalAddressParserService();
    Logger logger = Logger.getLogger(LocalAddressParserService.class);
    protected AddressParser addressParser = AddressParser.getInstance();
    protected AddressResultsDtoSerializer addressResultsDtoSerializer = new AddressResultsDtoSerializer();

    protected LocalAddressParserService() {
    }

    protected LocalAddressParserService(String url) {
    }

    public static IAddressParserService getInstance() {
        return addressParserService;
    }

    protected AddressParser getAddressParser() {
        return this.addressParser;
    }

    protected AddressResultsDtoSerializer getAddressResultsDtoSerializer() {
        return this.addressResultsDtoSerializer;
    }

    public AddressResultsDto execute(AddressQuery query) throws AddressParserException {
        if (query == null) {
            throw new IllegalArgumentException("can not execute a null query");
        }
        long start = System.currentTimeMillis();
        this.logger.info((Object)("receive : " + query));
        try {
            Address address = this.getAddressParser().parse(query.getAddress(), query.getCountry(), query.isStandardize());
            ArrayList<Address> addressList = new ArrayList<Address>(1);
            if (address != null) {
                addressList.add(address);
            }
            long end = System.currentTimeMillis();
            long qTime = end - start;
            this.logger.info((Object)(query + " took " + qTime + " ms"));
            return new AddressResultsDto(addressList, Long.valueOf(qTime));
        }
        catch (CountryNotImplementedException e) {
            AddressResultsDto addressResultsDto = new AddressResultsDto();
            addressResultsDto.setMessage(e.getMessage());
            return addressResultsDto;
        }
        catch (Exception e) {
            throw new AddressParserException("exception during execution of query " + query + " : " + e.getMessage(), (Throwable)e);
        }
    }

    public void executeAndSerialize(AddressQuery query, OutputStream outputStream) throws AddressParserException {
        AddressResultsDto addressResultsDto;
        HashMap<String, String> extraParameters;
        if (outputStream == null) {
            throw new IllegalArgumentException("can not serialize in a null outputstream");
        }
        if (query == null) {
            throw new IllegalArgumentException("can not execute a null query");
        }
        if (query.getFormat() == null) {
            throw new IllegalArgumentException("You must specify an output format, no one is specify");
        }
        try {
            extraParameters = new HashMap<String, String>();
            extraParameters.put("callbackMethodName", query.getCallback());
            addressResultsDto = this.execute(query);
        }
        catch (Exception e1) {
            throw new AddressParserException("An error occurs during execution of " + query + " : " + e1.getMessage(), (Throwable)e1);
        }
        try {
            this.getAddressResultsDtoSerializer().serialize(outputStream, query.getFormat(), addressResultsDto, query.isIndent(), extraParameters);
        }
        catch (Exception e) {
            throw new AddressParserException("An error occurs during execution or serialization of " + query + " : " + e.getMessage(), (Throwable)e);
        }
    }

    public String executeToString(AddressQuery query) throws AddressParserException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.executeAndSerialize(query, outputStream);
        try {
            return outputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AddressParserException("unsupported encoding UTF-8");
        }
    }
}

