L.NumberFormatter = {
	round: function (num,dec,sep) {
		var res = L.Util.formatNum(num,dec)+"",
		numbers=res.split(".");
		if (numbers[1]) {
			var d = dec-numbers[1].length;
			for (; d > 0; d--) {
				numbers[1]+="0";
			}
			res = numbers.join(sep||".");
		}
		return res;
	},

	toDMS : function (deg) {
		var d = Math.floor (deg);
		var minfloat = (deg-d)*60;
		var m = Math.floor(minfloat);
		var secfloat = (minfloat-m)*60;
		var s = Math.round(secfloat);
		if (s==60) {
			m++;
			s="00";
		}
		if (m==60) {
			d++;
			m="00";
		}
		if(s<10) {
			s="0"+s;
		}
		if(m<10){
			m="0"+m;
		}
		return ("" + d + "&deg; " + m + "' " + s + "''");
	},

	createValidNumber:function(num,sep){
		if (num&&num.length>0){
			var numbers = num.split(sep||".");
			try{
				var numRes=Number(numbers.join("."));
				if(isNaN(numRes)){
					return undefined;
				}
				return numRes;
			}catch(e){
				return undefined;
			}
		}
		return undefined;
	}
};
