/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CoderResult;

class CharsetCallback {
    static final String SUB_STOP_ON_ILLEGAL = "i";
    static final String SKIP_STOP_ON_ILLEGAL = "i";
    static final String ESCAPE_ICU = null;
    static final String ESCAPE_JAVA = "J";
    static final String ESCAPE_C = "C";
    static final String ESCAPE_XML_DEC = "D";
    static final String ESCAPE_XML_HEX = "X";
    static final String ESCAPE_UNICODE = "U";
    public static final Encoder FROM_U_CALLBACK_SKIP = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            if (context == null) {
                return CoderResult.UNDERFLOW;
            }
            if (((String)context).equals("i")) {
                if (!cr.isUnmappable()) {
                    return cr;
                }
                return CoderResult.UNDERFLOW;
            }
            return cr;
        }
    };
    public static final Decoder TO_U_CALLBACK_SKIP = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            if (context == null) {
                return CoderResult.UNDERFLOW;
            }
            if (((String)context).equals("i")) {
                if (!cr.isUnmappable()) {
                    return cr;
                }
                return CoderResult.UNDERFLOW;
            }
            return cr;
        }
    };
    public static final Encoder FROM_U_CALLBACK_SUBSTITUTE = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            if (context == null) {
                return encoder.cbFromUWriteSub(encoder, source, target, offsets);
            }
            if (((String)context).equals("i")) {
                if (!cr.isUnmappable()) {
                    return cr;
                }
                return encoder.cbFromUWriteSub(encoder, source, target, offsets);
            }
            return cr;
        }
    };
    private static final char[] kSubstituteChar1 = new char[]{'\u001a'};
    private static final char[] kSubstituteChar = new char[]{'\ufffd'};
    public static final Decoder TO_U_CALLBACK_SUBSTITUTE = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            CharsetICU cs = (CharsetICU)decoder.charset();
            if (decoder.invalidCharLength == 1 && cs.subChar1 != 0) {
                return CharsetDecoderICU.toUWriteUChars(decoder, kSubstituteChar1, 0, 1, target, offsets, source.position());
            }
            return CharsetDecoderICU.toUWriteUChars(decoder, kSubstituteChar, 0, 1, target, offsets, source.position());
        }
    };
    public static final Encoder FROM_U_CALLBACK_STOP = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            return cr;
        }
    };
    public static final Decoder TO_U_CALLBACK_STOP = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            return cr;
        }
    };

    CharsetCallback() {
    }

    public static interface Encoder {
        public CoderResult call(CharsetEncoderICU var1, Object var2, CharBuffer var3, ByteBuffer var4, IntBuffer var5, char[] var6, int var7, int var8, CoderResult var9);
    }

    public static interface Decoder {
        public CoderResult call(CharsetDecoderICU var1, Object var2, ByteBuffer var3, CharBuffer var4, IntBuffer var5, char[] var6, int var7, CoderResult var8);
    }
}

