/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer.common;

import com.gisgraphy.serializer.common.IoutputFormatVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OutputFormat {
    XML{

        public String getParameterValue() {
            return "standard";
        }

        public String getContentType() {
            return "application/xml";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitXML(this);
        }

        public boolean supportRead() {
            return true;
        }
    }
    ,
    JSON{

        public String getParameterValue() {
            return "json";
        }

        public String getContentType() {
            return "application/json";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitJSON(this);
        }

        public boolean supportRead() {
            return true;
        }
    }
    ,
    PYTHON{

        public String getParameterValue() {
            return "python";
        }

        public String getContentType() {
            return "text/plain";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitPYTHON(this);
        }

        public boolean supportRead() {
            return false;
        }
    }
    ,
    PHP{

        public String getParameterValue() {
            return "php";
        }

        public String getContentType() {
            return "text/plain";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitPHP(this);
        }

        public boolean supportRead() {
            return false;
        }
    }
    ,
    ATOM{

        public String getParameterValue() {
            return "xslt";
        }

        public String getContentType() {
            return "application/xml";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitATOM(this);
        }

        public boolean supportRead() {
            return false;
        }
    }
    ,
    GEORSS{

        public String getParameterValue() {
            return "xslt";
        }

        public String getContentType() {
            return "application/xml";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitGEORSS(this);
        }

        public boolean supportRead() {
            return false;
        }
    }
    ,
    RUBY{

        public String getParameterValue() {
            return "ruby";
        }

        public String getContentType() {
            return "text/plain";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitRUBY(this);
        }

        public boolean supportRead() {
            return false;
        }
    }
    ,
    YAML{

        public String getParameterValue() {
            return "yaml";
        }

        public String getContentType() {
            return "text/x-yaml";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitYAML(this);
        }

        public boolean supportRead() {
            return true;
        }
    }
    ,
    UNSUPPORTED{

        public String getParameterValue() {
            return "";
        }

        public String getContentType() {
            return "";
        }

        public String accept(IoutputFormatVisitor visitor) {
            return visitor.visitUNSUPPORTED(this);
        }

        public boolean supportRead() {
            return false;
        }
    };

    public static final String RSS_VERSION = "rss_2.0";
    public static final String ATOM_VERSION = "atom_0.3";

    public static OutputFormat getDefault() {
        return XML;
    }

    public abstract String getParameterValue();

    public abstract String getContentType();

    public abstract boolean supportRead();

    public static OutputFormat getFromString(String format) {
        OutputFormat outputFormat = OutputFormat.getDefault();
        try {
            outputFormat = OutputFormat.valueOf(format.toUpperCase());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return outputFormat;
    }

    public abstract String accept(IoutputFormatVisitor var1);
}

