/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.ByteGetter;
import org.postgis.binary.ValueGetter;

public class BinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter byteGetter) {
        if (byteGetter.get(0) == 0) {
            return new ValueGetter.XDR(byteGetter);
        }
        if (byteGetter.get(0) == 1) {
            return new ValueGetter.NDR(byteGetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + byteGetter.get(0));
    }

    public synchronized Geometry parse(String string) {
        ByteGetter.StringByteGetter stringByteGetter = new ByteGetter.StringByteGetter(string);
        return this.parseGeometry(BinaryParser.valueGetterForEndian(stringByteGetter));
    }

    public synchronized Geometry parse(byte[] byArray) {
        ByteGetter.BinaryByteGetter binaryByteGetter = new ByteGetter.BinaryByteGetter(byArray);
        return this.parseGeometry(BinaryParser.valueGetterForEndian(binaryByteGetter));
    }

    protected Geometry parseGeometry(ValueGetter valueGetter) {
        Geometry geometry;
        byte by = valueGetter.getByte();
        if (by != valueGetter.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int n = valueGetter.getInt();
        int n2 = n & 0x1FFFFFFF;
        boolean bl = false;
        if ((n & Integer.MIN_VALUE) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if ((n & 0x40000000) != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if ((n & 0x20000000) != 0) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        int n3 = -1;
        if (bl6) {
            n3 = valueGetter.getInt();
        }
        switch (n2) {
            case 1: {
                geometry = this.parsePoint(valueGetter, bl2, bl4);
                break;
            }
            case 2: {
                geometry = this.parseLineString(valueGetter, bl2, bl4);
                break;
            }
            case 3: {
                geometry = this.parsePolygon(valueGetter, bl2, bl4);
                break;
            }
            case 4: {
                geometry = this.parseMultiPoint(valueGetter);
                break;
            }
            case 5: {
                geometry = this.parseMultiLineString(valueGetter);
                break;
            }
            case 6: {
                geometry = this.parseMultiPolygon(valueGetter);
                break;
            }
            case 7: {
                geometry = this.parseCollection(valueGetter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + n2);
            }
        }
        Geometry geometry2 = geometry;
        if (bl6) {
            geometry2.setSrid(n3);
        }
        return geometry2;
    }

    private final Point parsePoint(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point point;
        double d = valueGetter.getDouble();
        double d2 = valueGetter.getDouble();
        if (bl) {
            double d3 = valueGetter.getDouble();
            point = new Point(d, d2, d3);
        } else {
            point = new Point(d, d2);
        }
        if (bl2) {
            point.setM(valueGetter.getDouble());
        }
        return point;
    }

    private final void parseGeometryArray(ValueGetter valueGetter, Geometry[] geometryArray) {
        int n = 0;
        while (n < geometryArray.length) {
            geometryArray[n] = this.parseGeometry(valueGetter);
            ++n;
        }
    }

    private final Point[] parsePointArray(ValueGetter valueGetter, boolean bl, boolean bl2) {
        int n = valueGetter.getInt();
        Point[] pointArray = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray[n2] = this.parsePoint(valueGetter, bl, bl2);
            ++n2;
        }
        return pointArray;
    }

    private final MultiPoint parseMultiPoint(ValueGetter valueGetter) {
        Geometry[] geometryArray = new Point[valueGetter.getInt()];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiPoint((Point[])geometryArray);
    }

    private final LineString parseLineString(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point[] pointArray = this.parsePointArray(valueGetter, bl, bl2);
        return new LineString(pointArray);
    }

    private final LinearRing parseLinearRing(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point[] pointArray = this.parsePointArray(valueGetter, bl, bl2);
        return new LinearRing(pointArray);
    }

    private final Polygon parsePolygon(ValueGetter valueGetter, boolean bl, boolean bl2) {
        int n = valueGetter.getInt();
        LinearRing[] linearRingArray = new LinearRing[n];
        int n2 = 0;
        while (n2 < n) {
            linearRingArray[n2] = this.parseLinearRing(valueGetter, bl, bl2);
            ++n2;
        }
        return new Polygon(linearRingArray);
    }

    private final MultiLineString parseMultiLineString(ValueGetter valueGetter) {
        int n = valueGetter.getInt();
        Geometry[] geometryArray = new LineString[n];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiLineString((LineString[])geometryArray);
    }

    private final MultiPolygon parseMultiPolygon(ValueGetter valueGetter) {
        int n = valueGetter.getInt();
        Geometry[] geometryArray = new Polygon[n];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiPolygon((Polygon[])geometryArray);
    }

    private final GeometryCollection parseCollection(ValueGetter valueGetter) {
        int n = valueGetter.getInt();
        Geometry[] geometryArray = new Geometry[n];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new GeometryCollection(geometryArray);
    }
}

