/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer.yaml;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.gisgraphy.serializer.common.AbstractSerializer;
import com.gisgraphy.serializer.common.SerializerException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlSerializer
extends AbstractSerializer {
    private static final Logger logger = Logger.getLogger(YamlSerializer.class);

    public <T> T read(InputStream inputStream, Class<T> classToBeBound) throws SerializerException {
        YamlConfig config = new YamlConfig();
        config.setPrivateFields(true);
        YamlReader yamlReader = new YamlReader((Reader)new InputStreamReader(inputStream), config);
        try {
            return (T)yamlReader.read(classToBeBound);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public void write(OutputStream outputStream, Object object, boolean indent, Map<String, Object> extraParams) throws SerializerException {
        if (object == null) {
            throw new SerializerException("can not serialize null object in YAML");
        }
        YamlConfig config = new YamlConfig();
        config.setPrivateFields(true);
        YamlWriter writer = new YamlWriter((Writer)new OutputStreamWriter(outputStream), config);
        try {
            writer.write(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (YamlException yamlException) {}
            }
        }
    }
}

