/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer.php;

import com.gisgraphy.serializer.common.AbstractSerializer;
import com.gisgraphy.serializer.common.SerializerException;
import com.gisgraphy.serializer.php.PhpJsonFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpSerializer
extends AbstractSerializer {
    private static Pattern p = Pattern.compile("\\w+");
    private static final Logger logger = Logger.getLogger(PhpSerializer.class);
    private ObjectMapper mapper = new ObjectMapper((JsonFactory)new PhpJsonFactory());

    public PhpSerializer() {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().set((MapperConfig.ConfigFeature)SerializationConfig.Feature.INDENT_OUTPUT, false);
        this.mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.mapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    public <T> T read(InputStream inputStream, Class<T> classToBeBound) throws SerializerException {
        throw new RuntimeException("read is not implemented for PHP");
    }

    public void write(OutputStream outputStream, Object object, boolean indent, Map<String, Object> extraParams) throws SerializerException {
        Object callbackMethodName = null;
        if (extraParams != null) {
            callbackMethodName = extraParams.get("callbackMethodName");
        }
        try {
            boolean isValidMethodName;
            boolean bl = isValidMethodName = callbackMethodName != null && callbackMethodName instanceof String && p.matcher((String)callbackMethodName).matches();
            if (isValidMethodName) {
                outputStream.write(new String(callbackMethodName + "(").getBytes("UTF-8"));
            }
            this.mapper.writeValue(outputStream, object);
            if (isValidMethodName) {
                outputStream.write(new String(");").getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }
}

