/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.geocoloc;

import com.gisgraphy.geocoloc.IGeolocSearchEngine;
import com.gisgraphy.geoloc.GeolocQuery;
import com.gisgraphy.geoloc.GeolocResultsDto;
import com.gisgraphy.rest.IRestClient;
import com.gisgraphy.rest.RestClient;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.service.ServiceException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class GeolocClient
implements IGeolocSearchEngine {
    private String baseUrl;
    IRestClient restClient = new RestClient();

    public GeolocClient(String baseUrl) {
        if (baseUrl == null || "".equals(baseUrl.trim())) {
            throw new IllegalArgumentException("geoloc base URL is empty or null");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("geoloc base URL should be correct");
        }
        this.baseUrl = baseUrl;
    }

    public void executeAndSerialize(GeolocQuery query, OutputStream outputStream) throws ServiceException {
        if (query == null) {
            throw new IllegalArgumentException("can not execute a null query");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("can not serialize to a null outputStream");
        }
        String queryString = this.geolocQuerytoQueryString(query);
        this.restClient.get(this.baseUrl + queryString, outputStream, query.getOutputFormat());
    }

    public String executeQueryToString(GeolocQuery query) throws ServiceException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        String queryString = this.geolocQuerytoQueryString(query);
        return this.restClient.get(this.baseUrl + queryString, String.class, query.getOutputFormat());
    }

    public GeolocResultsDto executeQuery(GeolocQuery query) throws ServiceException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        query.withCallback(null);
        String queryString = this.geolocQuerytoQueryString(query);
        return this.restClient.get(this.baseUrl + queryString, GeolocResultsDto.class, OutputFormat.JSON);
    }

    protected String geolocQuerytoQueryString(GeolocQuery query) {
        StringBuffer sb = new StringBuffer("?");
        this.addParameter(sb, "lat", query.getLatitude());
        this.addParameter(sb, "lng", query.getLongitude());
        this.addParameter(sb, "radius", query.getRadius());
        this.addParameter(sb, "from", query.getFirstPaginationIndex());
        this.addParameter(sb, "to", query.getLastPaginationIndex());
        this.addParameter(sb, "callback", query.getCallback());
        this.addParameter(sb, "format", query.getOutputFormat());
        if (query.getPlaceType() != null) {
            this.addParameter(sb, "placetype", query.getPlaceType().getSimpleName());
        }
        this.addParameter(sb, "distance", query.hasDistanceField());
        this.addParameter(sb, "indent", query.isOutputIndented());
        this.addParameter(sb, "apikey", query.getApikey());
        return sb.toString();
    }

    private void addParameter(StringBuffer sb, String httpParameterName, Object parameterValue) {
        if (parameterValue != null) {
            sb.append(httpParameterName).append("=").append(parameterValue.toString()).append("&");
        }
    }

    public void setRestClient(IRestClient restClient) {
        this.restClient = restClient;
    }
}

