/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotools.io.TableWriter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;

public class Preprocessor
extends Format {
    protected final Format parser;
    private final Map definitions = new TreeMap();
    private transient Set names;
    private transient Replacement replacements;
    transient int offset = 0;

    public Preprocessor(Format parser) {
        this.parser = parser;
    }

    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition position) {
        return this.parser.format(object, toAppendTo, position);
    }

    public Object parseObject(String wkt, ParsePosition position) {
        int start = position.getIndex();
        try {
            return this.parseObject(wkt.substring(start));
        }
        catch (ParseException exception) {
            position.setIndex(start);
            position.setErrorIndex(exception.getErrorOffset() + start);
            return null;
        }
    }

    public Object parseObject(String wkt) throws ParseException {
        try {
            return this.parseObject(wkt, Object.class);
        }
        catch (FactoryException cause) {
            ParseException e = new ParseException(cause.getLocalizedMessage(), 0);
            e.initCause(cause);
            throw e;
        }
    }

    public Object parseObject(String text, Class type) throws ParseException, FactoryException {
        Definition def = (Definition)this.definitions.get(text);
        if (def != null) {
            Object value = def.asObject;
            if (type.isAssignableFrom(value.getClass())) {
                return value;
            }
        } else if (!Preprocessor.isIdentifier(text)) {
            Object value = this.forwardParse(text = this.substitute(text));
            Class<?> actualType = value.getClass();
            if (type.isAssignableFrom(actualType)) {
                return value;
            }
            throw new FactoryException(Errors.format(45, Utilities.getShortName(actualType), Utilities.getShortName(type)));
        }
        throw new NoSuchIdentifierException(Errors.format(100, Utilities.getShortName(type), text), text);
    }

    private Object forwardParse(String text) throws ParseException {
        try {
            return this.parser.parseObject(text);
        }
        catch (ParseException exception) {
            int shift = 0;
            int errorOffset = exception.getErrorOffset();
            Replacement r = this.replacements;
            while (r != null && errorOffset >= r.lower) {
                if (errorOffset < r.upper) {
                    errorOffset = r.lower;
                    break;
                }
                shift += r.shift;
                r = r.next;
            }
            ParseException adjusted = new ParseException(exception.getLocalizedMessage(), errorOffset - shift);
            adjusted.setStackTrace(exception.getStackTrace());
            adjusted.initCause(exception.getCause());
            throw adjusted;
        }
    }

    private String substitute(String text) {
        Replacement last;
        this.replacements = last = new Replacement(0, 0, this.offset);
        StringBuffer buffer = null;
        for (Map.Entry entry : this.definitions.entrySet()) {
            int index;
            String name = (String)entry.getKey();
            Definition def = (Definition)entry.getValue();
            int n = index = buffer != null ? buffer.indexOf(name) : text.indexOf(name);
            while (index >= 0) {
                CharSequence cs;
                int upper = index + name.length();
                CharSequence charSequence = cs = buffer != null ? buffer : text;
                if (!(index != 0 && Character.isJavaIdentifierPart(cs.charAt(index - 1)) || upper != cs.length() && Character.isJavaIdentifierPart(cs.charAt(upper)))) {
                    int count = 0;
                    int scan = index;
                    while (--scan >= 0) {
                        int n2 = scan = buffer != null ? buffer.lastIndexOf("\"", scan) : text.lastIndexOf(34, scan);
                        if (scan < 0) break;
                        ++count;
                    }
                    if (!(count & true)) {
                        if (buffer == null) {
                            buffer = new StringBuffer(text);
                            assert (buffer.indexOf(name, index) == index);
                        }
                        String value = def.asString;
                        buffer.replace(index, upper, value);
                        int change = value.length() - name.length();
                        last = last.next = new Replacement(index, index + value.length(), change);
                        index = buffer.indexOf(name, index + change);
                        continue;
                    }
                }
                index = buffer != null ? buffer.indexOf(name, index) : text.indexOf(name, index += name.length());
            }
        }
        return buffer != null ? buffer.toString() : text;
    }

    public void addDefinition(String name, String value) throws ParseException {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException(Errors.format(171));
        }
        if (!Preprocessor.isIdentifier(name)) {
            throw new IllegalArgumentException(Errors.format(169, name));
        }
        value = this.substitute(value);
        Definition newDef = new Definition(value, this.forwardParse(value));
        Definition oldDef = this.definitions.put(name, newDef);
    }

    public void removeDefinition(String name) {
        this.definitions.remove(name);
    }

    public Set getDefinitionNames() {
        if (this.names == null) {
            this.names = Collections.unmodifiableSet(this.definitions.keySet());
        }
        return this.names;
    }

    public void printDefinitions(Writer out) throws IOException {
        Locale locale = null;
        Vocabulary resources = Vocabulary.getResources(locale);
        TableWriter table = new TableWriter(out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write(resources.getString(109));
        table.nextColumn();
        table.write(resources.getString(174));
        table.nextColumn();
        table.write(resources.getString(210));
        table.nextLine();
        table.writeHorizontalSeparator();
        for (Map.Entry entry : this.definitions.entrySet()) {
            Object object = ((Definition)entry.getValue()).asObject;
            table.write(String.valueOf(entry.getKey()));
            table.nextColumn();
            table.write(Utilities.getShortClassName(object));
            table.nextColumn();
            if (object instanceof IdentifiedObject) {
                table.write(((IdentifiedObject)object).getName().getCode());
            }
            table.nextLine();
        }
        table.writeHorizontalSeparator();
        table.flush();
    }

    private static boolean isIdentifier(String text) {
        int i = text.length();
        while (--i >= 0) {
            char c = text.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == ':') continue;
            return false;
        }
        return true;
    }

    private static final class Replacement {
        public final int lower;
        public final int upper;
        public final int shift;
        public Replacement next;

        public Replacement(int lower, int upper, int shift) {
            this.lower = lower;
            this.upper = upper;
            this.shift = shift;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Replacement r = this;
            while (r != null) {
                if (r != this) {
                    buffer.append(", ");
                }
                buffer.append('[').append(r.lower).append("..").append(r.upper).append("] \u2192 ").append(r.shift);
                r = r.next;
            }
            return buffer.toString();
        }
    }

    private static final class Definition
    implements Serializable {
        public final String asString;
        public final Object asObject;

        public Definition(String asString, Object asObject) {
            this.asString = asString;
            this.asObject = asObject;
        }
    }
}

