/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.referencing.operation.projection.StereographicUSGS;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class EquatorialStereographic
extends StereographicUSGS {
    private static final double EPSILON = 1.0E-6;
    static final double k0 = 2.0;

    protected EquatorialStereographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        this(parameters, Stereographic.Provider.PARAMETERS);
    }

    EquatorialStereographic(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
        super(parameters, descriptor);
        assert (((StereographicUSGS)this).k0 == 2.0) : ((StereographicUSGS)this).k0;
        this.latitudeOfOrigin = 0.0;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
        double chi = 2.0 * Math.atan(this.ssfn(y, Math.sin(y))) - 1.5707963267948966;
        double cosChi = Math.cos(chi);
        double A = 2.0 / (1.0 + cosChi * Math.cos(x));
        x = A * cosChi * Math.sin(x);
        y = A * Math.sin(chi);
        assert (EquatorialStereographic.checkTransform(x, y, ptDst));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static final class Spherical
    extends EquatorialStereographic {
        Spherical(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
            super(parameters, descriptor);
            this.ensureSpherical();
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
            double coslat = Math.cos(y);
            double f = 1.0 + coslat * Math.cos(x);
            if (f < 1.0E-6) {
                throw new ProjectionException(Errors.format(146));
            }
            f = 2.0 / f;
            x = f * coslat * Math.sin(x);
            y = f * Math.sin(y);
            assert (Spherical.checkTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            double rho = Math.sqrt(x * x + y * y);
            if (Math.abs(rho) < 1.0E-6) {
                y = 0.0;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(rho / 2.0);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                y = Math.asin(y * sinc / rho);
                double t = x * sinc;
                double ct = rho * cosc;
                double d = x = Math.abs(t) < 1.0E-6 && Math.abs(ct) < 1.0E-6 ? 0.0 : Math.atan2(t, ct);
            }
            assert (Spherical.checkInverseTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }
}

