/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.units.Unit;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.BackingStoreException;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CanonicalSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;

public class TransformedAuthorityFactory
extends AuthorityFactoryAdapter {
    private static final DefaultCoordinateSystemAxis[] RENAMEABLE = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.WESTING};
    private transient CoordinateOperationFactory opFactory;
    private final CanonicalSet pool = new CanonicalSet();

    protected TransformedAuthorityFactory(AuthorityFactory factory) {
        super(factory);
    }

    protected TransformedAuthorityFactory(CRSAuthorityFactory crsFactory, CSAuthorityFactory csFactory, DatumAuthorityFactory datumFactory, CoordinateOperationAuthorityFactory opFactory) {
        super(crsFactory, csFactory, datumFactory, opFactory);
    }

    protected TransformedAuthorityFactory(String authority, Hints userHints) throws FactoryRegistryException {
        super(authority, userHints);
    }

    public int getPriority() {
        return this.priority + 1;
    }

    protected Unit replace(Unit units) throws FactoryException {
        return units;
    }

    protected AxisDirection replace(AxisDirection direction) throws FactoryException {
        return direction;
    }

    protected CoordinateSystemAxis replace(CoordinateSystemAxis axis) throws FactoryException {
        boolean directionChanged;
        AxisDirection oldDirection = axis.getDirection();
        AxisDirection newDirection = this.replace(oldDirection);
        Unit oldUnits = axis.getUnit();
        Unit newUnits = this.replace(oldUnits);
        boolean bl = directionChanged = !oldDirection.equals(newDirection);
        if (directionChanged) {
            String name = axis.getName().getCode();
            block0: for (int i = 0; i < RENAMEABLE.length; ++i) {
                if (!RENAMEABLE[i].nameMatches(name)) continue;
                for (i = 0; i < RENAMEABLE.length; ++i) {
                    DefaultCoordinateSystemAxis candidate = RENAMEABLE[i];
                    if (!newDirection.equals(candidate.getDirection())) continue;
                    axis = candidate;
                    oldUnits = axis.getUnit();
                    directionChanged = false;
                    break block0;
                }
                break;
            }
        }
        if (directionChanged || !oldUnits.equals((Object)newUnits)) {
            ReferencingFactoryContainer factories = this.getFactoryContainer(false);
            CSFactory csFactory = factories.getCSFactory();
            Map properties = this.getProperties((IdentifiedObject)axis);
            axis = csFactory.createCoordinateSystemAxis(properties, axis.getAbbreviation(), newDirection, newUnits);
            axis = (CoordinateSystemAxis)this.pool.unique(axis);
        }
        return axis;
    }

    protected CoordinateSystem replace(CoordinateSystem cs) throws FactoryException {
        int i;
        int dimension = cs.getDimension();
        CoordinateSystemAxis[] orderedAxis = new CoordinateSystemAxis[dimension];
        for (i = 0; i < dimension; ++i) {
            orderedAxis[i] = this.replace(cs.getAxis(i));
        }
        if (this instanceof Comparator) {
            Arrays.sort(orderedAxis, (Comparator)((Object)this));
        }
        for (i = 0; i < dimension; ++i) {
            if (orderedAxis[i].equals(cs.getAxis(i))) continue;
            CoordinateSystem modified = this.createCS(cs.getClass(), this.getProperties((IdentifiedObject)cs), orderedAxis);
            assert (Utilities.sameInterfaces(cs.getClass(), modified.getClass(), CoordinateSystem.class));
            modified = (CoordinateSystem)this.pool.unique(modified);
            return modified;
        }
        return cs;
    }

    protected Datum replace(Datum datum) throws FactoryException {
        return super.replace(datum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CoordinateReferenceSystem replace(CoordinateReferenceSystem crs) throws FactoryException {
        GeographicCRS modified;
        boolean sameCS;
        Datum datum;
        Datum oldDatum;
        CoordinateSystem oldCS = crs.getCoordinateSystem();
        CoordinateSystem cs = this.replace(oldCS);
        if (crs instanceof SingleCRS) {
            oldDatum = ((SingleCRS)crs).getDatum();
            datum = this.replace(oldDatum);
        } else {
            oldDatum = null;
            datum = null;
        }
        boolean bl = sameCS = Utilities.equals(cs, oldCS) && Utilities.equals(datum, oldDatum);
        if (crs instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS derivedCRS = (GeneralDerivedCRS)crs;
            CoordinateReferenceSystem oldBaseCRS = derivedCRS.getBaseCRS();
            CoordinateReferenceSystem baseCRS = this.replace(oldBaseCRS);
            if (sameCS && Utilities.equals(baseCRS, oldBaseCRS)) {
                return crs;
            }
            Map properties = this.getProperties((IdentifiedObject)crs);
            ReferencingFactoryContainer factories = this.getFactoryContainer(true);
            CRSFactory crsFactory = factories.getCRSFactory();
            Conversion fromBase = derivedCRS.getConversionFromBase();
            fromBase = new DefiningConversion(this.getProperties((IdentifiedObject)fromBase), fromBase.getMethod(), fromBase.getParameterValues());
            if (!(crs instanceof ProjectedCRS)) throw new FactoryException(Errors.format(180, crs.getName().getCode()));
            modified = factories.createProjectedCRS(properties, (GeographicCRS)baseCRS, fromBase, (CartesianCS)cs);
            return (CoordinateReferenceSystem)this.pool.unique(modified);
        } else {
            if (sameCS) {
                return crs;
            }
            Map properties = this.getProperties((IdentifiedObject)crs);
            ReferencingFactoryContainer factories = this.getFactoryContainer(true);
            CRSFactory crsFactory = factories.getCRSFactory();
            if (crs instanceof GeographicCRS) {
                modified = crsFactory.createGeographicCRS(properties, (GeodeticDatum)datum, (EllipsoidalCS)cs);
                return (CoordinateReferenceSystem)this.pool.unique(modified);
            } else if (crs instanceof GeocentricCRS) {
                GeodeticDatum gd = (GeodeticDatum)datum;
                modified = cs instanceof CartesianCS ? crsFactory.createGeocentricCRS(properties, gd, (CartesianCS)cs) : crsFactory.createGeocentricCRS(properties, gd, (SphericalCS)cs);
                return (CoordinateReferenceSystem)this.pool.unique(modified);
            } else if (crs instanceof VerticalCRS) {
                modified = crsFactory.createVerticalCRS(properties, (VerticalDatum)datum, (VerticalCS)cs);
                return (CoordinateReferenceSystem)this.pool.unique(modified);
            } else if (crs instanceof TemporalCRS) {
                modified = crsFactory.createTemporalCRS(properties, (TemporalDatum)datum, (TimeCS)cs);
                return (CoordinateReferenceSystem)this.pool.unique(modified);
            } else if (crs instanceof ImageCRS) {
                modified = crsFactory.createImageCRS(properties, (ImageDatum)datum, (AffineCS)cs);
                return (CoordinateReferenceSystem)this.pool.unique(modified);
            } else if (crs instanceof EngineeringCRS) {
                modified = crsFactory.createEngineeringCRS(properties, (EngineeringDatum)datum, cs);
                return (CoordinateReferenceSystem)this.pool.unique(modified);
            } else {
                if (!(crs instanceof CompoundCRS)) throw new FactoryException(Errors.format(180, crs.getName().getCode()));
                List elements = ((CompoundCRS)crs).getCoordinateReferenceSystems();
                CoordinateReferenceSystem[] m = new CoordinateReferenceSystem[elements.size()];
                for (int i = 0; i < m.length; ++i) {
                    m[i] = this.replace((CoordinateReferenceSystem)elements.get(i));
                }
                modified = crsFactory.createCompoundCRS(properties, m);
            }
        }
        return (CoordinateReferenceSystem)this.pool.unique(modified);
    }

    protected CoordinateOperation replace(CoordinateOperation operation) throws FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateReferenceSystem oldSrcCRS = operation.getSourceCRS();
        CoordinateReferenceSystem oldTgtCRS = operation.getTargetCRS();
        CoordinateReferenceSystem sourceCRS = oldSrcCRS != null ? this.replace(oldSrcCRS) : null;
        CoordinateReferenceSystem coordinateReferenceSystem = targetCRS = oldTgtCRS != null ? this.replace(oldTgtCRS) : null;
        if (Utilities.equals(oldSrcCRS, sourceCRS) && Utilities.equals(oldTgtCRS, targetCRS)) {
            return operation;
        }
        if (this.opFactory == null) {
            this.opFactory = this.getCoordinateOperationFactory();
        }
        CoordinateOperation modified = this.opFactory.createOperation(sourceCRS, targetCRS);
        modified = (CoordinateOperation)this.pool.unique(modified);
        return modified;
    }

    private CoordinateSystem createCS(Class type, Map properties, CoordinateSystemAxis[] axis) throws FactoryException {
        int dimension = axis.length;
        ReferencingFactoryContainer factories = this.getFactoryContainer(false);
        CSFactory csFactory = factories.getCSFactory();
        if (CartesianCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createCartesianCS(properties, axis[0], axis[1]);
                }
                case 3: {
                    return csFactory.createCartesianCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (EllipsoidalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createEllipsoidalCS(properties, axis[0], axis[1]);
                }
                case 3: {
                    return csFactory.createEllipsoidalCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (SphericalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 3: {
                    return csFactory.createSphericalCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (CylindricalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 3: {
                    return csFactory.createCylindricalCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (PolarCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createPolarCS(properties, axis[0], axis[1]);
                }
            }
        } else if (VerticalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 1: {
                    return csFactory.createVerticalCS(properties, axis[0]);
                }
            }
        } else if (TimeCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 1: {
                    return csFactory.createTimeCS(properties, axis[0]);
                }
            }
        } else if (LinearCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 1: {
                    return csFactory.createLinearCS(properties, axis[0]);
                }
            }
        } else if (UserDefinedCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createUserDefinedCS(properties, axis[0], axis[1]);
                }
                case 3: {
                    return csFactory.createUserDefinedCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        }
        throw new FactoryException(Errors.format(151, Utilities.getShortName(type)));
    }

    private Map getProperties(IdentifiedObject object) {
        Citation authority = this.getAuthority();
        if (!Utilities.equals(authority, object.getName().getAuthority())) {
            return AbstractIdentifiedObject.getProperties(object, authority);
        }
        return AbstractIdentifiedObject.getProperties(object);
    }

    public Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        Set operations = super.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
        LinkedHashSet<CoordinateOperation> modified = new LinkedHashSet<CoordinateOperation>((int)((float)operations.size() / 0.75f) + 1);
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            CoordinateOperation operation;
            try {
                operation = (CoordinateOperation)it.next();
            }
            catch (BackingStoreException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof FactoryException) {
                    throw (FactoryException)cause;
                }
                throw exception;
            }
            modified.add(this.replace(operation));
        }
        return modified;
    }

    public synchronized void dispose() throws FactoryException {
        this.pool.clear();
        super.dispose();
    }
}

