/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.BackingStoreException;
import org.geotools.resources.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;

public class IdentifiedObjectSet
extends AbstractSet
implements Serializable {
    private static final long serialVersionUID = -4221260663706882719L;
    private final Map objects = new LinkedHashMap();
    protected final AuthorityFactory factory;

    public IdentifiedObjectSet(AuthorityFactory factory) {
        this.factory = factory;
    }

    public void clear() {
        this.objects.clear();
    }

    public int size() {
        return this.objects.size();
    }

    public boolean addAuthorityCode(String code) {
        boolean already = this.objects.containsKey(code);
        IdentifiedObject old = this.objects.put(code, null);
        if (old != null) {
            this.objects.put(code, old);
            return false;
        }
        return !already;
    }

    public boolean add(Object object) {
        String code = this.getAuthorityCode((IdentifiedObject)object);
        return !Utilities.equals(this.objects.put(code, object), object);
    }

    private IdentifiedObject get(String code) throws BackingStoreException {
        IdentifiedObject object = (IdentifiedObject)this.objects.get(code);
        if (object == null && this.objects.containsKey(code)) {
            try {
                object = this.createObject(code);
                this.objects.put(code, object);
            }
            catch (FactoryException exception) {
                if (!this.isRecoverableFailure(exception)) {
                    throw new BackingStoreException(exception);
                }
                IdentifiedObjectSet.log(exception, code);
                this.objects.remove(code);
            }
        }
        return object;
    }

    public boolean contains(Object object) {
        String code = this.getAuthorityCode((IdentifiedObject)object);
        IdentifiedObject current = this.get(code);
        return object.equals(current);
    }

    public boolean remove(Object object) {
        String code = this.getAuthorityCode((IdentifiedObject)object);
        IdentifiedObject current = this.get(code);
        if (object.equals(current)) {
            this.objects.remove(code);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean modified = false;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            modified = true;
        }
        return modified;
    }

    public Iterator iterator() {
        return new Iter(this.objects.entrySet().iterator());
    }

    public void resolve(int n) throws FactoryException {
        if (n > 0) {
            try {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    it.next();
                    if (--n != 0) continue;
                    break;
                }
            }
            catch (BackingStoreException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof FactoryException) {
                    throw (FactoryException)cause;
                }
                throw exception;
            }
        }
    }

    public String[] getAuthorityCodes() {
        Set codes = this.objects.keySet();
        return codes.toArray(new String[codes.size()]);
    }

    public void setAuthorityCodes(String[] codes) {
        HashMap copy = new HashMap(this.objects);
        this.objects.clear();
        for (int i = 0; i < codes.length; ++i) {
            String code = codes[i];
            this.objects.put(code, (IdentifiedObject)copy.get(code));
        }
    }

    protected String getAuthorityCode(IdentifiedObject object) {
        Set identifiers = object.getIdentifiers();
        Object id = identifiers != null && !identifiers.isEmpty() ? (Identifier)identifiers.iterator().next() : object.getName();
        return id.getCode();
    }

    protected IdentifiedObject createObject(String code) throws FactoryException {
        return this.factory.createObject(code);
    }

    protected boolean isRecoverableFailure(FactoryException exception) {
        return exception instanceof NoSuchIdentifierException;
    }

    static void log(FactoryException exception, String code) {
        LogRecord record = new LogRecord(Level.FINE, "Failed to create an object for code \"" + code + "\".");
        record.setSourceClassName(IdentifiedObjectSet.class.getName());
        record.setSourceMethodName("createObject");
        record.setThrown(exception);
        AbstractAuthorityFactory.LOGGER.log(record);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashSet(this);
    }

    private final class Iter
    implements Iterator {
        private final Iterator iterator;
        private IdentifiedObject element;

        public Iter(Iterator iterator) {
            this.iterator = iterator;
            this.toNext();
        }

        private void toNext() throws BackingStoreException {
            while (this.iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)this.iterator.next();
                this.element = (IdentifiedObject)entry.getValue();
                if (this.element == null) {
                    String code = (String)entry.getKey();
                    try {
                        this.element = IdentifiedObjectSet.this.createObject(code);
                    }
                    catch (FactoryException exception) {
                        if (!IdentifiedObjectSet.this.isRecoverableFailure(exception)) {
                            throw new BackingStoreException(exception);
                        }
                        IdentifiedObjectSet.log(exception, code);
                        this.iterator.remove();
                        continue;
                    }
                    entry.setValue(this.element);
                }
                return;
            }
            this.element = null;
        }

        public boolean hasNext() {
            return this.element != null;
        }

        public Object next() throws NoSuchElementException {
            IdentifiedObject next = this.element;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.toNext();
            return next;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

