/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import javax.units.Converter;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.measure.Units;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.CodeList;

public class Parameter
extends AbstractParameter
implements ParameterValue {
    private static final long serialVersionUID = -5837826787089486776L;
    private static final int[] CACHED_VALUES = new int[]{-360, -180, -90, -45, -30, -4, -3, -2, -1, 0, 1, 2, 3, 4, 30, 45, 90, 180, 360};
    private static final Integer[] CACHED_INTEGERS = new Integer[CACHED_VALUES.length];
    private static final Double[] CACHED_DOUBLES = new Double[CACHED_VALUES.length];
    private static final Class[] STRING_ARGUMENT;
    private Object value;
    private Unit unit;

    public Parameter(String name, int value) {
        this(new DefaultParameterDescriptor(name, 0, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.value = Parameter.wrap(value);
    }

    public Parameter(String name, double value, Unit unit) {
        this(new DefaultParameterDescriptor(name, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Parameter.normalize(unit)));
        this.value = Parameter.wrap(value);
        this.unit = unit;
    }

    public Parameter(String name, CodeList value) {
        this(new DefaultParameterDescriptor(name, value.getClass(), (CodeList)null));
        this.value = value;
    }

    public Parameter(ParameterDescriptor descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        this.value = descriptor.getDefaultValue();
        this.unit = descriptor.getUnit();
    }

    public Parameter(ParameterDescriptor descriptor, Object value) throws InvalidParameterValueException {
        super((GeneralParameterDescriptor)descriptor);
        this.unit = descriptor.getUnit();
        this.setValue(value);
    }

    static Integer wrap(int value) {
        int i = Arrays.binarySearch(CACHED_VALUES, value);
        return i >= 0 ? CACHED_INTEGERS[i] : new Integer(value);
    }

    static Double wrap(double value) {
        int i;
        int integer = (int)value;
        if ((double)integer == value && (i = Arrays.binarySearch(CACHED_VALUES, integer)) >= 0) {
            return CACHED_DOUBLES[i];
        }
        return new Double(value);
    }

    static Comparable replace(Comparable value) {
        Number[] CACHED;
        if (value instanceof Double) {
            CACHED = CACHED_DOUBLES;
        } else if (value instanceof Integer) {
            CACHED = CACHED_INTEGERS;
        } else {
            return value;
        }
        int i = Arrays.binarySearch(CACHED, value);
        return i >= 0 ? CACHED[i] : value;
    }

    private static Unit normalize(Unit unit) {
        if (unit != null) {
            if (SI.METER.isCompatible(unit)) {
                return SI.METER;
            }
            if (NonSI.DAY.isCompatible(unit)) {
                return NonSI.DAY;
            }
            if (NonSI.DEGREE_ANGLE.isCompatible(unit)) {
                return NonSI.DEGREE_ANGLE;
            }
        }
        return unit;
    }

    public static void ensureValidValue(ParameterDescriptor descriptor, Object value) throws InvalidParameterValueException {
        String error;
        if (value == null) {
            return;
        }
        if (!descriptor.getValueClass().isAssignableFrom(value.getClass())) {
            error = Errors.format(51, Utilities.getShortClassName(value));
        } else {
            Comparable minimum = descriptor.getMinimumValue();
            Comparable maximum = descriptor.getMaximumValue();
            if (minimum != null && minimum.compareTo(value) > 0 || maximum != null && maximum.compareTo(value) < 0) {
                error = Errors.format(145, value, minimum, maximum);
            } else {
                Set validValues = descriptor.getValidValues();
                if (validValues != null && !validValues.contains(value)) {
                    error = Errors.format(42, Parameter.getName((GeneralParameterDescriptor)descriptor), value);
                } else {
                    return;
                }
            }
        }
        throw new InvalidParameterValueException(error, Parameter.getName((GeneralParameterDescriptor)descriptor), value);
    }

    private String getClassTypeError() {
        return Errors.format(51, Utilities.getShortName(((ParameterDescriptor)this.descriptor).getValueClass()));
    }

    public Unit getUnit() {
        return this.unit;
    }

    static int getUnitMessageID(Unit unit) {
        if (Unit.ONE.equals((Object)unit) || Units.PPM.equals((Object)unit)) {
            return 176;
        }
        if (SI.METER.isCompatible(unit)) {
            return 83;
        }
        if (SI.SECOND.isCompatible(unit)) {
            return 84;
        }
        if (SI.RADIAN.isCompatible(unit)) {
            return 77;
        }
        return 54;
    }

    public double doubleValue(Unit unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int expectedID = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        return this.unit.getConverterTo(unit).convert(this.doubleValue());
    }

    public double doubleValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public int intValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public boolean booleanValue() throws InvalidParameterTypeException {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public String stringValue() throws InvalidParameterTypeException {
        if (this.value instanceof CharSequence) {
            return this.value.toString();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public double[] doubleValueList(Unit unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int expectedID = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        Converter converter = this.unit.getConverterTo(unit);
        double[] values = (double[])this.doubleValueList().clone();
        for (int i = 0; i < values.length; ++i) {
            values[i] = converter.convert(values[i]);
        }
        return values;
    }

    public double[] doubleValueList() throws InvalidParameterTypeException {
        if (this.value instanceof double[]) {
            return (double[])this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public int[] intValueList() throws InvalidParameterTypeException {
        if (this.value instanceof int[]) {
            return (int[])this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    public URI valueFile() throws InvalidParameterTypeException {
        if (this.value instanceof URI) {
            return (URI)this.value;
        }
        if (this.value instanceof File) {
            return ((File)this.value).toURI();
        }
        URISyntaxException cause = null;
        try {
            if (this.value instanceof URL) {
                return new URI(this.value.toString());
            }
            if (this.value instanceof String) {
                return new URI((String)this.value);
            }
        }
        catch (URISyntaxException exception) {
            cause = exception;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(71, name));
        }
        InvalidParameterTypeException exception = new InvalidParameterTypeException(this.getClassTypeError(), name);
        if (cause != null) {
            exception.initCause((Throwable)cause);
        }
        throw exception;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(double value, Unit unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        Unit targetUnit = ((ParameterDescriptor)this.descriptor).getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(targetUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new InvalidParameterValueException(Errors.format(expectedID, unit), this.descriptor.getName().getCode(), value);
        }
        Double converted = Parameter.wrap(unit.getConverterTo(targetUnit).convert(value));
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, converted);
        this.value = Parameter.wrap(value);
        this.unit = unit;
    }

    public void setValue(double value) throws InvalidParameterValueException {
        Double check = Parameter.wrap(value);
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, check);
        this.value = check;
    }

    public void setValue(int value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Class type = descriptor.getValueClass();
        if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
            this.setValue((double)value);
            return;
        }
        Integer check = Parameter.wrap(value);
        Parameter.ensureValidValue(descriptor, check);
        this.value = check;
    }

    public void setValue(boolean value) throws InvalidParameterValueException {
        Boolean check = value;
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, check);
        this.value = check;
    }

    public void setValue(Object value) throws InvalidParameterValueException {
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, value);
        this.value = value;
    }

    public void setValue(double[] values, Unit unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        Unit targetUnit = ((ParameterDescriptor)this.descriptor).getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(targetUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        double[] converted = (double[])values.clone();
        Converter converter = unit.getConverterTo(targetUnit);
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = converter.convert(converted[i]);
        }
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, converted);
        this.value = values;
        this.unit = unit;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter that = (Parameter)object;
            return Utilities.equals(this.value, that.value) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    public int hashCode() {
        int code = super.hashCode() * 37;
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.unit != null) {
            code += 37 * this.unit.hashCode();
        }
        return code ^ 0x9F456C48;
    }

    static {
        for (int i = 0; i < CACHED_VALUES.length; ++i) {
            Parameter.CACHED_INTEGERS[i] = new Integer(CACHED_VALUES[i]);
            Parameter.CACHED_DOUBLES[i] = new Double(CACHED_VALUES[i]);
        }
        STRING_ARGUMENT = new Class[]{String.class};
    }
}

