/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.util.ObjectCache;

final class WeakObjectCache
implements ObjectCache {
    private final Map cache;
    private final Map locks;

    public WeakObjectCache() {
        this(50);
    }

    public WeakObjectCache(int initialSize) {
        this.cache = Collections.synchronizedMap(new HashMap(initialSize));
        this.locks = new HashMap();
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean containsKey(Object key) {
        if (this.cache.containsKey(key)) {
            Object stored = this.cache.get(key);
            if (stored instanceof Reference) {
                Reference reference = (Reference)stored;
                return reference.get() != null;
            }
            return stored != null;
        }
        return false;
    }

    public Object get(Object key) {
        Object stored = this.cache.get(key);
        if (stored instanceof Reference) {
            Reference reference = (Reference)stored;
            Object value = reference.get();
            if (value == null) {
                this.cache.remove(key);
            }
            return value;
        }
        return stored;
    }

    public Object peek(Object key) {
        Object stored = this.cache.get(key);
        if (stored instanceof Reference) {
            Reference reference = (Reference)stored;
            return reference.get();
        }
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLock(Object key) {
        ReentrantLock lock;
        Map map = this.locks;
        synchronized (map) {
            lock = (ReentrantLock)this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
        }
        try {
            lock.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnLock(Object key) {
        Map map = this.locks;
        synchronized (map) {
            ReentrantLock lock = (ReentrantLock)this.locks.get(key);
            if (lock == null) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            if (lock.holds() == 0L) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean holdsLock(Object key) {
        Map map = this.locks;
        synchronized (map) {
            ReentrantLock lock = (ReentrantLock)this.locks.get(key);
            if (lock != null) {
                return lock.holds() != 0L;
            }
        }
        return false;
    }

    public void put(Object key, Object object) {
        this.writeLock(key);
        WeakReference<Object> reference = new WeakReference<Object>(object);
        this.cache.put(key, reference);
        this.writeUnLock(key);
    }
}

