/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class KeySortedList
extends AbstractSequentialList
implements Serializable {
    private static final long serialVersionUID = 6969483179756527012L;
    private final SortedMap map;

    public KeySortedList() {
        this.map = new TreeMap();
    }

    private KeySortedList(SortedMap map) {
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        int count = 0;
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            count += ((List)it.next()).size();
        }
        return count;
    }

    public void add(Comparable key, Object element) {
        ArrayList<Object> values = (ArrayList<Object>)this.map.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            this.map.put(key, values);
        }
        values.add(element);
    }

    public int removeAll(Comparable key) {
        List values = (List)this.map.remove(key);
        return values != null ? values.size() : 0;
    }

    public int count(Comparable key) {
        List values = (List)this.map.get(key);
        return values != null ? values.size() : 0;
    }

    public boolean containsKey(Comparable key) {
        return this.map.containsKey(key);
    }

    public Object first(Comparable key) throws NoSuchElementException {
        List values = (List)this.map.get(key);
        if (values == null || values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return values.get(0);
    }

    public Object last(Comparable key) throws NoSuchElementException {
        List values = (List)this.map.get(key);
        if (values == null || values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return values.get(values.size() - 1);
    }

    public ListIterator listIterator(Comparable fromKey) {
        return new Iter(fromKey);
    }

    public ListIterator listIterator(int index) {
        return new Iter(index);
    }

    public KeySortedList headList(Comparable toKey) {
        return new KeySortedList(this.map.headMap(toKey));
    }

    public KeySortedList tailList(Comparable fromKey) {
        return new KeySortedList(this.map.tailMap(fromKey));
    }

    private final class Iter
    implements ListIterator {
        private Iterator entriesIter;
        private Comparable key;
        private List values;
        private ListIterator valuesIter;
        private int base;

        public Iter(Comparable fromKey) {
            for (Map.Entry entry : KeySortedList.this.map.entrySet()) {
                this.key = (Comparable)entry.getKey();
                this.values = (List)entry.getValue();
                if (fromKey.compareTo(this.key) <= 0) {
                    this.valuesIter = this.values.listIterator();
                    assert (this.equals(new Iter(this.base)));
                    return;
                }
                this.base += this.values.size();
            }
            this.key = null;
            this.values = Collections.EMPTY_LIST;
            this.valuesIter = this.values.listIterator();
        }

        public Iter(int index) {
            for (Map.Entry entry : KeySortedList.this.map.entrySet()) {
                this.key = (Comparable)entry.getKey();
                this.values = (List)entry.getValue();
                int size = this.values.size();
                if (index < size) {
                    this.valuesIter = this.values.listIterator(index);
                    return;
                }
                index -= size;
                this.base += size;
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.key = null;
            this.values = Collections.EMPTY_LIST;
            this.valuesIter = this.values.listIterator();
        }

        public boolean hasNext() {
            return this.valuesIter.hasNext() || this.entriesIter.hasNext();
        }

        public Object next() {
            while (!this.valuesIter.hasNext()) {
                if (this.entriesIter.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.entriesIter.next();
                    this.base += this.values.size();
                    this.key = (Comparable)entry.getKey();
                    this.values = (List)entry.getValue();
                    this.valuesIter = this.values.listIterator();
                    continue;
                }
                this.key = null;
                this.values = Collections.EMPTY_LIST;
                this.valuesIter = this.values.listIterator();
                break;
            }
            return this.valuesIter.next();
        }

        public boolean hasPrevious() {
            return this.valuesIter.hasPrevious() || this.base != 0;
        }

        public Object previous() {
            while (!this.valuesIter.hasPrevious() && this.base != 0) {
                this.key = KeySortedList.this.map.headMap(this.key).lastKey();
                this.entriesIter = KeySortedList.this.map.tailMap(this.key).entrySet().iterator();
                Map.Entry entry = (Map.Entry)this.entriesIter.next();
                assert (this.key == entry.getKey()) : this.key;
                this.values = (List)entry.getValue();
                int size = this.values.size();
                this.valuesIter = this.values.listIterator(Math.max(size - 1, 0));
                this.base -= size;
                assert (this.base >= 0) : this.base;
            }
            return this.valuesIter.previous();
        }

        public int nextIndex() {
            return this.base + this.valuesIter.nextIndex();
        }

        public int previousIndex() {
            return this.base + this.valuesIter.previousIndex();
        }

        public void remove() {
            this.valuesIter.remove();
        }

        public void set(Object o) {
            this.valuesIter.set(o);
        }

        public void add(Object o) {
            this.valuesIter.add(o);
        }

        private boolean equals(Iter that) {
            return this.key == that.key && this.values == that.values && this.base == that.base && this.valuesIter.nextIndex() == that.valuesIter.nextIndex();
        }
    }
}

